/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.model.utils.GZipUtils;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ApkSizeUtils {
    public static ImmutableMap<String, Long> getVariantCompressedSizeByApkPaths(ImmutableList<Commands.Variant> variants, Path apksArchive) {
        ImmutableList apkPaths = (ImmutableList)variants.stream().flatMap(variant -> variant.getApkSetList().stream()).flatMap(apkSet -> apkSet.getApkDescriptionList().stream()).map(Commands.ApkDescription::getPath).distinct().collect(ImmutableList.toImmutableList());
        return ApkSizeUtils.getCompressedSizeByApkPaths((ImmutableList<String>)apkPaths, apksArchive);
    }

    public static ImmutableMap<String, Long> getCompressedSizeByApkPaths(ImmutableList<String> apkPaths, Path apksArchive) {
        ImmutableMap.Builder sizeByApkPath = ImmutableMap.builder();
        try (ZipFile apksZip = new ZipFile(apksArchive.toFile());){
            for (String apkPath : apkPaths) {
                ZipEntry entry = (ZipEntry)Preconditions.checkNotNull((Object)apksZip.getEntry(apkPath));
                long size = Math.min(entry.getSize(), GZipUtils.calculateGzipCompressedSize(ZipUtils.asByteSource(apksZip, entry)));
                sizeByApkPath.put((Object)apkPath, (Object)size);
            }
        }
        catch (IOException e11) {
            throw new UncheckedIOException(String.format("Error while processing the APK Set archive '%s'.", apksArchive), e11);
        }
        return sizeByApkPath.build();
    }

    private ApkSizeUtils() {
    }
}

