/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.manifestelements;

import com.android.tools.build.bundletool.model.manifestelements.;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class IntentFilter {
    abstract ImmutableList<String> getActionNames();

    abstract ImmutableList<String> getCategoryNames();

    public static Builder builder() {
        return new .AutoValue_IntentFilter.Builder();
    }

    public XmlProtoElement asXmlProtoElement() {
        XmlProtoElementBuilder elementBuilder = XmlProtoElementBuilder.create("intent-filter");
        this.addAllActionElements(elementBuilder);
        this.addCategoryElement(elementBuilder);
        return elementBuilder.build();
    }

    private void addAllActionElements(XmlProtoElementBuilder elementBuilder) {
        for (String actionName : this.getActionNames()) {
            elementBuilder.addChildElement(XmlProtoElementBuilder.create("action").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(actionName)));
        }
    }

    private void addCategoryElement(XmlProtoElementBuilder elementBuilder) {
        for (String categoryName : this.getCategoryNames()) {
            elementBuilder.addChildElement(XmlProtoElementBuilder.create("category").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(categoryName)));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract ImmutableList.Builder<String> actionNamesBuilder();

        public final Builder addActionName(String value) {
            this.actionNamesBuilder().add((Object)value);
            return this;
        }

        abstract ImmutableList.Builder<String> categoryNamesBuilder();

        public final Builder addCategoryName(String value) {
            this.categoryNamesBuilder().add((Object)value);
            return this;
        }

        public abstract IntentFilter build();
    }
}

