/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public final class RuntimeEnabledSdkVersionEncoder {
    @VisibleForTesting
    static final int VERSION_MAJOR_OFFSET = 10000;
    public static final int VERSION_MAJOR_MAX_VALUE = 199999;
    public static final int VERSION_MINOR_MAX_VALUE = 9999;
    public static final int SDK_PATCH_VERSION_MAX_VALUE = 9999;

    public static int encodeSdkMajorAndMinorVersion(int versionMajor, int versionMinor) {
        Preconditions.checkArgument((versionMajor >= 0 && versionMajor <= 199999 ? 1 : 0) != 0, (Object)"SDK major version must be an integer between 0 and 199999");
        Preconditions.checkArgument((versionMinor >= 0 && versionMinor <= 9999 ? 1 : 0) != 0, (Object)"SDK minor version must be an integer between 0 and 9999");
        return 10000 * versionMajor + versionMinor;
    }

    private RuntimeEnabledSdkVersionEncoder() {
    }
}

