/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AutoValue_ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.DeviceFeatureCondition;
import com.android.tools.build.bundletool.model.DeviceGroupsCondition;
import com.android.tools.build.bundletool.model.ModuleConditions;
import com.android.tools.build.bundletool.model.UserCountriesCondition;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.android.tools.build.bundletool.model.utils.DeviceTargetingUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import java.util.Optional;
import java.util.stream.Collectors;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ManifestDeliveryElement {
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final ImmutableList<String> ASSET_MODULE_DELIVERY_ELEMENTS = ImmutableList.of((Object)"install-time", (Object)"on-demand", (Object)"fast-follow", (Object)"conditions");
    private static final ImmutableList<String> FEATURE_MODULE_DELIVERY_ELEMENTS = ImmutableList.of((Object)"install-time", (Object)"on-demand");
    private static final ImmutableList<String> KNOWN_INSTALL_TIME_ATTRIBUTES = ImmutableList.of((Object)"conditions", (Object)"removable");
    private static final ImmutableList<String> CONDITIONS_ALLOWED_ONLY_ONCE = ImmutableList.of((Object)"min-sdk", (Object)"max-sdk", (Object)"user-countries", (Object)"device-groups");

    abstract XmlProtoElement getDeliveryElement();

    abstract BundleModule.ModuleType getModuleType();

    public boolean isWellFormed() {
        return this.hasOnDemandElement() || this.hasInstallTimeElement() || this.getModuleType() == BundleModule.ModuleType.ASSET_MODULE && this.hasFastFollowElement();
    }

    public boolean hasModuleConditions() {
        return !this.getModuleConditions().isEmpty();
    }

    public boolean hasOnDemandElement() {
        return this.getDeliveryElement().getOptionalChildElement("http://schemas.android.com/apk/distribution", "on-demand").isPresent();
    }

    public boolean hasFastFollowElement() {
        return this.getDeliveryElement().getOptionalChildElement("http://schemas.android.com/apk/distribution", "fast-follow").isPresent();
    }

    public boolean hasInstallTimeElement() {
        return this.getInstallTimeElement().isPresent();
    }

    private Optional<XmlProtoElement> getInstallTimeElement() {
        return this.getDeliveryElement().getOptionalChildElement("http://schemas.android.com/apk/distribution", "install-time");
    }

    public Optional<Boolean> getInstallTimeRemovableValue() {
        return this.getInstallTimeElement().flatMap(installTime -> installTime.getOptionalChildElement("http://schemas.android.com/apk/distribution", "removable").map(removable -> removable.getAttribute("http://schemas.android.com/apk/distribution", "value").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean()).orElseThrow(() -> InvalidBundleException.createWithUserMessage("No attribute 'dist:value' found in element <dist:removable> of manifest. Make sure the namespace is also set."))));
    }

    public ModuleConditions getModuleConditions() {
        ImmutableList<XmlProtoElement> conditionElements = this.getModuleConditionElements(this.getInstallTimeElement());
        ManifestDeliveryElement.verifyUniqueConditions(conditionElements);
        ModuleConditions.Builder moduleConditions = ModuleConditions.builder();
        block14: for (XmlProtoElement conditionElement : conditionElements) {
            ManifestDeliveryElement.verifyDistributionNamespace(conditionElement);
            switch (conditionElement.getName()) {
                case "device-feature": {
                    moduleConditions.addDeviceFeatureCondition(this.parseDeviceFeatureCondition(conditionElement));
                    continue block14;
                }
                case "min-sdk": {
                    moduleConditions.setMinSdkVersion(ManifestDeliveryElement.parseMinSdkVersionCondition(conditionElement));
                    continue block14;
                }
                case "max-sdk": {
                    moduleConditions.setMaxSdkVersion(ManifestDeliveryElement.parseMaxSdkVersionCondition(conditionElement));
                    continue block14;
                }
                case "user-countries": {
                    moduleConditions.setUserCountriesCondition(this.parseUserCountriesCondition(conditionElement));
                    continue block14;
                }
                case "device-groups": {
                    moduleConditions.setDeviceGroupsCondition(this.parseDeviceGroupsCondition(conditionElement));
                    continue block14;
                }
            }
            throw InvalidBundleException.builder().withUserMessage("Unrecognized module condition: '%s'", conditionElement.getName()).build();
        }
        ModuleConditions processedModuleConditions = moduleConditions.build();
        if (processedModuleConditions.getMinSdkVersion().isPresent() && processedModuleConditions.getMaxSdkVersion().isPresent() && processedModuleConditions.getMinSdkVersion().get() > processedModuleConditions.getMaxSdkVersion().get()) {
            throw InvalidBundleException.builder().withUserMessage("Illegal SDK-based conditional module targeting (min SDK must be less than or equal to max SD). Provided min and max values, respectively, are %s and %s", processedModuleConditions.getMinSdkVersion(), processedModuleConditions.getMaxSdkVersion()).build();
        }
        return processedModuleConditions;
    }

    public Targeting.AssetModuleTargeting getAssetModuleConditions() {
        ImmutableList<XmlProtoElement> conditionElements = this.getModuleConditionElements(Optional.of(this.getDeliveryElement()));
        ManifestDeliveryElement.verifyUniqueConditions(conditionElements);
        Targeting.AssetModuleTargeting.Builder targetingBuilder = Targeting.AssetModuleTargeting.newBuilder();
        block8: for (XmlProtoElement conditionElement : conditionElements) {
            ManifestDeliveryElement.verifyDistributionNamespace(conditionElement);
            switch (conditionElement.getName()) {
                case "user-countries": {
                    targetingBuilder.setUserCountriesTargeting(this.parseUserCountriesCondition(conditionElement).toTargeting());
                    continue block8;
                }
                case "device-groups": {
                    targetingBuilder.setDeviceGroupTargeting(this.parseDeviceGroupsCondition(conditionElement).toTargeting());
                    continue block8;
                }
            }
            throw InvalidBundleException.builder().withUserMessage("Unrecognized module condition: '%s'", conditionElement.getName()).build();
        }
        return targetingBuilder.build();
    }

    private static void verifyDistributionNamespace(XmlProtoElement conditionElement) {
        if (!conditionElement.getNamespaceUri().equals("http://schemas.android.com/apk/distribution")) {
            throw InvalidBundleException.builder().withUserMessage("Invalid namespace found in the module condition element. Expected '%s'; found '%s'.", "http://schemas.android.com/apk/distribution", conditionElement.getNamespaceUri()).build();
        }
    }

    private static void verifyUniqueConditions(ImmutableList<XmlProtoElement> conditionElements) {
        ImmutableMap<String, Long> conditionCounts = conditionElements.stream().collect(CollectorUtils.groupingByDeterministic(rec$ -> ((XmlProtoElement)rec$).getName(), Collectors.counting()));
        for (String conditionName : CONDITIONS_ALLOWED_ONLY_ONCE) {
            if ((Long)conditionCounts.getOrDefault((Object)conditionName, (Object)0L) <= 1L) continue;
            throw InvalidBundleException.builder().withUserMessage("Multiple '<dist:%s>' conditions are not supported.", conditionName).build();
        }
    }

    private UserCountriesCondition parseUserCountriesCondition(XmlProtoElement conditionElement) {
        ImmutableList.Builder countryCodes = ImmutableList.builder();
        for (XmlProtoElement countryElement : (ImmutableList)conditionElement.getChildrenElements().collect(ImmutableList.toImmutableList())) {
            if (!countryElement.getName().equals("country")) {
                throw InvalidBundleException.builder().withUserMessage("Expected only <dist:country> elements inside <dist:user-countries>, but found %s", ManifestDeliveryElement.printElement(conditionElement)).build();
            }
            countryCodes.add((Object)countryElement.getAttribute("http://schemas.android.com/apk/distribution", "code").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).map(String::toUpperCase).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("<dist:country> element is expected to have 'dist:code' attribute but found none.").build()));
        }
        boolean exclude = conditionElement.getAttribute("http://schemas.android.com/apk/distribution", "exclude").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean()).orElse(false);
        return UserCountriesCondition.create((ImmutableList<String>)countryCodes.build(), exclude);
    }

    private DeviceGroupsCondition parseDeviceGroupsCondition(XmlProtoElement conditionElement) {
        ImmutableList children = (ImmutableList)conditionElement.getChildrenElements().collect(ImmutableList.toImmutableList());
        if (children.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("At least one device group should be specified in '<dist:%s>' element.", "device-groups").build();
        }
        ImmutableSet.Builder deviceGroups = ImmutableSet.builder();
        for (XmlProtoElement deviceGroupElement : children) {
            if (!deviceGroupElement.getName().equals("device-group")) {
                throw InvalidBundleException.builder().withUserMessage("Expected only '<dist:%s>' elements inside '<dist:%s>', but found %s.", "device-group", "device-groups", ManifestDeliveryElement.printElement(deviceGroupElement)).build();
            }
            String groupName = deviceGroupElement.getAttribute("http://schemas.android.com/apk/distribution", "name").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("'<dist:%s>' element is expected to have 'dist:%s' attribute but found none.", "device-group", "name").build());
            DeviceTargetingUtils.validateDeviceGroupForConditionalModule(groupName);
            deviceGroups.add((Object)groupName);
        }
        return DeviceGroupsCondition.create((ImmutableSet<String>)deviceGroups.build());
    }

    private static void validateDeliveryElement(XmlProtoElement deliveryElement, BundleModule.ModuleType moduleType) {
        ManifestDeliveryElement.validateDeliveryElementChildren(deliveryElement, moduleType);
        ManifestDeliveryElement.validateInstallTimeElement(deliveryElement.getOptionalChildElement("http://schemas.android.com/apk/distribution", "install-time"));
        ManifestDeliveryElement.validateOnDemandElement(deliveryElement.getOptionalChildElement("http://schemas.android.com/apk/distribution", "on-demand"));
        if (moduleType == BundleModule.ModuleType.ASSET_MODULE) {
            ManifestDeliveryElement.validateFastFollowElement(deliveryElement.getOptionalChildElement("http://schemas.android.com/apk/distribution", "fast-follow"));
        }
    }

    private static void validateDeliveryElementChildren(XmlProtoElement deliveryElement, BundleModule.ModuleType moduleType) {
        ImmutableList<String> allowedDeliveryElements = moduleType == BundleModule.ModuleType.ASSET_MODULE ? ASSET_MODULE_DELIVERY_ELEMENTS : FEATURE_MODULE_DELIVERY_ELEMENTS;
        Optional offendingElement = deliveryElement.getChildrenElements(child -> !child.getNamespaceUri().equals("http://schemas.android.com/apk/distribution") || !allowedDeliveryElements.contains((Object)child.getName())).findAny();
        if (offendingElement.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Expected <dist:delivery> element to contain only %s elements but found: %s", allowedDeliveryElements.stream().map(name -> String.format("<dist:%s>", name)).collect(Collectors.joining(", ")), ManifestDeliveryElement.printElement((XmlProtoElement)offendingElement.get())).build();
        }
    }

    private static void validateInstallTimeElement(Optional<XmlProtoElement> installTimeElement) {
        Optional offendingElement = installTimeElement.flatMap(installTime -> installTime.getChildrenElements(child -> !child.getNamespaceUri().equals("http://schemas.android.com/apk/distribution") || !KNOWN_INSTALL_TIME_ATTRIBUTES.contains((Object)child.getName())).findAny());
        if (offendingElement.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Expected <dist:install-time> element to contain only <dist:conditions> or <dist:removable> element but found: %s.", ManifestDeliveryElement.printElement((XmlProtoElement)offendingElement.get())).build();
        }
    }

    private static void validateOnDemandElement(Optional<XmlProtoElement> onDemandElement) {
        Optional offendingChild = onDemandElement.flatMap(element -> element.getChildrenElements().findAny());
        if (offendingChild.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Expected <dist:on-demand> element to have no child elements but found: %s.", ManifestDeliveryElement.printElement((XmlProtoElement)offendingChild.get())).build();
        }
    }

    private static void validateFastFollowElement(Optional<XmlProtoElement> fastFollowElement) {
        Optional offendingChild = fastFollowElement.flatMap(element -> element.getChildrenElements().findAny());
        if (offendingChild.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Expected <dist:fast-follow> element to have no child elements but found: %s.", ManifestDeliveryElement.printElement((XmlProtoElement)offendingChild.get())).build();
        }
    }

    private ImmutableList<XmlProtoElement> getModuleConditionElements(Optional<XmlProtoElement> parentElement) {
        return parentElement.flatMap(installTime -> installTime.getOptionalChildElement("http://schemas.android.com/apk/distribution", "conditions")).map(conditions -> (ImmutableList)conditions.getChildrenElements().collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    private DeviceFeatureCondition parseDeviceFeatureCondition(XmlProtoElement conditionElement) {
        return DeviceFeatureCondition.create(((XmlProtoAttribute)conditionElement.getAttribute("http://schemas.android.com/apk/distribution", "name").orElseThrow(() -> InvalidBundleException.createWithUserMessage("Missing required 'dist:name' attribute in the 'device-feature' condition element."))).getValueAsString(), conditionElement.getAttribute("http://schemas.android.com/apk/distribution", VERSION_ATTRIBUTE_NAME).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsInteger()));
    }

    private static int parseMinSdkVersionCondition(XmlProtoElement conditionElement) {
        return ((XmlProtoAttribute)conditionElement.getAttribute("http://schemas.android.com/apk/distribution", "value").orElseThrow(() -> InvalidBundleException.createWithUserMessage("Missing required 'dist:value' attribute in the 'min-sdk' condition element."))).getValueAsDecimalInteger();
    }

    private static int parseMaxSdkVersionCondition(XmlProtoElement conditionElement) {
        return ((XmlProtoAttribute)conditionElement.getAttribute("http://schemas.android.com/apk/distribution", "value").orElseThrow(() -> InvalidBundleException.createWithUserMessage("Missing required 'dist:value' attribute in the 'max-sdk' condition element."))).getValueAsDecimalInteger();
    }

    private static String printElement(XmlProtoElement element) {
        if (element.getNamespaceUri().isEmpty()) {
            return String.format("'%s' with namespace not provided", element.getName());
        }
        return String.format("'%s' with namespace URI: '%s'", element.getName(), element.getNamespaceUri());
    }

    public static Optional<ManifestDeliveryElement> fromManifestElement(XmlProtoElement manifestElement, BundleModule.ModuleType moduleType) {
        return ManifestDeliveryElement.fromManifestElement(manifestElement, "delivery", moduleType);
    }

    private static Optional<ManifestDeliveryElement> fromManifestElement(XmlProtoElement manifestElement, String deliveryTag, BundleModule.ModuleType moduleType) {
        return manifestElement.getOptionalChildElement("http://schemas.android.com/apk/distribution", "module").flatMap(elem -> elem.getOptionalChildElement("http://schemas.android.com/apk/distribution", deliveryTag)).map(elem -> {
            ManifestDeliveryElement.validateDeliveryElement(elem, moduleType);
            return new AutoValue_ManifestDeliveryElement((XmlProtoElement)elem, moduleType);
        });
    }

    public static Optional<ManifestDeliveryElement> instantFromManifestElement(XmlProtoElement manifestElement, BundleModule.ModuleType moduleType) {
        return ManifestDeliveryElement.fromManifestElement(manifestElement, "instant-delivery", moduleType);
    }

    @VisibleForTesting
    static Optional<ManifestDeliveryElement> fromManifestRootNode(Resources.XmlNode xmlNode, BundleModule.ModuleType moduleType) {
        return ManifestDeliveryElement.fromManifestElement((XmlProtoElement)new XmlProtoNode(xmlNode).getElement(), moduleType);
    }

    @VisibleForTesting
    static Optional<ManifestDeliveryElement> instantFromManifestRootNode(Resources.XmlNode xmlNode, BundleModule.ModuleType moduleType) {
        return ManifestDeliveryElement.instantFromManifestElement((XmlProtoElement)new XmlProtoNode(xmlNode).getElement(), moduleType);
    }
}

