/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.tools.build.bundletool.commands.AddTransparencyCommand;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.tools.build.bundletool.commands.BuildSdkApksCommand;
import com.android.tools.build.bundletool.commands.BuildSdkApksForAppCommand;
import com.android.tools.build.bundletool.commands.BuildSdkAsarCommand;
import com.android.tools.build.bundletool.commands.BuildSdkBundleCommand;
import com.android.tools.build.bundletool.commands.CheckTransparencyCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.DumpCommand;
import com.android.tools.build.bundletool.commands.DumpSdkBundleCommand;
import com.android.tools.build.bundletool.commands.EvaluateDeviceTargetingConfigCommand;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.tools.build.bundletool.commands.GetDeviceSpecCommand;
import com.android.tools.build.bundletool.commands.GetSizeCommand;
import com.android.tools.build.bundletool.commands.InstallApksCommand;
import com.android.tools.build.bundletool.commands.InstallMultiApksCommand;
import com.android.tools.build.bundletool.commands.PrintDeviceTargetingConfigCommand;
import com.android.tools.build.bundletool.commands.ValidateBundleCommand;
import com.android.tools.build.bundletool.commands.VersionCommand;
import com.android.tools.build.bundletool.device.DdmlibAdbServer;
import com.android.tools.build.bundletool.flags.FlagParser;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

public final class BundleToolMain {
    public static final String HELP_CMD = "help";
    private static final ImmutableList<CommandHelp> COMMAND_HELPS = ImmutableList.of((Object)BuildBundleCommand.help(), (Object)BuildApksCommand.help(), (Object)BuildSdkBundleCommand.help(), (Object)BuildSdkApksCommand.help(), (Object)BuildSdkApksForAppCommand.help(), (Object)BuildSdkAsarCommand.help(), (Object)PrintDeviceTargetingConfigCommand.help(), (Object)EvaluateDeviceTargetingConfigCommand.help(), (Object)ExtractApksCommand.help(), (Object)GetDeviceSpecCommand.help(), (Object)InstallApksCommand.help(), (Object)InstallMultiApksCommand.help(), (Object[])new CommandHelp[]{ValidateBundleCommand.help(), DumpCommand.help(), DumpSdkBundleCommand.help(), GetSizeCommand.help(), VersionCommand.help(), AddTransparencyCommand.help(), CheckTransparencyCommand.help()});

    public static void main(String[] args) {
        BundleToolMain.main(args, Runtime.getRuntime());
    }

    static void main(String[] args, Runtime runtime) {
        ParsedFlags flags;
        try {
            flags = new FlagParser().parse(args);
        }
        catch (FlagParser.FlagParseException e11) {
            System.err.println("Error while parsing the flags: " + e11.getMessage());
            runtime.exit(1);
            return;
        }
        Optional<String> command = flags.getMainCommand();
        if (!command.isPresent()) {
            System.err.println("Error: You have to specify a command.");
            BundleToolMain.help();
            runtime.exit(1);
            return;
        }
        try {
            switch (command.get()) {
                case "build-bundle": {
                    BuildBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-apks": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        BuildApksCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "build-sdk-bundle": {
                    BuildSdkBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-sdk-apks": {
                    BuildSdkApksCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-sdk-apks-for-app": {
                    BuildSdkApksForAppCommand.fromFlags(flags).execute();
                    break;
                }
                case "build-sdk-asar": {
                    BuildSdkAsarCommand.fromFlags(flags).execute();
                    break;
                }
                case "print-device-targeting-config": {
                    PrintDeviceTargetingConfigCommand.fromFlags(flags).execute();
                    break;
                }
                case "evaluate-device-targeting-config": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        EvaluateDeviceTargetingConfigCommand.fromFlags(flags, adbServer).execute(System.out);
                        break;
                    }
                }
                case "extract-apks": {
                    ExtractApksCommand.fromFlags(flags).execute();
                    break;
                }
                case "get-device-spec": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        GetDeviceSpecCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "install-apks": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        InstallApksCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "install-multi-apks": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        InstallMultiApksCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "validate": {
                    ValidateBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "dump": {
                    DumpCommand.fromFlags(flags).execute();
                    break;
                }
                case "dump-sdk-bundle": {
                    DumpSdkBundleCommand.fromFlags(flags).execute();
                    break;
                }
                case "get-size": {
                    GetSizeCommand.fromFlags(flags).execute();
                    break;
                }
                case "version": {
                    VersionCommand.fromFlags(flags, System.out).execute();
                    break;
                }
                case "add-transparency": {
                    AddTransparencyCommand.fromFlags(flags).execute();
                    break;
                }
                case "check-transparency": {
                    try (DdmlibAdbServer adbServer = DdmlibAdbServer.getInstance();){
                        CheckTransparencyCommand.fromFlags(flags, adbServer).execute();
                        break;
                    }
                }
                case "help": {
                    if (flags.getSubCommand().isPresent()) {
                        BundleToolMain.help(flags.getSubCommand().get(), runtime);
                        break;
                    }
                    BundleToolMain.help();
                    break;
                }
                default: {
                    System.err.printf("Error: Unrecognized command '%s'.%n%n%n", command.get());
                    BundleToolMain.help();
                    runtime.exit(1);
                    return;
                }
            }
        }
        catch (Exception e12) {
            System.err.println("[BT:" + BundleToolVersion.getCurrentVersion() + "] Error: " + e12.getMessage());
            e12.printStackTrace();
            runtime.exit(1);
            return;
        }
        runtime.exit(0);
    }

    public static void help() {
        System.out.println("Synopsis: bundletool <command> ...");
        System.out.println();
        System.out.println("Use 'bundletool help <command>' to learn more about the given command.");
        System.out.println();
        COMMAND_HELPS.forEach(commandHelp -> commandHelp.printSummary(System.out));
    }

    public static void help(String commandName, Runtime runtime) {
        for (CommandHelp commandHelp : COMMAND_HELPS) {
            if (!commandHelp.getCommandName().equals(commandName)) continue;
            commandHelp.printDetails(System.out);
            return;
        }
        System.err.printf("Error: Unrecognized command '%s'.%n%n%n", commandName);
        BundleToolMain.help();
        runtime.exit(1);
    }

    private BundleToolMain() {
    }
}

