/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.CombinedInputStream;
import com.android.builder.merge.DuplicateRelativeFileException;
import com.android.builder.merge.MergeInput;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class StreamMergeAlgorithms {
    private StreamMergeAlgorithms() {
    }

    public static StreamMergeAlgorithm pickFirst() {
        return (path, from, closer) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            from.forEach(mergeInput -> closer.register((Closeable)mergeInput.getStream()));
            return ((MergeInput)from.get(0)).getStream();
        };
    }

    public static StreamMergeAlgorithm concat() {
        return (path, from, closer) -> {
            CombinedInputStream mergedStream = new CombinedInputStream(from, true);
            closer.register((Closeable)mergedStream);
            return mergedStream;
        };
    }

    public static StreamMergeAlgorithm acceptOnlyOne() {
        return (path, from, closer) -> {
            Preconditions.checkArgument((!from.isEmpty() ? 1 : 0) != 0, (Object)"from.isEmpty()");
            from.forEach(mergeInput -> closer.register((Closeable)mergeInput.getStream()));
            if (from.size() > 1) {
                throw new DuplicateRelativeFileException(path, from.stream().map(MergeInput::getName).collect(Collectors.toList()));
            }
            return ((MergeInput)from.get(0)).getStream();
        };
    }

    public static StreamMergeAlgorithm select(Function<String, StreamMergeAlgorithm> select) {
        return (path, from, closer) -> {
            StreamMergeAlgorithm algorithm = (StreamMergeAlgorithm)select.apply(path);
            assert (algorithm != null);
            return algorithm.merge(path, from, closer);
        };
    }
}

