/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.builder.internal.TemplateProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fH\u0016J\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/internal/TestManifestGenerator;", "", "outputFile", "Ljava/io/File;", "packageName", "", "minSdkVersion", "targetSdkVersion", "testedPackageName", "testRunnerName", "<init>", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "populateTemplateParameters", "", "map", "", "templateResourceName", "getTemplateResourceName", "()Ljava/lang/String;", "generate", "Companion", "builder"})
public abstract class TestManifestGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File outputFile;
    @NotNull
    private final String packageName;
    @Nullable
    private final String minSdkVersion;
    @Nullable
    private final String targetSdkVersion;
    @NotNull
    private final String testedPackageName;
    @Nullable
    private final String testRunnerName;
    @NotNull
    private static final String PH_PACKAGE = "#PACKAGE#";
    @NotNull
    private static final String PH_MIN_SDK_VERSION = "#MINSDKVERSION#";
    @NotNull
    private static final String PH_TARGET_SDK_VERSION = "#TARGETSDKVERSION#";
    @NotNull
    private static final String PH_TEST_RUNNER = "#TESTRUNNER#";
    @NotNull
    private static final String PH_TESTED_PACKAGE = "#TESTEDPACKAGE#";

    public TestManifestGenerator(@NotNull File outputFile, @NotNull String packageName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @NotNull String testedPackageName, @Nullable String testRunnerName) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)testedPackageName, (String)"testedPackageName");
        this.outputFile = outputFile;
        this.packageName = packageName;
        this.minSdkVersion = minSdkVersion;
        this.targetSdkVersion = targetSdkVersion;
        this.testedPackageName = testedPackageName;
        this.testRunnerName = testRunnerName;
    }

    public void populateTemplateParameters(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        map.put(PH_PACKAGE, this.packageName);
        Map<String, String> map2 = map;
        String string = PH_MIN_SDK_VERSION;
        String string2 = this.minSdkVersion;
        if (string2 == null) {
            string2 = "1";
        }
        String string3 = string2;
        map2.put(string, string3);
        map2 = map;
        string = PH_TARGET_SDK_VERSION;
        String string4 = this.targetSdkVersion;
        if (string4 == null) {
            string4 = map.get(PH_MIN_SDK_VERSION);
        }
        string3 = string4;
        map2.put(string, string3);
        map.put(PH_TEST_RUNNER, this.testRunnerName);
        map.put(PH_TESTED_PACKAGE, this.testedPackageName);
    }

    @NotNull
    public abstract String getTemplateResourceName();

    public final void generate() throws IOException {
        Map map = new HashMap();
        this.populateTemplateParameters(map);
        URL resource = TestManifestGenerator.class.getResource(this.getTemplateResourceName());
        if (resource == null) {
            throw new RuntimeException("Cannot find template, please file a bug.");
        }
        URLConnection urlConnection = resource.openConnection();
        urlConnection.setUseCaches(false);
        TemplateProcessor processor = new TemplateProcessor(urlConnection.getInputStream(), map);
        processor.generate(this.outputFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/builder/internal/TestManifestGenerator$Companion;", "", "<init>", "()V", "PH_PACKAGE", "", "PH_MIN_SDK_VERSION", "PH_TARGET_SDK_VERSION", "PH_TEST_RUNNER", "PH_TESTED_PACKAGE", "builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

