/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.DefaultApkSignerEngine;
import com.android.apksig.KeyConfig;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.v3.V3SchemeSigner;
import com.android.apksig.internal.apk.v3.V3SigningCertificateLineage;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.util.RandomAccessFileDataSink;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SigningCertificateLineage {
    public static final int MAGIC = 1056913873;
    private static final int FIRST_VERSION = 1;
    private static final int CURRENT_VERSION = 1;
    private static final int PAST_CERT_INSTALLED_DATA = 1;
    private static final int PAST_CERT_SHARED_USER_ID = 2;
    private static final int PAST_CERT_PERMISSION = 4;
    private static final int PAST_CERT_ROLLBACK = 8;
    private static final int PAST_CERT_AUTH = 16;
    private final int mMinSdkVersion;
    private final List<V3SigningCertificateLineage.SigningCertificateNode> mSigningLineage;

    private SigningCertificateLineage(int minSdkVersion, List<V3SigningCertificateLineage.SigningCertificateNode> list) {
        this.mMinSdkVersion = minSdkVersion;
        this.mSigningLineage = list;
    }

    private static SigningCertificateLineage createSigningLineage(int minSdkVersion, SignerConfig signer, SignerCapabilities capabilities) {
        SigningCertificateLineage signingCertificateLineage = new SigningCertificateLineage(minSdkVersion, new ArrayList<V3SigningCertificateLineage.SigningCertificateNode>());
        return signingCertificateLineage.spawnFirstDescendant(signer, capabilities);
    }

    private static SigningCertificateLineage createSigningLineage(int minSdkVersion, SignerConfig parent, SignerCapabilities parentCapabilities, SignerConfig child, SignerCapabilities childCapabilities) throws CertificateEncodingException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        SigningCertificateLineage signingCertificateLineage = new SigningCertificateLineage(minSdkVersion, new ArrayList<V3SigningCertificateLineage.SigningCertificateNode>());
        signingCertificateLineage = signingCertificateLineage.spawnFirstDescendant(parent, parentCapabilities);
        return signingCertificateLineage.spawnDescendant(parent, child, childCapabilities);
    }

    public static SigningCertificateLineage readFromBytes(byte[] lineageBytes) throws IOException {
        return SigningCertificateLineage.readFromDataSource(DataSources.asDataSource(ByteBuffer.wrap(lineageBytes)));
    }

    public static SigningCertificateLineage readFromFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        RandomAccessFile inputFile = new RandomAccessFile(file, "r");
        return SigningCertificateLineage.readFromDataSource(DataSources.asDataSource(inputFile));
    }

    public static SigningCertificateLineage readFromDataSource(DataSource dataSource) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource == null");
        }
        ByteBuffer inBuff = dataSource.getByteBuffer(0L, (int)dataSource.size());
        inBuff.order(ByteOrder.LITTLE_ENDIAN);
        return SigningCertificateLineage.read(inBuff);
    }

    public static SigningCertificateLineage readFromV3AttributeValue(byte[] attrValue) throws IOException {
        List<V3SigningCertificateLineage.SigningCertificateNode> parsedLineage = V3SigningCertificateLineage.readSigningCertificateLineage(ByteBuffer.wrap(attrValue).order(ByteOrder.LITTLE_ENDIAN));
        int minSdkVersion = SigningCertificateLineage.calculateMinSdkVersion(parsedLineage);
        return new SigningCertificateLineage(minSdkVersion, parsedLineage);
    }

    public static SigningCertificateLineage readFromApkFile(File apkFile) throws IOException, ApkFormatException {
        try (RandomAccessFile f = new RandomAccessFile(apkFile, "r");){
            DataSource apk = DataSources.asDataSource(f, 0L, f.length());
            SigningCertificateLineage signingCertificateLineage = SigningCertificateLineage.readFromApkDataSource(apk);
            return signingCertificateLineage;
        }
    }

    public static SigningCertificateLineage readFromApkDataSource(DataSource apk) throws IOException, ApkFormatException {
        return SigningCertificateLineage.readFromApkDataSource(apk, true, true);
    }

    public static SigningCertificateLineage readV31FromApkDataSource(DataSource apk) throws IOException, ApkFormatException {
        return SigningCertificateLineage.readFromApkDataSource(apk, true, false);
    }

    private static SigningCertificateLineage readFromApkDataSource(DataSource apk, boolean readV31Lineage, boolean readV3Lineage) throws IOException, ApkFormatException {
        ApkSigningBlockUtils.Result result2;
        ApkUtils.ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(apk);
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException(e.getMessage());
        }
        ArrayList<SignatureInfo> signatureInfoList = new ArrayList<SignatureInfo>();
        if (readV31Lineage) {
            try {
                result2 = new ApkSigningBlockUtils.Result(31);
                signatureInfoList.add(ApkSigningBlockUtils.findSignature(apk, zipSections, 462663009, result2));
            }
            catch (ApkSigningBlockUtils.SignatureNotFoundException result2) {
                // empty catch block
            }
        }
        if (readV3Lineage) {
            try {
                result2 = new ApkSigningBlockUtils.Result(3);
                signatureInfoList.add(ApkSigningBlockUtils.findSignature(apk, zipSections, -262969152, result2));
            }
            catch (ApkSigningBlockUtils.SignatureNotFoundException result3) {
                // empty catch block
            }
        }
        if (signatureInfoList.isEmpty()) {
            String message = readV31Lineage && readV3Lineage ? "The provided APK does not contain a valid V3 nor V3.1 signature block." : (readV31Lineage ? "The provided APK does not contain a valid V3.1 signature block." : (readV3Lineage ? "The provided APK does not contain a valid V3 signature block." : "No signature blocks were requested."));
            throw new IllegalArgumentException(message);
        }
        ArrayList<SigningCertificateLineage> lineages = new ArrayList<SigningCertificateLineage>(1);
        for (SignatureInfo signatureInfo : signatureInfoList) {
            ByteBuffer signers = ApkSigningBlockUtils.getLengthPrefixedSlice(signatureInfo.signatureBlock);
            while (signers.hasRemaining()) {
                ByteBuffer signer = ApkSigningBlockUtils.getLengthPrefixedSlice(signers);
                ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(signer);
                try {
                    SigningCertificateLineage lineage = SigningCertificateLineage.readFromSignedData(signedData);
                    lineages.add(lineage);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (lineages.isEmpty()) {
            throw new IllegalArgumentException("The provided APK does not contain a valid lineage.");
        }
        SigningCertificateLineage result4 = lineages.size() > 1 ? SigningCertificateLineage.consolidateLineages(lineages) : (SigningCertificateLineage)lineages.get(0);
        return result4;
    }

    public static SigningCertificateLineage readFromSignedData(ByteBuffer signedData) throws IOException, ApkFormatException {
        ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        signedData.getInt();
        signedData.getInt();
        ByteBuffer additionalAttributes = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ArrayList<SigningCertificateLineage> lineages = new ArrayList<SigningCertificateLineage>(1);
        while (additionalAttributes.hasRemaining()) {
            ByteBuffer attribute = ApkSigningBlockUtils.getLengthPrefixedSlice(additionalAttributes);
            int id = attribute.getInt();
            if (id != 1000370060) continue;
            byte[] value = ByteBufferUtils.toByteArray(attribute);
            SigningCertificateLineage lineage = SigningCertificateLineage.readFromV3AttributeValue(value);
            lineages.add(lineage);
        }
        if (lineages.isEmpty()) {
            throw new IllegalArgumentException("The signed data does not contain a valid lineage.");
        }
        SigningCertificateLineage result = lineages.size() > 1 ? SigningCertificateLineage.consolidateLineages(lineages) : (SigningCertificateLineage)lineages.get(0);
        return result;
    }

    public byte[] getBytes() {
        return this.write().array();
    }

    public void writeToFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        RandomAccessFile outputFile = new RandomAccessFile(file, "rw");
        this.writeToDataSink(new RandomAccessFileDataSink(outputFile));
    }

    public void writeToDataSink(DataSink dataSink) throws IOException {
        if (dataSink == null) {
            throw new NullPointerException("dataSink == null");
        }
        dataSink.consume(this.write());
    }

    public SigningCertificateLineage spawnDescendant(SignerConfig parent, SignerConfig child) throws CertificateEncodingException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        if (parent == null || child == null) {
            throw new NullPointerException("can't add new descendant to lineage with null inputs");
        }
        SignerCapabilities signerCapabilities = new SignerCapabilities.Builder().build();
        return this.spawnDescendant(parent, child, signerCapabilities);
    }

    public SigningCertificateLineage spawnDescendant(SignerConfig parent, SignerConfig child, SignerCapabilities childCapabilities) throws CertificateEncodingException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        if (child == null) {
            throw new NullPointerException("child == null");
        }
        if (childCapabilities == null) {
            throw new NullPointerException("childCapabilities == null");
        }
        if (this.mSigningLineage.isEmpty()) {
            throw new IllegalArgumentException("Cannot spawn descendant signing certificate on an empty SigningCertificateLineage: no parent node");
        }
        V3SigningCertificateLineage.SigningCertificateNode currentGeneration = this.mSigningLineage.get(this.mSigningLineage.size() - 1);
        if (!Arrays.equals(currentGeneration.signingCert.getEncoded(), parent.getCertificate().getEncoded())) {
            throw new IllegalArgumentException("SignerConfig Certificate containing private key to sign the new SigningCertificateLineage record does not match the existing most recent record");
        }
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm(parent);
        ByteBuffer prefixedSignedData = ByteBuffer.wrap(V3SigningCertificateLineage.encodeSignedData(child.getCertificate(), signatureAlgorithm.getId()));
        prefixedSignedData.position(4);
        ByteBuffer signedDataBuffer = ByteBuffer.allocate(prefixedSignedData.remaining());
        signedDataBuffer.put(prefixedSignedData);
        byte[] signedData = signedDataBuffer.array();
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(1);
        certificates.add(parent.getCertificate());
        ApkSigningBlockUtils.SignerConfig newSignerConfig = new ApkSigningBlockUtils.SignerConfig();
        newSignerConfig.keyConfig = parent.getKeyConfig();
        newSignerConfig.certificates = certificates;
        newSignerConfig.signatureAlgorithms = Collections.singletonList(signatureAlgorithm);
        List<Pair<Integer, byte[]>> signatures = ApkSigningBlockUtils.generateSignaturesOverData(newSignerConfig, signedData);
        SignatureAlgorithm sigAlgorithm = SignatureAlgorithm.findById(signatures.get(0).getFirst());
        byte[] signature = signatures.get(0).getSecond();
        currentGeneration.sigAlgorithm = sigAlgorithm;
        V3SigningCertificateLineage.SigningCertificateNode childNode = new V3SigningCertificateLineage.SigningCertificateNode(child.getCertificate(), sigAlgorithm, null, signature, childCapabilities.getFlags());
        ArrayList<V3SigningCertificateLineage.SigningCertificateNode> lineageCopy = new ArrayList<V3SigningCertificateLineage.SigningCertificateNode>(this.mSigningLineage);
        lineageCopy.add(childNode);
        return new SigningCertificateLineage(this.mMinSdkVersion, lineageCopy);
    }

    public int size() {
        return this.mSigningLineage.size();
    }

    private SignatureAlgorithm getSignatureAlgorithm(SignerConfig parent) throws InvalidKeyException {
        PublicKey publicKey = parent.getCertificate().getPublicKey();
        List<SignatureAlgorithm> algorithms = V3SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, this.mMinSdkVersion, false, false);
        return algorithms.get(0);
    }

    private SigningCertificateLineage spawnFirstDescendant(SignerConfig parent, SignerCapabilities signerCapabilities) {
        if (!this.mSigningLineage.isEmpty()) {
            throw new IllegalStateException("SigningCertificateLineage already has its first node");
        }
        try {
            this.getSignatureAlgorithm(parent);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Algorithm associated with first signing certificate invalid on desired platform versions", e);
        }
        V3SigningCertificateLineage.SigningCertificateNode firstNode = new V3SigningCertificateLineage.SigningCertificateNode(parent.getCertificate(), null, null, new byte[0], signerCapabilities.getFlags());
        return new SigningCertificateLineage(this.mMinSdkVersion, Collections.singletonList(firstNode));
    }

    private static SigningCertificateLineage read(ByteBuffer inputByteBuffer) throws IOException {
        ApkSigningBlockUtils.checkByteOrderLittleEndian(inputByteBuffer);
        if (inputByteBuffer.remaining() < 8) {
            throw new IllegalArgumentException("Improper SigningCertificateLineage format: insufficient data for header.");
        }
        if (inputByteBuffer.getInt() != 1056913873) {
            throw new IllegalArgumentException("Improper SigningCertificateLineage format: MAGIC header mismatch.");
        }
        return SigningCertificateLineage.read(inputByteBuffer, inputByteBuffer.getInt());
    }

    private static SigningCertificateLineage read(ByteBuffer inputByteBuffer, int version) throws IOException {
        switch (version) {
            case 1: {
                try {
                    List<V3SigningCertificateLineage.SigningCertificateNode> nodes = V3SigningCertificateLineage.readSigningCertificateLineage(ApkSigningBlockUtils.getLengthPrefixedSlice(inputByteBuffer));
                    int minSdkVersion = SigningCertificateLineage.calculateMinSdkVersion(nodes);
                    return new SigningCertificateLineage(minSdkVersion, nodes);
                }
                catch (ApkFormatException e) {
                    throw new IOException("Unable to read list of signing certificate nodes in SigningCertificateLineage", e);
                }
            }
        }
        throw new IllegalArgumentException("Improper SigningCertificateLineage format: unrecognized version.");
    }

    private static int calculateMinSdkVersion(List<V3SigningCertificateLineage.SigningCertificateNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Can't calculate minimum SDK version of null nodes");
        }
        int minSdkVersion = 28;
        for (V3SigningCertificateLineage.SigningCertificateNode node : nodes) {
            int nodeMinSdkVersion;
            if (node.sigAlgorithm == null || (nodeMinSdkVersion = node.sigAlgorithm.getMinSdkVersion()) <= minSdkVersion) continue;
            minSdkVersion = nodeMinSdkVersion;
        }
        return minSdkVersion;
    }

    private ByteBuffer write() {
        byte[] encodedLineage = V3SigningCertificateLineage.encodeSigningCertificateLineage(this.mSigningLineage);
        int payloadSize = 12 + encodedLineage.length;
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.putInt(1056913873);
        result.putInt(1);
        result.putInt(encodedLineage.length);
        result.put(encodedLineage);
        result.flip();
        return result;
    }

    public byte[] encodeSigningCertificateLineage() {
        return V3SigningCertificateLineage.encodeSigningCertificateLineage(this.mSigningLineage);
    }

    public List<DefaultApkSignerEngine.SignerConfig> sortSignerConfigs(List<DefaultApkSignerEngine.SignerConfig> signerConfigs) {
        if (signerConfigs == null) {
            throw new NullPointerException("signerConfigs == null");
        }
        ArrayList<DefaultApkSignerEngine.SignerConfig> sortedSignerConfigs = new ArrayList<DefaultApkSignerEngine.SignerConfig>(signerConfigs.size());
        block0: for (int i = 0; i < this.mSigningLineage.size(); ++i) {
            for (int j = 0; j < signerConfigs.size(); ++j) {
                DefaultApkSignerEngine.SignerConfig config = signerConfigs.get(j);
                if (!this.mSigningLineage.get((int)i).signingCert.equals(config.getCertificates().get(0))) continue;
                sortedSignerConfigs.add(config);
                continue block0;
            }
        }
        if (sortedSignerConfigs.size() != signerConfigs.size()) {
            throw new IllegalArgumentException("SignerConfigs supplied which are not present in the SigningCertificateLineage");
        }
        return sortedSignerConfigs;
    }

    public SignerCapabilities getSignerCapabilities(SignerConfig config) {
        if (config == null) {
            throw new NullPointerException("config == null");
        }
        X509Certificate cert = config.getCertificate();
        return this.getSignerCapabilities(cert);
    }

    public SignerCapabilities getSignerCapabilities(X509Certificate cert) {
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        for (int i = 0; i < this.mSigningLineage.size(); ++i) {
            V3SigningCertificateLineage.SigningCertificateNode lineageNode = this.mSigningLineage.get(i);
            if (!lineageNode.signingCert.equals(cert)) continue;
            int flags = lineageNode.flags;
            return new SignerCapabilities.Builder(flags).build();
        }
        throw new IllegalArgumentException("Certificate (" + cert.getSubjectDN() + ") not found in the SigningCertificateLineage");
    }

    public void updateSignerCapabilities(SignerConfig config, SignerCapabilities capabilities) {
        if (config == null) {
            throw new NullPointerException("config == null");
        }
        this.updateSignerCapabilities(config.getCertificate(), capabilities);
    }

    public void updateSignerCapabilities(X509Certificate certificate, SignerCapabilities capabilities) {
        if (certificate == null) {
            throw new NullPointerException("config == null");
        }
        for (int i = 0; i < this.mSigningLineage.size(); ++i) {
            V3SigningCertificateLineage.SigningCertificateNode lineageNode = this.mSigningLineage.get(i);
            if (!lineageNode.signingCert.equals(certificate)) continue;
            int flags = lineageNode.flags;
            SignerCapabilities newCapabilities = new SignerCapabilities.Builder(flags).setCallerConfiguredCapabilities(capabilities).build();
            lineageNode.flags = newCapabilities.getFlags();
            return;
        }
        throw new IllegalArgumentException("Certificate (" + certificate.getSubjectDN() + ") not found in the SigningCertificateLineage");
    }

    public List<X509Certificate> getCertificatesInLineage() {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (int i = 0; i < this.mSigningLineage.size(); ++i) {
            X509Certificate cert = this.mSigningLineage.get((int)i).signingCert;
            certs.add(cert);
        }
        return certs;
    }

    public boolean isSignerInLineage(SignerConfig config) {
        if (config == null) {
            throw new NullPointerException("config == null");
        }
        X509Certificate cert = config.getCertificate();
        return this.isCertificateInLineage(cert);
    }

    public boolean isCertificateInLineage(X509Certificate cert) {
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        for (int i = 0; i < this.mSigningLineage.size(); ++i) {
            if (!this.mSigningLineage.get((int)i).signingCert.equals(cert)) continue;
            return true;
        }
        return false;
    }

    public boolean isCertificateLatestInLineage(X509Certificate cert) {
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        return this.mSigningLineage.get((int)(this.mSigningLineage.size() - 1)).signingCert.equals(cert);
    }

    private static int calculateDefaultFlags() {
        return 23;
    }

    public SigningCertificateLineage getSubLineage(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new NullPointerException("x509Certificate == null");
        }
        for (int i = 0; i < this.mSigningLineage.size(); ++i) {
            if (!this.mSigningLineage.get((int)i).signingCert.equals(x509Certificate)) continue;
            return new SigningCertificateLineage(this.mMinSdkVersion, new ArrayList<V3SigningCertificateLineage.SigningCertificateNode>(this.mSigningLineage.subList(0, i + 1)));
        }
        throw new IllegalArgumentException("Certificate not found in SigningCertificateLineage");
    }

    public static SigningCertificateLineage consolidateLineages(List<SigningCertificateLineage> lineages) {
        if (lineages == null || lineages.isEmpty()) {
            return null;
        }
        SigningCertificateLineage consolidatedLineage = lineages.get(0);
        for (int i = 1; i < lineages.size(); ++i) {
            consolidatedLineage = consolidatedLineage.mergeLineageWith(lineages.get(i));
        }
        return consolidatedLineage;
    }

    public SigningCertificateLineage mergeLineageWith(SigningCertificateLineage otherLineage) {
        V3SigningCertificateLineage.SigningCertificateNode ancestorNode;
        SigningCertificateLineage ancestorLineage;
        SigningCertificateLineage descendantLineage;
        X509Certificate signerCert = this.mSigningLineage.get((int)0).signingCert;
        if (otherLineage.isCertificateInLineage(signerCert)) {
            descendantLineage = this;
            ancestorLineage = otherLineage;
        } else {
            descendantLineage = otherLineage;
            ancestorLineage = this;
        }
        int ancestorIndex = 0;
        int descendantIndex = 0;
        V3SigningCertificateLineage.SigningCertificateNode descendantNode = descendantLineage.mSigningLineage.get(descendantIndex++);
        ArrayList<V3SigningCertificateLineage.SigningCertificateNode> mergedLineage = new ArrayList<V3SigningCertificateLineage.SigningCertificateNode>();
        while (ancestorIndex < ancestorLineage.size()) {
            ancestorNode = ancestorLineage.mSigningLineage.get(ancestorIndex++);
            if (ancestorNode.signingCert.equals(descendantNode.signingCert)) break;
            mergedLineage.add(ancestorNode);
        }
        if (ancestorIndex == mergedLineage.size()) {
            throw new IllegalArgumentException("The provided lineage is not a descendant or an ancestor of this lineage");
        }
        mergedLineage.add(descendantNode);
        while (ancestorIndex < ancestorLineage.size() && descendantIndex < descendantLineage.size()) {
            ancestorNode = ancestorLineage.mSigningLineage.get(ancestorIndex++);
            descendantNode = descendantLineage.mSigningLineage.get(descendantIndex++);
            if (!ancestorNode.signingCert.equals(descendantNode.signingCert)) {
                throw new IllegalArgumentException("The provided lineage diverges from this lineage");
            }
            mergedLineage.add(descendantNode);
        }
        while (ancestorIndex < ancestorLineage.size()) {
            mergedLineage.add(ancestorLineage.mSigningLineage.get(ancestorIndex++));
        }
        while (descendantIndex < descendantLineage.size()) {
            mergedLineage.add(descendantLineage.mSigningLineage.get(descendantIndex++));
        }
        return new SigningCertificateLineage(Math.min(this.mMinSdkVersion, otherLineage.mMinSdkVersion), mergedLineage);
    }

    public static boolean checkLineagesCompatibility(SigningCertificateLineage oldLineage, SigningCertificateLineage newLineage) {
        ArrayList newCertificates;
        ArrayList oldCertificates = oldLineage == null ? new ArrayList() : new ArrayList<X509Certificate>(oldLineage.getCertificatesInLineage());
        ArrayList<Object> arrayList = newCertificates = newLineage == null ? new ArrayList() : new ArrayList<X509Certificate>(newLineage.getCertificatesInLineage());
        if (oldCertificates.isEmpty()) {
            return true;
        }
        if (newCertificates.isEmpty()) {
            return false;
        }
        if (newCertificates.size() >= oldCertificates.size() && newCertificates.subList(0, oldCertificates.size()).equals(oldCertificates)) {
            return true;
        }
        ArrayList newCertificatesArray = new ArrayList(newCertificates);
        ArrayList oldCertificatesArray = new ArrayList(oldCertificates);
        int lastOldCertIndexInNew = newCertificatesArray.lastIndexOf(oldCertificatesArray.get(oldCertificatesArray.size() - 1));
        if (lastOldCertIndexInNew >= 0) {
            return newCertificatesArray.subList(0, lastOldCertIndexInNew + 1).equals(oldCertificatesArray.subList(oldCertificates.size() - 1 - lastOldCertIndexInNew, oldCertificatesArray.size()));
        }
        return oldCertificates.subList(0, newCertificates.size()).equals(newCertificates) && oldLineage.getSignerCapabilities((X509Certificate)oldCertificates.get(newCertificates.size() - 1)).hasRollback();
    }

    public static class SignerConfig {
        private final KeyConfig mKeyConfig;
        private final X509Certificate mCertificate;

        private SignerConfig(KeyConfig keyConfig, X509Certificate certificate) {
            this.mKeyConfig = keyConfig;
            this.mCertificate = certificate;
        }

        @Deprecated
        public PrivateKey getPrivateKey() {
            return this.mKeyConfig.match(jca -> jca.privateKey, kms -> null);
        }

        public KeyConfig getKeyConfig() {
            return this.mKeyConfig;
        }

        public X509Certificate getCertificate() {
            return this.mCertificate;
        }

        public static class Builder {
            private final KeyConfig mKeyConfig;
            private final X509Certificate mCertificate;

            @Deprecated
            public Builder(PrivateKey privateKey, X509Certificate certificate) {
                this.mKeyConfig = new KeyConfig.Jca(privateKey);
                this.mCertificate = certificate;
            }

            public Builder(KeyConfig keyConfig, X509Certificate certificate) {
                this.mKeyConfig = keyConfig;
                this.mCertificate = certificate;
            }

            public SignerConfig build() {
                return new SignerConfig(this.mKeyConfig, this.mCertificate);
            }
        }
    }

    public static class SignerCapabilities {
        private final int mFlags;
        private final int mCallerConfiguredFlags;

        private SignerCapabilities(int flags) {
            this(flags, 0);
        }

        private SignerCapabilities(int flags, int callerConfiguredFlags) {
            this.mFlags = flags;
            this.mCallerConfiguredFlags = callerConfiguredFlags;
        }

        private int getFlags() {
            return this.mFlags;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SignerCapabilities)) {
                return false;
            }
            return this.mFlags == ((SignerCapabilities)other).mFlags;
        }

        public int hashCode() {
            return 31 * this.mFlags;
        }

        public boolean hasInstalledData() {
            return (this.mFlags & 1) != 0;
        }

        public boolean hasSharedUid() {
            return (this.mFlags & 2) != 0;
        }

        public boolean hasPermission() {
            return (this.mFlags & 4) != 0;
        }

        public boolean hasRollback() {
            return (this.mFlags & 8) != 0;
        }

        public boolean hasAuth() {
            return (this.mFlags & 0x10) != 0;
        }

        public static class Builder {
            private int mFlags;
            private int mCallerConfiguredFlags;

            public Builder() {
                this.mFlags = SigningCertificateLineage.calculateDefaultFlags();
            }

            public Builder(int flags) {
                this.mFlags = flags;
            }

            public Builder setInstalledData(boolean enabled) {
                this.mCallerConfiguredFlags |= 1;
                this.mFlags = enabled ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
                return this;
            }

            public Builder setSharedUid(boolean enabled) {
                this.mCallerConfiguredFlags |= 2;
                this.mFlags = enabled ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
                return this;
            }

            public Builder setPermission(boolean enabled) {
                this.mCallerConfiguredFlags |= 4;
                this.mFlags = enabled ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
                return this;
            }

            public Builder setRollback(boolean enabled) {
                this.mCallerConfiguredFlags |= 8;
                this.mFlags = enabled ? (this.mFlags |= 8) : (this.mFlags &= 0xFFFFFFF7);
                return this;
            }

            public Builder setAuth(boolean enabled) {
                this.mCallerConfiguredFlags |= 0x10;
                this.mFlags = enabled ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
                return this;
            }

            public Builder setCallerConfiguredCapabilities(SignerCapabilities capabilities) {
                this.mFlags = this.mFlags & ~capabilities.mCallerConfiguredFlags | capabilities.mFlags & capabilities.mCallerConfiguredFlags;
                return this;
            }

            public SignerCapabilities build() {
                return new SignerCapabilities(this.mFlags, this.mCallerConfiguredFlags);
            }
        }
    }

    public static class Builder {
        private final SignerConfig mOriginalSignerConfig;
        private final SignerConfig mNewSignerConfig;
        private SignerCapabilities mOriginalCapabilities;
        private SignerCapabilities mNewCapabilities;
        private int mMinSdkVersion;

        public Builder(SignerConfig originalSignerConfig, SignerConfig newSignerConfig) {
            if (originalSignerConfig == null || newSignerConfig == null) {
                throw new NullPointerException("Can't pass null SignerConfigs when constructing a new SigningCertificateLineage");
            }
            this.mOriginalSignerConfig = originalSignerConfig;
            this.mNewSignerConfig = newSignerConfig;
        }

        public Builder(SignerConfig originalSignerConfig) {
            if (originalSignerConfig == null) {
                throw new NullPointerException("Can't pass null SignerConfigs when constructing a new SigningCertificateLineage");
            }
            this.mOriginalSignerConfig = originalSignerConfig;
            this.mNewSignerConfig = null;
        }

        public Builder setMinSdkVersion(int minSdkVersion) {
            this.mMinSdkVersion = minSdkVersion;
            return this;
        }

        public Builder setOriginalCapabilities(SignerCapabilities signerCapabilities) {
            if (signerCapabilities == null) {
                throw new NullPointerException("signerCapabilities == null");
            }
            this.mOriginalCapabilities = signerCapabilities;
            return this;
        }

        public Builder setNewCapabilities(SignerCapabilities signerCapabilities) {
            if (signerCapabilities == null) {
                throw new NullPointerException("signerCapabilities == null");
            }
            this.mNewCapabilities = signerCapabilities;
            return this;
        }

        public SigningCertificateLineage build() throws CertificateEncodingException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            if (this.mMinSdkVersion < 28) {
                this.mMinSdkVersion = 28;
            }
            if (this.mOriginalCapabilities == null) {
                this.mOriginalCapabilities = new SignerCapabilities.Builder().build();
            }
            if (this.mNewSignerConfig == null) {
                return SigningCertificateLineage.createSigningLineage(this.mMinSdkVersion, this.mOriginalSignerConfig, this.mOriginalCapabilities);
            }
            if (this.mNewCapabilities == null) {
                this.mNewCapabilities = new SignerCapabilities.Builder().build();
            }
            return SigningCertificateLineage.createSigningLineage(this.mMinSdkVersion, this.mOriginalSignerConfig, this.mOriginalCapabilities, this.mNewSignerConfig, this.mNewCapabilities);
        }
    }
}

