/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.DefaultApkSignerEngine;
import com.android.apksig.Hints;
import com.android.apksig.KeyConfig;
import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksig.internal.util.ByteBufferDataSource;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.EocdRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.util.ReadableDataSink;
import com.android.apksig.zip.ZipFormatException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ApkSigner {
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_HEADER_ID = -9931;
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_MIN_SIZE_BYTES = 6;
    private static final short ANDROID_FILE_ALIGNMENT_BYTES = 4096;
    private static final String ANDROID_MANIFEST_ZIP_ENTRY_NAME = "AndroidManifest.xml";
    private final List<SignerConfig> mSignerConfigs;
    private final SignerConfig mSourceStampSignerConfig;
    private final SigningCertificateLineage mSourceStampSigningCertificateLineage;
    private final boolean mForceSourceStampOverwrite;
    private final boolean mSourceStampTimestampEnabled;
    private final Integer mMinSdkVersion;
    private final int mRotationMinSdkVersion;
    private final boolean mRotationTargetsDevRelease;
    private final boolean mV1SigningEnabled;
    private final boolean mV2SigningEnabled;
    private final boolean mV3SigningEnabled;
    private final boolean mV4SigningEnabled;
    private final boolean mAlignFileSize;
    private final boolean mVerityEnabled;
    private final boolean mV4ErrorReportingEnabled;
    private final boolean mDebuggableApkPermitted;
    private final boolean mOtherSignersSignaturesPreserved;
    private final boolean mAlignmentPreserved;
    private final int mLibraryPageAlignmentBytes;
    private final String mCreatedBy;
    private final ApkSignerEngine mSignerEngine;
    private final File mInputApkFile;
    private final DataSource mInputApkDataSource;
    private final File mOutputApkFile;
    private final DataSink mOutputApkDataSink;
    private final DataSource mOutputApkDataSource;
    private final File mOutputV4File;
    private final SigningCertificateLineage mSigningCertificateLineage;

    private ApkSigner(List<SignerConfig> signerConfigs, SignerConfig sourceStampSignerConfig, SigningCertificateLineage sourceStampSigningCertificateLineage, boolean forceSourceStampOverwrite, boolean sourceStampTimestampEnabled, Integer minSdkVersion, int rotationMinSdkVersion, boolean rotationTargetsDevRelease, boolean v1SigningEnabled, boolean v2SigningEnabled, boolean v3SigningEnabled, boolean v4SigningEnabled, boolean alignFileSize, boolean verityEnabled, boolean v4ErrorReportingEnabled, boolean debuggableApkPermitted, boolean otherSignersSignaturesPreserved, boolean alignmentPreserved, int libraryPageAlignmentBytes, String createdBy, ApkSignerEngine signerEngine, File inputApkFile, DataSource inputApkDataSource, File outputApkFile, DataSink outputApkDataSink, DataSource outputApkDataSource, File outputV4File, SigningCertificateLineage signingCertificateLineage) {
        this.mSignerConfigs = signerConfigs;
        this.mSourceStampSignerConfig = sourceStampSignerConfig;
        this.mSourceStampSigningCertificateLineage = sourceStampSigningCertificateLineage;
        this.mForceSourceStampOverwrite = forceSourceStampOverwrite;
        this.mSourceStampTimestampEnabled = sourceStampTimestampEnabled;
        this.mMinSdkVersion = minSdkVersion;
        this.mRotationMinSdkVersion = rotationMinSdkVersion;
        this.mRotationTargetsDevRelease = rotationTargetsDevRelease;
        this.mV1SigningEnabled = v1SigningEnabled;
        this.mV2SigningEnabled = v2SigningEnabled;
        this.mV3SigningEnabled = v3SigningEnabled;
        this.mV4SigningEnabled = v4SigningEnabled;
        this.mAlignFileSize = alignFileSize;
        this.mVerityEnabled = verityEnabled;
        this.mV4ErrorReportingEnabled = v4ErrorReportingEnabled;
        this.mDebuggableApkPermitted = debuggableApkPermitted;
        this.mOtherSignersSignaturesPreserved = otherSignersSignaturesPreserved;
        this.mAlignmentPreserved = alignmentPreserved;
        this.mLibraryPageAlignmentBytes = libraryPageAlignmentBytes;
        this.mCreatedBy = createdBy;
        this.mSignerEngine = signerEngine;
        this.mInputApkFile = inputApkFile;
        this.mInputApkDataSource = inputApkDataSource;
        this.mOutputApkFile = outputApkFile;
        this.mOutputApkDataSink = outputApkDataSink;
        this.mOutputApkDataSource = outputApkDataSource;
        this.mOutputV4File = outputV4File;
        this.mSigningCertificateLineage = signingCertificateLineage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign() throws IOException, ApkFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, IllegalStateException {
        try (Closeable in = null;){
            DataSource inputApk;
            if (this.mInputApkDataSource != null) {
                inputApk = this.mInputApkDataSource;
            } else if (this.mInputApkFile != null) {
                RandomAccessFile inputFile = new RandomAccessFile(this.mInputApkFile, "r");
                in = inputFile;
                inputApk = DataSources.asDataSource(inputFile);
            } else {
                throw new IllegalStateException("Input APK not specified");
            }
            try (Closeable out = null;){
                DataSource outputApkIn;
                DataSink outputApkOut;
                if (this.mOutputApkDataSink != null) {
                    outputApkOut = this.mOutputApkDataSink;
                    outputApkIn = this.mOutputApkDataSource;
                } else if (this.mOutputApkFile != null) {
                    RandomAccessFile outputFile = new RandomAccessFile(this.mOutputApkFile, "rw");
                    out = outputFile;
                    outputFile.setLength(0L);
                    outputApkOut = DataSinks.asDataSink(outputFile);
                    outputApkIn = DataSources.asDataSource(outputFile);
                } else {
                    throw new IllegalStateException("Output APK not specified");
                }
                this.sign(inputApk, outputApkOut, outputApkIn);
            }
        }
    }

    private void sign(DataSource inputApk, DataSink outputApkOut, DataSource outputApkIn) throws IOException, ApkFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ApkSignerEngine.OutputJarSignatureRequest outputJarSignatureRequest;
        ApkSignerEngine signerEngine;
        ArrayList<Hints.ByteRange> pinByteRanges;
        ApkUtils.ZipSections inputZipSections;
        try {
            inputZipSections = ApkUtils.findZipSections(inputApk);
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Malformed APK: not a ZIP archive", e);
        }
        long inputApkSigningBlockOffset = -1L;
        DataSource inputApkSigningBlock = null;
        try {
            ApkUtils.ApkSigningBlock apkSigningBlockInfo = ApkUtils.findApkSigningBlock(inputApk, inputZipSections);
            inputApkSigningBlockOffset = apkSigningBlockInfo.getStartOffset();
            inputApkSigningBlock = apkSigningBlockInfo.getContents();
        }
        catch (ApkSigningBlockNotFoundException apkSigningBlockInfo) {
            // empty catch block
        }
        DataSource inputApkLfhSection = inputApk.slice(0L, inputApkSigningBlockOffset != -1L ? inputApkSigningBlockOffset : inputZipSections.getZipCentralDirectoryOffset());
        ByteBuffer inputCd = ApkSigner.getZipCentralDirectory(inputApk, inputZipSections);
        List<CentralDirectoryRecord> inputCdRecords = ApkSigner.parseZipCentralDirectory(inputCd, inputZipSections);
        List<Hints.PatternWithRange> pinPatterns = ApkSigner.extractPinPatterns(inputCdRecords, inputApkLfhSection);
        ArrayList<Hints.ByteRange> arrayList = pinByteRanges = pinPatterns == null ? null : new ArrayList<Hints.ByteRange>();
        if (this.mSignerEngine != null) {
            signerEngine = this.mSignerEngine;
        } else {
            int minSdkVersion = this.mMinSdkVersion != null ? this.mMinSdkVersion : ApkSigner.getMinSdkVersionFromApk(inputCdRecords, inputApkLfhSection);
            ArrayList<DefaultApkSignerEngine.SignerConfig> engineSignerConfigs = new ArrayList<DefaultApkSignerEngine.SignerConfig>(this.mSignerConfigs.size());
            for (SignerConfig signerConfig : this.mSignerConfigs) {
                DefaultApkSignerEngine.SignerConfig.Builder signerConfigBuilder = new DefaultApkSignerEngine.SignerConfig.Builder(signerConfig.getName(), signerConfig.getKeyConfig(), signerConfig.getCertificates(), signerConfig.getDeterministicDsaSigning());
                int signerMinSdkVersion = signerConfig.getMinSdkVersion();
                SigningCertificateLineage signerLineage = signerConfig.getSigningCertificateLineage();
                if (signerMinSdkVersion > 0) {
                    signerConfigBuilder.setLineageForMinSdkVersion(signerLineage, signerMinSdkVersion);
                }
                engineSignerConfigs.add(signerConfigBuilder.build());
            }
            DefaultApkSignerEngine.Builder signerEngineBuilder = new DefaultApkSignerEngine.Builder(engineSignerConfigs, minSdkVersion).setV1SigningEnabled(this.mV1SigningEnabled).setV2SigningEnabled(this.mV2SigningEnabled).setV3SigningEnabled(this.mV3SigningEnabled).setVerityEnabled(this.mVerityEnabled).setDebuggableApkPermitted(this.mDebuggableApkPermitted).setOtherSignersSignaturesPreserved(this.mOtherSignersSignaturesPreserved).setSigningCertificateLineage(this.mSigningCertificateLineage).setMinSdkVersionForRotation(this.mRotationMinSdkVersion).setRotationTargetsDevRelease(this.mRotationTargetsDevRelease);
            if (this.mCreatedBy != null) {
                signerEngineBuilder.setCreatedBy(this.mCreatedBy);
            }
            if (this.mSourceStampSignerConfig != null) {
                signerEngineBuilder.setStampSignerConfig(new DefaultApkSignerEngine.SignerConfig.Builder(this.mSourceStampSignerConfig.getName(), this.mSourceStampSignerConfig.getKeyConfig(), this.mSourceStampSignerConfig.getCertificates(), this.mSourceStampSignerConfig.getDeterministicDsaSigning()).build());
                signerEngineBuilder.setSourceStampTimestampEnabled(this.mSourceStampTimestampEnabled);
            }
            if (this.mSourceStampSigningCertificateLineage != null) {
                signerEngineBuilder.setSourceStampSigningCertificateLineage(this.mSourceStampSigningCertificateLineage);
            }
            signerEngine = signerEngineBuilder.build();
        }
        if (inputApkSigningBlock != null) {
            signerEngine.inputApkSigningBlock(inputApkSigningBlock);
        }
        ArrayList<CentralDirectoryRecord> inputCdRecordsSortedByLfhOffset = new ArrayList<CentralDirectoryRecord>(inputCdRecords);
        Collections.sort(inputCdRecordsSortedByLfhOffset, CentralDirectoryRecord.BY_LOCAL_FILE_HEADER_OFFSET_COMPARATOR);
        int lastModifiedDateForNewEntries = -1;
        int lastModifiedTimeForNewEntries = -1;
        long inputOffset = 0L;
        long outputOffset = 0L;
        byte[] sourceStampCertificateDigest = null;
        HashMap<String, CentralDirectoryRecord> outputCdRecordsByName = new HashMap<String, CentralDirectoryRecord>(inputCdRecords.size());
        for (CentralDirectoryRecord inputCdRecord : inputCdRecordsSortedByLfhOffset) {
            LocalFileRecord localFileRecord;
            boolean shouldOutput;
            String entryName = inputCdRecord.getName();
            if ("pinlist.meta".equals(entryName)) continue;
            if ("stamp-cert-sha256".equals(entryName)) {
                try {
                    sourceStampCertificateDigest = LocalFileRecord.getUncompressedData(inputApkLfhSection, inputCdRecord, inputApkLfhSection.size());
                    continue;
                }
                catch (ZipFormatException ex) {
                    throw new ApkFormatException("Bad source stamp entry");
                }
            }
            ApkSignerEngine.InputJarEntryInstructions entryInstructions = signerEngine.inputJarEntry(entryName);
            switch (entryInstructions.getOutputPolicy()) {
                case OUTPUT: {
                    shouldOutput = true;
                    break;
                }
                case OUTPUT_BY_ENGINE: 
                case SKIP: {
                    shouldOutput = false;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown output policy: " + (Object)((Object)entryInstructions.getOutputPolicy()));
                }
            }
            long inputLocalFileHeaderStartOffset = inputCdRecord.getLocalFileHeaderOffset();
            if (inputLocalFileHeaderStartOffset > inputOffset) {
                long l = inputLocalFileHeaderStartOffset - inputOffset;
                inputApkLfhSection.feed(inputOffset, l, outputApkOut);
                outputOffset += l;
                inputOffset = inputLocalFileHeaderStartOffset;
            }
            try {
                localFileRecord = LocalFileRecord.getRecord(inputApkLfhSection, inputCdRecord, inputApkLfhSection.size());
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP entry: " + inputCdRecord.getName(), e);
            }
            inputOffset += localFileRecord.getSize();
            ApkSignerEngine.InspectJarEntryRequest inspectEntryRequest = entryInstructions.getInspectJarEntryRequest();
            if (inspectEntryRequest != null) {
                ApkSigner.fulfillInspectInputJarEntryRequest(inputApkLfhSection, localFileRecord, inspectEntryRequest);
            }
            if (!shouldOutput) continue;
            int lastModifiedDate = inputCdRecord.getLastModificationDate();
            int lastModifiedTime = inputCdRecord.getLastModificationTime();
            if (lastModifiedDateForNewEntries == -1 || lastModifiedDate > lastModifiedDateForNewEntries || lastModifiedDate == lastModifiedDateForNewEntries && lastModifiedTime > lastModifiedTimeForNewEntries) {
                lastModifiedDateForNewEntries = lastModifiedDate;
                lastModifiedTimeForNewEntries = lastModifiedTime;
            }
            if ((inspectEntryRequest = signerEngine.outputJarEntry(entryName)) != null) {
                ApkSigner.fulfillInspectInputJarEntryRequest(inputApkLfhSection, localFileRecord, inspectEntryRequest);
            }
            long outputLocalFileHeaderOffset = outputOffset;
            OutputSizeAndDataOffset outputLfrResult = this.outputInputJarEntryLfhRecord(inputApkLfhSection, localFileRecord, outputApkOut, outputLocalFileHeaderOffset);
            outputOffset += outputLfrResult.outputBytes;
            long outputDataOffset = outputLocalFileHeaderOffset + outputLfrResult.dataOffsetBytes;
            if (pinPatterns != null) {
                boolean pinFileHeader = false;
                for (Hints.PatternWithRange pinPattern : pinPatterns) {
                    Hints.ByteRange dataRange;
                    Hints.ByteRange pinRange;
                    if (!pinPattern.matcher(inputCdRecord.getName()).matches() || (pinRange = pinPattern.ClampToAbsoluteByteRange(dataRange = new Hints.ByteRange(outputDataOffset, outputOffset))) == null) continue;
                    pinFileHeader = true;
                    pinByteRanges.add(pinRange);
                }
                if (pinFileHeader) {
                    pinByteRanges.add(new Hints.ByteRange(outputLocalFileHeaderOffset, outputDataOffset));
                }
            }
            CentralDirectoryRecord outputCdRecord = outputLocalFileHeaderOffset == localFileRecord.getStartOffsetInArchive() ? inputCdRecord : inputCdRecord.createWithModifiedLocalFileHeaderOffset(outputLocalFileHeaderOffset);
            outputCdRecordsByName.put(entryName, outputCdRecord);
        }
        long inputLfhSectionSize = inputApkLfhSection.size();
        if (inputOffset < inputLfhSectionSize) {
            long chunkSize = inputLfhSectionSize - inputOffset;
            inputApkLfhSection.feed(inputOffset, chunkSize, outputApkOut);
            outputOffset += chunkSize;
            inputOffset = inputLfhSectionSize;
        }
        ArrayList<CentralDirectoryRecord> outputCdRecords = new ArrayList<CentralDirectoryRecord>(inputCdRecords.size() + 10);
        for (CentralDirectoryRecord inputCdRecord : inputCdRecords) {
            String entryName = inputCdRecord.getName();
            CentralDirectoryRecord outputCdRecord = (CentralDirectoryRecord)outputCdRecordsByName.get(entryName);
            if (outputCdRecord == null) continue;
            outputCdRecords.add(outputCdRecord);
        }
        if (lastModifiedDateForNewEntries == -1) {
            lastModifiedDateForNewEntries = 14881;
            lastModifiedTimeForNewEntries = 0;
        }
        if (signerEngine.isEligibleForSourceStamp()) {
            byte[] uncompressedData = signerEngine.generateSourceStampCertificateDigest();
            if (this.mForceSourceStampOverwrite || sourceStampCertificateDigest == null || Arrays.equals(uncompressedData, sourceStampCertificateDigest)) {
                outputOffset += ApkSigner.outputDataToOutputApk("stamp-cert-sha256", uncompressedData, outputOffset, outputCdRecords, lastModifiedTimeForNewEntries, lastModifiedDateForNewEntries, outputApkOut);
            } else {
                throw new ApkFormatException(String.format("Cannot generate SourceStamp. APK contains an existing entry with the name: %s, and it is different than the provided source stamp certificate", "stamp-cert-sha256"));
            }
        }
        if (pinByteRanges != null) {
            pinByteRanges.add(new Hints.ByteRange(outputOffset, Long.MAX_VALUE));
            String entryName = "pinlist.meta";
            byte[] uncompressedData = Hints.encodeByteRangeList(pinByteRanges);
            ApkSigner.requestOutputEntryInspection(signerEngine, entryName, uncompressedData);
            outputOffset += ApkSigner.outputDataToOutputApk(entryName, uncompressedData, outputOffset, outputCdRecords, lastModifiedTimeForNewEntries, lastModifiedDateForNewEntries, outputApkOut);
        }
        if ((outputJarSignatureRequest = signerEngine.outputJarEntries()) != null) {
            for (ApkSignerEngine.OutputJarSignatureRequest.JarEntry entry : outputJarSignatureRequest.getAdditionalJarEntries()) {
                String entryName = entry.getName();
                byte[] byArray = entry.getData();
                ApkSigner.requestOutputEntryInspection(signerEngine, entryName, byArray);
                outputOffset += ApkSigner.outputDataToOutputApk(entryName, byArray, outputOffset, outputCdRecords, lastModifiedTimeForNewEntries, lastModifiedDateForNewEntries, outputApkOut);
            }
            outputJarSignatureRequest.done();
        }
        long outputCentralDirSizeBytes = 0L;
        for (CentralDirectoryRecord centralDirectoryRecord : outputCdRecords) {
            outputCentralDirSizeBytes += (long)centralDirectoryRecord.getSize();
        }
        if (outputCentralDirSizeBytes > Integer.MAX_VALUE) {
            throw new IOException("Output ZIP Central Directory too large: " + outputCentralDirSizeBytes + " bytes");
        }
        ByteBuffer outputCentralDir = ByteBuffer.allocate((int)outputCentralDirSizeBytes);
        for (CentralDirectoryRecord record : outputCdRecords) {
            record.copyTo(outputCentralDir);
        }
        outputCentralDir.flip();
        ByteBufferDataSource byteBufferDataSource = new ByteBufferDataSource(outputCentralDir);
        long outputCentralDirStartOffset = outputOffset;
        int outputCentralDirRecordCount = outputCdRecords.size();
        ByteBuffer outputEocd = EocdRecord.createWithModifiedCentralDirectoryInfo(inputZipSections.getZipEndOfCentralDirectory(), outputCentralDirRecordCount, byteBufferDataSource.size(), outputCentralDirStartOffset);
        ApkSignerEngine.OutputApkSigningBlockRequest2 outputApkSigningBlockRequest = signerEngine.outputZipSections2(outputApkIn, byteBufferDataSource, DataSources.asDataSource(outputEocd));
        if (outputApkSigningBlockRequest != null) {
            int padding = outputApkSigningBlockRequest.getPaddingSizeBeforeApkSigningBlock();
            byte[] outputApkSigningBlock = outputApkSigningBlockRequest.getApkSigningBlock();
            outputApkSigningBlockRequest.done();
            long fileSize = outputCentralDirStartOffset + byteBufferDataSource.size() + (long)padding + (long)outputApkSigningBlock.length + (long)outputEocd.remaining();
            if (this.mAlignFileSize && fileSize % 4096L != 0L) {
                int eocdPadding = (int)(4096L - fileSize % 4096L);
                outputEocd = EocdRecord.createWithPaddedComment(outputEocd, eocdPadding);
                outputApkSigningBlockRequest = signerEngine.outputZipSections2(outputApkIn, new ByteBufferDataSource(outputCentralDir), DataSources.asDataSource(outputEocd));
                outputApkSigningBlock = outputApkSigningBlockRequest.getApkSigningBlock();
                outputApkSigningBlockRequest.done();
            }
            outputApkOut.consume(ByteBuffer.allocate(padding));
            outputApkOut.consume(outputApkSigningBlock, 0, outputApkSigningBlock.length);
            ZipUtils.setZipEocdCentralDirectoryOffset(outputEocd, outputCentralDirStartOffset + (long)padding + (long)outputApkSigningBlock.length);
        }
        byteBufferDataSource.feed(0L, byteBufferDataSource.size(), outputApkOut);
        outputApkOut.consume(outputEocd);
        signerEngine.outputDone();
        if (this.mV4SigningEnabled) {
            signerEngine.signV4(outputApkIn, this.mOutputV4File, !this.mV4ErrorReportingEnabled);
        }
    }

    private static void requestOutputEntryInspection(ApkSignerEngine signerEngine, String entryName, byte[] uncompressedData) throws IOException {
        ApkSignerEngine.InspectJarEntryRequest inspectEntryRequest = signerEngine.outputJarEntry(entryName);
        if (inspectEntryRequest != null) {
            inspectEntryRequest.getDataSink().consume(uncompressedData, 0, uncompressedData.length);
            inspectEntryRequest.done();
        }
    }

    private static long outputDataToOutputApk(String entryName, byte[] uncompressedData, long localFileHeaderOffset, List<CentralDirectoryRecord> outputCdRecords, int lastModifiedTimeForNewEntries, int lastModifiedDateForNewEntries, DataSink outputApkOut) throws IOException {
        ZipUtils.DeflateResult deflateResult = ZipUtils.deflate(ByteBuffer.wrap(uncompressedData));
        byte[] compressedData = deflateResult.output;
        long uncompressedDataCrc32 = deflateResult.inputCrc32;
        long numOfDataBytes = LocalFileRecord.outputRecordWithDeflateCompressedData(entryName, lastModifiedTimeForNewEntries, lastModifiedDateForNewEntries, compressedData, uncompressedDataCrc32, uncompressedData.length, outputApkOut);
        outputCdRecords.add(CentralDirectoryRecord.createWithDeflateCompressedData(entryName, lastModifiedTimeForNewEntries, lastModifiedDateForNewEntries, uncompressedDataCrc32, compressedData.length, uncompressedData.length, localFileHeaderOffset));
        return numOfDataBytes;
    }

    private static void fulfillInspectInputJarEntryRequest(DataSource lfhSection, LocalFileRecord localFileRecord, ApkSignerEngine.InspectJarEntryRequest inspectEntryRequest) throws IOException, ApkFormatException {
        try {
            localFileRecord.outputUncompressedData(lfhSection, inspectEntryRequest.getDataSink());
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Malformed ZIP entry: " + localFileRecord.getName(), e);
        }
        inspectEntryRequest.done();
    }

    private OutputSizeAndDataOffset outputInputJarEntryLfhRecord(DataSource inputLfhSection, LocalFileRecord inputRecord, DataSink outputLfhSection, long outputOffset) throws IOException {
        long inputOffset = inputRecord.getStartOffsetInArchive();
        if (inputOffset == outputOffset && this.mAlignmentPreserved) {
            return new OutputSizeAndDataOffset(inputRecord.outputRecord(inputLfhSection, outputLfhSection), inputRecord.getDataStartOffsetInRecord());
        }
        int dataAlignmentMultiple = this.getInputJarEntryDataAlignmentMultiple(inputRecord);
        if (dataAlignmentMultiple <= 1 || inputOffset % (long)dataAlignmentMultiple == outputOffset % (long)dataAlignmentMultiple && this.mAlignmentPreserved) {
            return new OutputSizeAndDataOffset(inputRecord.outputRecord(inputLfhSection, outputLfhSection), inputRecord.getDataStartOffsetInRecord());
        }
        long inputDataStartOffset = inputOffset + (long)inputRecord.getDataStartOffsetInRecord();
        if (inputDataStartOffset % (long)dataAlignmentMultiple != 0L && this.mAlignmentPreserved) {
            return new OutputSizeAndDataOffset(inputRecord.outputRecord(inputLfhSection, outputLfhSection), inputRecord.getDataStartOffsetInRecord());
        }
        ByteBuffer aligningExtra = ApkSigner.createExtraFieldToAlignData(inputRecord.getExtra(), outputOffset + (long)inputRecord.getExtraFieldStartOffsetInsideRecord(), dataAlignmentMultiple);
        long dataOffset = (long)inputRecord.getDataStartOffsetInRecord() + (long)aligningExtra.remaining() - (long)inputRecord.getExtra().remaining();
        return new OutputSizeAndDataOffset(inputRecord.outputRecordWithModifiedExtra(inputLfhSection, aligningExtra, outputLfhSection), dataOffset);
    }

    private int getInputJarEntryDataAlignmentMultiple(LocalFileRecord entry) {
        if (entry.isDataCompressed()) {
            return 1;
        }
        ByteBuffer extra = entry.getExtra();
        if (extra.hasRemaining()) {
            extra.order(ByteOrder.LITTLE_ENDIAN);
            while (extra.remaining() >= 4) {
                short headerId = extra.getShort();
                int dataSize = ZipUtils.getUnsignedInt16(extra);
                if (dataSize > extra.remaining()) break;
                if (headerId != -9931) {
                    extra.position(extra.position() + dataSize);
                    continue;
                }
                if (dataSize < 2) break;
                return ZipUtils.getUnsignedInt16(extra);
            }
        }
        return entry.getName().endsWith(".so") ? this.mLibraryPageAlignmentBytes : 4;
    }

    private static ByteBuffer createExtraFieldToAlignData(ByteBuffer original, long extraStartOffset, int dataAlignmentMultiple) {
        if (dataAlignmentMultiple <= 1) {
            return original;
        }
        ByteBuffer result = ByteBuffer.allocate(original.remaining() + 5 + dataAlignmentMultiple);
        result.order(ByteOrder.LITTLE_ENDIAN);
        while (original.remaining() >= 4) {
            short headerId = original.getShort();
            int dataSize = ZipUtils.getUnsignedInt16(original);
            if (dataSize > original.remaining()) break;
            if (headerId == 0 && dataSize == 0 || headerId == -9931) {
                original.position(original.position() + dataSize);
                continue;
            }
            original.position(original.position() - 4);
            int originalLimit = original.limit();
            original.limit(original.position() + 4 + dataSize);
            result.put(original);
            original.limit(originalLimit);
        }
        long dataMinStartOffset = extraStartOffset + (long)result.position() + 6L;
        int paddingSizeBytes = (dataAlignmentMultiple - (int)(dataMinStartOffset % (long)dataAlignmentMultiple)) % dataAlignmentMultiple;
        result.putShort((short)-9931);
        ZipUtils.putUnsignedInt16(result, 2 + paddingSizeBytes);
        ZipUtils.putUnsignedInt16(result, dataAlignmentMultiple);
        result.position(result.position() + paddingSizeBytes);
        result.flip();
        return result;
    }

    private static ByteBuffer getZipCentralDirectory(DataSource apk, ApkUtils.ZipSections apkSections) throws IOException, ApkFormatException {
        long cdSizeBytes = apkSections.getZipCentralDirectorySizeBytes();
        if (cdSizeBytes > Integer.MAX_VALUE) {
            throw new ApkFormatException("ZIP Central Directory too large: " + cdSizeBytes);
        }
        long cdOffset = apkSections.getZipCentralDirectoryOffset();
        ByteBuffer cd = apk.getByteBuffer(cdOffset, (int)cdSizeBytes);
        cd.order(ByteOrder.LITTLE_ENDIAN);
        return cd;
    }

    private static List<CentralDirectoryRecord> parseZipCentralDirectory(ByteBuffer cd, ApkUtils.ZipSections apkSections) throws ApkFormatException {
        long cdOffset = apkSections.getZipCentralDirectoryOffset();
        int expectedCdRecordCount = apkSections.getZipCentralDirectoryRecordCount();
        ArrayList<CentralDirectoryRecord> cdRecords = new ArrayList<CentralDirectoryRecord>(expectedCdRecordCount);
        HashSet<String> entryNames = new HashSet<String>(expectedCdRecordCount);
        for (int i = 0; i < expectedCdRecordCount; ++i) {
            CentralDirectoryRecord cdRecord;
            int offsetInsideCd = cd.position();
            try {
                cdRecord = CentralDirectoryRecord.getRecord(cd);
            }
            catch (ZipFormatException e) {
                throw new ApkFormatException("Malformed ZIP Central Directory record #" + (i + 1) + " at file offset " + (cdOffset + (long)offsetInsideCd), e);
            }
            String entryName = cdRecord.getName();
            if (!entryNames.add(entryName)) {
                throw new ApkFormatException("Multiple ZIP entries with the same name: " + entryName);
            }
            cdRecords.add(cdRecord);
        }
        if (cd.hasRemaining()) {
            throw new ApkFormatException("Unused space at the end of ZIP Central Directory: " + cd.remaining() + " bytes starting at file offset " + (cdOffset + (long)cd.position()));
        }
        return cdRecords;
    }

    private static CentralDirectoryRecord findCdRecord(List<CentralDirectoryRecord> cdRecords, String name) {
        for (CentralDirectoryRecord cdRecord : cdRecords) {
            if (!name.equals(cdRecord.getName())) continue;
            return cdRecord;
        }
        return null;
    }

    static ByteBuffer getAndroidManifestFromApk(List<CentralDirectoryRecord> cdRecords, DataSource lhfSection) throws IOException, ApkFormatException, ZipFormatException {
        CentralDirectoryRecord androidManifestCdRecord = ApkSigner.findCdRecord(cdRecords, ANDROID_MANIFEST_ZIP_ENTRY_NAME);
        if (androidManifestCdRecord == null) {
            throw new ApkFormatException("Missing AndroidManifest.xml");
        }
        return ByteBuffer.wrap(LocalFileRecord.getUncompressedData(lhfSection, androidManifestCdRecord, lhfSection.size()));
    }

    private static List<Hints.PatternWithRange> extractPinPatterns(List<CentralDirectoryRecord> cdRecords, DataSource lhfSection) throws IOException, ApkFormatException {
        CentralDirectoryRecord pinListCdRecord = ApkSigner.findCdRecord(cdRecords, "assets/com.android.hints.pins.txt");
        ArrayList<Object> pinPatterns = null;
        if (pinListCdRecord != null) {
            byte[] patternBlob;
            pinPatterns = new ArrayList();
            try {
                patternBlob = LocalFileRecord.getUncompressedData(lhfSection, pinListCdRecord, lhfSection.size());
            }
            catch (ZipFormatException ex) {
                throw new ApkFormatException("Bad " + pinListCdRecord);
            }
            pinPatterns = Hints.parsePinPatterns(patternBlob);
        }
        return pinPatterns;
    }

    private static int getMinSdkVersionFromApk(List<CentralDirectoryRecord> cdRecords, DataSource lhfSection) throws IOException, MinSdkVersionException {
        ByteBuffer androidManifest;
        try {
            androidManifest = ApkSigner.getAndroidManifestFromApk(cdRecords, lhfSection);
        }
        catch (ApkFormatException | ZipFormatException e) {
            throw new MinSdkVersionException("Failed to determine APK's minimum supported Android platform version", e);
        }
        return ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(androidManifest);
    }

    public static class SignerConfig {
        private final String mName;
        private final KeyConfig mKeyConfig;
        private final List<X509Certificate> mCertificates;
        private final boolean mDeterministicDsaSigning;
        private final int mMinSdkVersion;
        private final SigningCertificateLineage mSigningCertificateLineage;

        private SignerConfig(Builder builder) {
            this.mName = builder.mName;
            this.mKeyConfig = builder.mKeyConfig;
            this.mCertificates = Collections.unmodifiableList(new ArrayList(builder.mCertificates));
            this.mDeterministicDsaSigning = builder.mDeterministicDsaSigning;
            this.mMinSdkVersion = builder.mMinSdkVersion;
            this.mSigningCertificateLineage = builder.mSigningCertificateLineage;
        }

        public String getName() {
            return this.mName;
        }

        @Deprecated
        public PrivateKey getPrivateKey() {
            return this.mKeyConfig.match(jca -> jca.privateKey, kms -> null);
        }

        public KeyConfig getKeyConfig() {
            return this.mKeyConfig;
        }

        public List<X509Certificate> getCertificates() {
            return this.mCertificates;
        }

        public boolean getDeterministicDsaSigning() {
            return this.mDeterministicDsaSigning;
        }

        public int getMinSdkVersion() {
            return this.mMinSdkVersion;
        }

        public SigningCertificateLineage getSigningCertificateLineage() {
            return this.mSigningCertificateLineage;
        }

        public static class Builder {
            private final String mName;
            private final KeyConfig mKeyConfig;
            private final List<X509Certificate> mCertificates;
            private final boolean mDeterministicDsaSigning;
            private int mMinSdkVersion;
            private SigningCertificateLineage mSigningCertificateLineage;

            @Deprecated
            public Builder(String name, PrivateKey privateKey, List<X509Certificate> certificates) {
                this(name, privateKey, certificates, false);
            }

            @Deprecated
            public Builder(String name, PrivateKey privateKey, List<X509Certificate> certificates, boolean deterministicDsaSigning) {
                if (name.isEmpty()) {
                    throw new IllegalArgumentException("Empty name");
                }
                this.mName = name;
                this.mKeyConfig = new KeyConfig.Jca(privateKey);
                this.mCertificates = new ArrayList<X509Certificate>(certificates);
                this.mDeterministicDsaSigning = deterministicDsaSigning;
            }

            public Builder(String name, KeyConfig keyConfig, List<X509Certificate> certificates) {
                this(name, keyConfig, certificates, false);
            }

            public Builder(String name, KeyConfig keyConfig, List<X509Certificate> certificates, boolean deterministicDsaSigning) {
                if (name.isEmpty()) {
                    throw new IllegalArgumentException("Empty name");
                }
                this.mName = name;
                this.mKeyConfig = keyConfig;
                this.mCertificates = new ArrayList<X509Certificate>(certificates);
                this.mDeterministicDsaSigning = deterministicDsaSigning;
            }

            public Builder setMinSdkVersion(int minSdkVersion) {
                return this.setLineageForMinSdkVersion(null, minSdkVersion);
            }

            public Builder setLineageForMinSdkVersion(SigningCertificateLineage lineage, int minSdkVersion) {
                if (minSdkVersion < 28) {
                    throw new IllegalArgumentException("SDK targeted signing config is only supported with the V3 signature scheme on Android P (SDK version 28) and later");
                }
                if (minSdkVersion < 33) {
                    minSdkVersion = 28;
                }
                this.mMinSdkVersion = minSdkVersion;
                if (lineage != null && !lineage.isCertificateInLineage(this.mCertificates.get(0))) {
                    throw new IllegalArgumentException("The provided lineage does not contain the signing certificate, " + this.mCertificates.get(0).getSubjectDN() + ", for this SignerConfig");
                }
                this.mSigningCertificateLineage = lineage;
                return this;
            }

            public SignerConfig build() {
                return new SignerConfig(this);
            }
        }
    }

    private static class OutputSizeAndDataOffset {
        public long outputBytes;
        public long dataOffsetBytes;

        public OutputSizeAndDataOffset(long outputBytes, long dataOffsetBytes) {
            this.outputBytes = outputBytes;
            this.dataOffsetBytes = dataOffsetBytes;
        }
    }

    public static class Builder {
        private final List<SignerConfig> mSignerConfigs;
        private SignerConfig mSourceStampSignerConfig;
        private SigningCertificateLineage mSourceStampSigningCertificateLineage;
        private boolean mForceSourceStampOverwrite = false;
        private boolean mSourceStampTimestampEnabled = true;
        private boolean mV1SigningEnabled = true;
        private boolean mV2SigningEnabled = true;
        private boolean mV3SigningEnabled = true;
        private boolean mV4SigningEnabled = false;
        private boolean mAlignFileSize = false;
        private boolean mVerityEnabled = false;
        private boolean mV4ErrorReportingEnabled = false;
        private boolean mDebuggableApkPermitted = true;
        private boolean mOtherSignersSignaturesPreserved;
        private boolean mAlignmentPreserved = false;
        private int mLibraryPageAlignmentBytes = 16384;
        private String mCreatedBy;
        private Integer mMinSdkVersion;
        private int mRotationMinSdkVersion = 33;
        private boolean mRotationTargetsDevRelease = false;
        private final ApkSignerEngine mSignerEngine;
        private File mInputApkFile;
        private DataSource mInputApkDataSource;
        private File mOutputApkFile;
        private DataSink mOutputApkDataSink;
        private DataSource mOutputApkDataSource;
        private File mOutputV4File;
        private SigningCertificateLineage mSigningCertificateLineage;
        private boolean mV3SigningExplicitlyDisabled = false;
        private boolean mV3SigningExplicitlyEnabled = false;

        public Builder(List<SignerConfig> signerConfigs) {
            if (signerConfigs.isEmpty()) {
                throw new IllegalArgumentException("At least one signer config must be provided");
            }
            if (signerConfigs.size() > 1) {
                this.mV3SigningEnabled = false;
            }
            this.mSignerConfigs = new ArrayList<SignerConfig>(signerConfigs);
            this.mSignerEngine = null;
        }

        public Builder(ApkSignerEngine signerEngine) {
            if (signerEngine == null) {
                throw new NullPointerException("signerEngine == null");
            }
            this.mSignerEngine = signerEngine;
            this.mSignerConfigs = null;
        }

        public Builder setSourceStampSignerConfig(SignerConfig sourceStampSignerConfig) {
            this.mSourceStampSignerConfig = sourceStampSignerConfig;
            return this;
        }

        public Builder setSourceStampSigningCertificateLineage(SigningCertificateLineage sourceStampSigningCertificateLineage) {
            this.mSourceStampSigningCertificateLineage = sourceStampSigningCertificateLineage;
            return this;
        }

        public Builder setForceSourceStampOverwrite(boolean force) {
            this.mForceSourceStampOverwrite = force;
            return this;
        }

        public Builder setSourceStampTimestampEnabled(boolean value) {
            this.mSourceStampTimestampEnabled = value;
            return this;
        }

        public Builder setInputApk(File inputApk) {
            if (inputApk == null) {
                throw new NullPointerException("inputApk == null");
            }
            this.mInputApkFile = inputApk;
            this.mInputApkDataSource = null;
            return this;
        }

        public Builder setInputApk(DataSource inputApk) {
            if (inputApk == null) {
                throw new NullPointerException("inputApk == null");
            }
            this.mInputApkDataSource = inputApk;
            this.mInputApkFile = null;
            return this;
        }

        public Builder setOutputApk(File outputApk) {
            if (outputApk == null) {
                throw new NullPointerException("outputApk == null");
            }
            this.mOutputApkFile = outputApk;
            this.mOutputApkDataSink = null;
            this.mOutputApkDataSource = null;
            return this;
        }

        public Builder setOutputApk(ReadableDataSink outputApk) {
            if (outputApk == null) {
                throw new NullPointerException("outputApk == null");
            }
            return this.setOutputApk(outputApk, outputApk);
        }

        public Builder setOutputApk(DataSink outputApkOut, DataSource outputApkIn) {
            if (outputApkOut == null) {
                throw new NullPointerException("outputApkOut == null");
            }
            if (outputApkIn == null) {
                throw new NullPointerException("outputApkIn == null");
            }
            this.mOutputApkFile = null;
            this.mOutputApkDataSink = outputApkOut;
            this.mOutputApkDataSource = outputApkIn;
            return this;
        }

        public Builder setV4SignatureOutputFile(File v4SignatureOutputFile) {
            if (v4SignatureOutputFile == null) {
                throw new NullPointerException("v4HashRootOutputFile == null");
            }
            this.mOutputV4File = v4SignatureOutputFile;
            return this;
        }

        public Builder setMinSdkVersion(int minSdkVersion) {
            this.checkInitializedWithoutEngine();
            this.mMinSdkVersion = minSdkVersion;
            return this;
        }

        public Builder setMinSdkVersionForRotation(int minSdkVersion) {
            this.checkInitializedWithoutEngine();
            this.mRotationMinSdkVersion = minSdkVersion < 33 ? 28 : minSdkVersion;
            return this;
        }

        public Builder setRotationTargetsDevRelease(boolean enabled) {
            this.checkInitializedWithoutEngine();
            this.mRotationTargetsDevRelease = enabled;
            return this;
        }

        public Builder setV1SigningEnabled(boolean enabled) {
            this.checkInitializedWithoutEngine();
            this.mV1SigningEnabled = enabled;
            return this;
        }

        public Builder setV2SigningEnabled(boolean enabled) {
            this.checkInitializedWithoutEngine();
            this.mV2SigningEnabled = enabled;
            return this;
        }

        public Builder setV3SigningEnabled(boolean enabled) {
            this.checkInitializedWithoutEngine();
            this.mV3SigningEnabled = enabled;
            if (enabled) {
                this.mV3SigningExplicitlyEnabled = true;
            } else {
                this.mV3SigningExplicitlyDisabled = true;
            }
            return this;
        }

        public Builder setV4SigningEnabled(boolean enabled) {
            this.checkInitializedWithoutEngine();
            this.mV4SigningEnabled = enabled;
            this.mV4ErrorReportingEnabled = enabled;
            return this;
        }

        public Builder setV4ErrorReportingEnabled(boolean enabled) {
            this.checkInitializedWithoutEngine();
            this.mV4ErrorReportingEnabled = enabled;
            return this;
        }

        public Builder setAlignFileSize(boolean alignFileSize) {
            this.checkInitializedWithoutEngine();
            this.mAlignFileSize = alignFileSize;
            return this;
        }

        public Builder setVerityEnabled(boolean enabled) {
            this.checkInitializedWithoutEngine();
            this.mVerityEnabled = enabled;
            return this;
        }

        public Builder setDebuggableApkPermitted(boolean permitted) {
            this.checkInitializedWithoutEngine();
            this.mDebuggableApkPermitted = permitted;
            return this;
        }

        public Builder setOtherSignersSignaturesPreserved(boolean preserved) {
            this.checkInitializedWithoutEngine();
            this.mOtherSignersSignaturesPreserved = preserved;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.checkInitializedWithoutEngine();
            if (createdBy == null) {
                throw new NullPointerException();
            }
            this.mCreatedBy = createdBy;
            return this;
        }

        private void checkInitializedWithoutEngine() {
            if (this.mSignerEngine != null) {
                throw new IllegalStateException("Operation is not available when builder initialized with an engine");
            }
        }

        public Builder setSigningCertificateLineage(SigningCertificateLineage signingCertificateLineage) {
            if (signingCertificateLineage != null) {
                this.mV3SigningEnabled = true;
                this.mSigningCertificateLineage = signingCertificateLineage;
            }
            return this;
        }

        public Builder setAlignmentPreserved(boolean alignmentPreserved) {
            this.mAlignmentPreserved = alignmentPreserved;
            return this;
        }

        public Builder setLibraryPageAlignmentBytes(int libraryPageAlignmentBytes) {
            this.mLibraryPageAlignmentBytes = libraryPageAlignmentBytes;
            return this;
        }

        public ApkSigner build() {
            if (this.mV3SigningExplicitlyDisabled && this.mV3SigningExplicitlyEnabled) {
                throw new IllegalStateException("Builder configured to both enable and disable APK Signature Scheme v3 signing");
            }
            if (this.mV3SigningExplicitlyDisabled) {
                this.mV3SigningEnabled = false;
            }
            if (this.mV3SigningExplicitlyEnabled) {
                this.mV3SigningEnabled = true;
            }
            if (this.mV4SigningEnabled && !this.mV2SigningEnabled && !this.mV3SigningEnabled) {
                if (!this.mV4ErrorReportingEnabled) {
                    this.mV4SigningEnabled = false;
                } else {
                    throw new IllegalStateException("APK Signature Scheme v4 signing requires at least v2 or v3 signing to be enabled");
                }
            }
            return new ApkSigner(this.mSignerConfigs, this.mSourceStampSignerConfig, this.mSourceStampSigningCertificateLineage, this.mForceSourceStampOverwrite, this.mSourceStampTimestampEnabled, this.mMinSdkVersion, this.mRotationMinSdkVersion, this.mRotationTargetsDevRelease, this.mV1SigningEnabled, this.mV2SigningEnabled, this.mV3SigningEnabled, this.mV4SigningEnabled, this.mAlignFileSize, this.mVerityEnabled, this.mV4ErrorReportingEnabled, this.mDebuggableApkPermitted, this.mOtherSignersSignaturesPreserved, this.mAlignmentPreserved, this.mLibraryPageAlignmentBytes, this.mCreatedBy, this.mSignerEngine, this.mInputApkFile, this.mInputApkDataSource, this.mOutputApkFile, this.mOutputApkDataSink, this.mOutputApkDataSource, this.mOutputV4File, this.mSigningCertificateLineage);
        }
    }
}

