/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AlgorithmSpecification;
import com.amazonaws.services.sagemaker.model.Channel;
import com.amazonaws.services.sagemaker.model.CheckpointConfig;
import com.amazonaws.services.sagemaker.model.DebugHookConfig;
import com.amazonaws.services.sagemaker.model.DebugRuleConfiguration;
import com.amazonaws.services.sagemaker.model.DebugRuleEvaluationStatus;
import com.amazonaws.services.sagemaker.model.ExperimentConfig;
import com.amazonaws.services.sagemaker.model.MetricData;
import com.amazonaws.services.sagemaker.model.ModelArtifacts;
import com.amazonaws.services.sagemaker.model.OutputDataConfig;
import com.amazonaws.services.sagemaker.model.ProfilerConfig;
import com.amazonaws.services.sagemaker.model.ResourceConfig;
import com.amazonaws.services.sagemaker.model.RetryStrategy;
import com.amazonaws.services.sagemaker.model.SecondaryStatus;
import com.amazonaws.services.sagemaker.model.SecondaryStatusTransition;
import com.amazonaws.services.sagemaker.model.StoppingCondition;
import com.amazonaws.services.sagemaker.model.Tag;
import com.amazonaws.services.sagemaker.model.TensorBoardOutputConfig;
import com.amazonaws.services.sagemaker.model.TrainingJobStatus;
import com.amazonaws.services.sagemaker.model.VpcConfig;
import com.amazonaws.services.sagemaker.model.transform.TrainingJobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrainingJob
implements Serializable,
Cloneable,
StructuredPojo {
    private String trainingJobName;
    private String trainingJobArn;
    private String tuningJobArn;
    private String labelingJobArn;
    private String autoMLJobArn;
    private ModelArtifacts modelArtifacts;
    private String trainingJobStatus;
    private String secondaryStatus;
    private String failureReason;
    private Map<String, String> hyperParameters;
    private AlgorithmSpecification algorithmSpecification;
    private String roleArn;
    private List<Channel> inputDataConfig;
    private OutputDataConfig outputDataConfig;
    private ResourceConfig resourceConfig;
    private VpcConfig vpcConfig;
    private StoppingCondition stoppingCondition;
    private Date creationTime;
    private Date trainingStartTime;
    private Date trainingEndTime;
    private Date lastModifiedTime;
    private List<SecondaryStatusTransition> secondaryStatusTransitions;
    private List<MetricData> finalMetricDataList;
    private Boolean enableNetworkIsolation;
    private Boolean enableInterContainerTrafficEncryption;
    private Boolean enableManagedSpotTraining;
    private CheckpointConfig checkpointConfig;
    private Integer trainingTimeInSeconds;
    private Integer billableTimeInSeconds;
    private DebugHookConfig debugHookConfig;
    private ExperimentConfig experimentConfig;
    private List<DebugRuleConfiguration> debugRuleConfigurations;
    private TensorBoardOutputConfig tensorBoardOutputConfig;
    private List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses;
    private ProfilerConfig profilerConfig;
    private Map<String, String> environment;
    private RetryStrategy retryStrategy;
    private List<Tag> tags;

    public void setTrainingJobName(String trainingJobName) {
        this.trainingJobName = trainingJobName;
    }

    public String getTrainingJobName() {
        return this.trainingJobName;
    }

    public TrainingJob withTrainingJobName(String trainingJobName) {
        this.setTrainingJobName(trainingJobName);
        return this;
    }

    public void setTrainingJobArn(String trainingJobArn) {
        this.trainingJobArn = trainingJobArn;
    }

    public String getTrainingJobArn() {
        return this.trainingJobArn;
    }

    public TrainingJob withTrainingJobArn(String trainingJobArn) {
        this.setTrainingJobArn(trainingJobArn);
        return this;
    }

    public void setTuningJobArn(String tuningJobArn) {
        this.tuningJobArn = tuningJobArn;
    }

    public String getTuningJobArn() {
        return this.tuningJobArn;
    }

    public TrainingJob withTuningJobArn(String tuningJobArn) {
        this.setTuningJobArn(tuningJobArn);
        return this;
    }

    public void setLabelingJobArn(String labelingJobArn) {
        this.labelingJobArn = labelingJobArn;
    }

    public String getLabelingJobArn() {
        return this.labelingJobArn;
    }

    public TrainingJob withLabelingJobArn(String labelingJobArn) {
        this.setLabelingJobArn(labelingJobArn);
        return this;
    }

    public void setAutoMLJobArn(String autoMLJobArn) {
        this.autoMLJobArn = autoMLJobArn;
    }

    public String getAutoMLJobArn() {
        return this.autoMLJobArn;
    }

    public TrainingJob withAutoMLJobArn(String autoMLJobArn) {
        this.setAutoMLJobArn(autoMLJobArn);
        return this;
    }

    public void setModelArtifacts(ModelArtifacts modelArtifacts) {
        this.modelArtifacts = modelArtifacts;
    }

    public ModelArtifacts getModelArtifacts() {
        return this.modelArtifacts;
    }

    public TrainingJob withModelArtifacts(ModelArtifacts modelArtifacts) {
        this.setModelArtifacts(modelArtifacts);
        return this;
    }

    public void setTrainingJobStatus(String trainingJobStatus) {
        this.trainingJobStatus = trainingJobStatus;
    }

    public String getTrainingJobStatus() {
        return this.trainingJobStatus;
    }

    public TrainingJob withTrainingJobStatus(String trainingJobStatus) {
        this.setTrainingJobStatus(trainingJobStatus);
        return this;
    }

    public TrainingJob withTrainingJobStatus(TrainingJobStatus trainingJobStatus) {
        this.trainingJobStatus = trainingJobStatus.toString();
        return this;
    }

    public void setSecondaryStatus(String secondaryStatus) {
        this.secondaryStatus = secondaryStatus;
    }

    public String getSecondaryStatus() {
        return this.secondaryStatus;
    }

    public TrainingJob withSecondaryStatus(String secondaryStatus) {
        this.setSecondaryStatus(secondaryStatus);
        return this;
    }

    public TrainingJob withSecondaryStatus(SecondaryStatus secondaryStatus) {
        this.secondaryStatus = secondaryStatus.toString();
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public TrainingJob withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public Map<String, String> getHyperParameters() {
        return this.hyperParameters;
    }

    public void setHyperParameters(Map<String, String> hyperParameters) {
        this.hyperParameters = hyperParameters;
    }

    public TrainingJob withHyperParameters(Map<String, String> hyperParameters) {
        this.setHyperParameters(hyperParameters);
        return this;
    }

    public TrainingJob addHyperParametersEntry(String key, String value) {
        if (null == this.hyperParameters) {
            this.hyperParameters = new HashMap<String, String>();
        }
        if (this.hyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.hyperParameters.put(key, value);
        return this;
    }

    public TrainingJob clearHyperParametersEntries() {
        this.hyperParameters = null;
        return this;
    }

    public void setAlgorithmSpecification(AlgorithmSpecification algorithmSpecification) {
        this.algorithmSpecification = algorithmSpecification;
    }

    public AlgorithmSpecification getAlgorithmSpecification() {
        return this.algorithmSpecification;
    }

    public TrainingJob withAlgorithmSpecification(AlgorithmSpecification algorithmSpecification) {
        this.setAlgorithmSpecification(algorithmSpecification);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public TrainingJob withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Channel> getInputDataConfig() {
        return this.inputDataConfig;
    }

    public void setInputDataConfig(Collection<Channel> inputDataConfig) {
        if (inputDataConfig == null) {
            this.inputDataConfig = null;
            return;
        }
        this.inputDataConfig = new ArrayList<Channel>(inputDataConfig);
    }

    public TrainingJob withInputDataConfig(Channel ... inputDataConfig) {
        if (this.inputDataConfig == null) {
            this.setInputDataConfig(new ArrayList<Channel>(inputDataConfig.length));
        }
        for (Channel ele : inputDataConfig) {
            this.inputDataConfig.add(ele);
        }
        return this;
    }

    public TrainingJob withInputDataConfig(Collection<Channel> inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public OutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public TrainingJob withOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public TrainingJob withResourceConfig(ResourceConfig resourceConfig) {
        this.setResourceConfig(resourceConfig);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public TrainingJob withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setStoppingCondition(StoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public StoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public TrainingJob withStoppingCondition(StoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public TrainingJob withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setTrainingStartTime(Date trainingStartTime) {
        this.trainingStartTime = trainingStartTime;
    }

    public Date getTrainingStartTime() {
        return this.trainingStartTime;
    }

    public TrainingJob withTrainingStartTime(Date trainingStartTime) {
        this.setTrainingStartTime(trainingStartTime);
        return this;
    }

    public void setTrainingEndTime(Date trainingEndTime) {
        this.trainingEndTime = trainingEndTime;
    }

    public Date getTrainingEndTime() {
        return this.trainingEndTime;
    }

    public TrainingJob withTrainingEndTime(Date trainingEndTime) {
        this.setTrainingEndTime(trainingEndTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TrainingJob withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public List<SecondaryStatusTransition> getSecondaryStatusTransitions() {
        return this.secondaryStatusTransitions;
    }

    public void setSecondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
        if (secondaryStatusTransitions == null) {
            this.secondaryStatusTransitions = null;
            return;
        }
        this.secondaryStatusTransitions = new ArrayList<SecondaryStatusTransition>(secondaryStatusTransitions);
    }

    public TrainingJob withSecondaryStatusTransitions(SecondaryStatusTransition ... secondaryStatusTransitions) {
        if (this.secondaryStatusTransitions == null) {
            this.setSecondaryStatusTransitions(new ArrayList<SecondaryStatusTransition>(secondaryStatusTransitions.length));
        }
        for (SecondaryStatusTransition ele : secondaryStatusTransitions) {
            this.secondaryStatusTransitions.add(ele);
        }
        return this;
    }

    public TrainingJob withSecondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
        this.setSecondaryStatusTransitions(secondaryStatusTransitions);
        return this;
    }

    public List<MetricData> getFinalMetricDataList() {
        return this.finalMetricDataList;
    }

    public void setFinalMetricDataList(Collection<MetricData> finalMetricDataList) {
        if (finalMetricDataList == null) {
            this.finalMetricDataList = null;
            return;
        }
        this.finalMetricDataList = new ArrayList<MetricData>(finalMetricDataList);
    }

    public TrainingJob withFinalMetricDataList(MetricData ... finalMetricDataList) {
        if (this.finalMetricDataList == null) {
            this.setFinalMetricDataList(new ArrayList<MetricData>(finalMetricDataList.length));
        }
        for (MetricData ele : finalMetricDataList) {
            this.finalMetricDataList.add(ele);
        }
        return this;
    }

    public TrainingJob withFinalMetricDataList(Collection<MetricData> finalMetricDataList) {
        this.setFinalMetricDataList(finalMetricDataList);
        return this;
    }

    public void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.enableNetworkIsolation = enableNetworkIsolation;
    }

    public Boolean getEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public TrainingJob withEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.setEnableNetworkIsolation(enableNetworkIsolation);
        return this;
    }

    public Boolean isEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
        this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
    }

    public Boolean getEnableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public TrainingJob withEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
        this.setEnableInterContainerTrafficEncryption(enableInterContainerTrafficEncryption);
        return this;
    }

    public Boolean isEnableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
        this.enableManagedSpotTraining = enableManagedSpotTraining;
    }

    public Boolean getEnableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public TrainingJob withEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
        this.setEnableManagedSpotTraining(enableManagedSpotTraining);
        return this;
    }

    public Boolean isEnableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public TrainingJob withCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.setCheckpointConfig(checkpointConfig);
        return this;
    }

    public void setTrainingTimeInSeconds(Integer trainingTimeInSeconds) {
        this.trainingTimeInSeconds = trainingTimeInSeconds;
    }

    public Integer getTrainingTimeInSeconds() {
        return this.trainingTimeInSeconds;
    }

    public TrainingJob withTrainingTimeInSeconds(Integer trainingTimeInSeconds) {
        this.setTrainingTimeInSeconds(trainingTimeInSeconds);
        return this;
    }

    public void setBillableTimeInSeconds(Integer billableTimeInSeconds) {
        this.billableTimeInSeconds = billableTimeInSeconds;
    }

    public Integer getBillableTimeInSeconds() {
        return this.billableTimeInSeconds;
    }

    public TrainingJob withBillableTimeInSeconds(Integer billableTimeInSeconds) {
        this.setBillableTimeInSeconds(billableTimeInSeconds);
        return this;
    }

    public void setDebugHookConfig(DebugHookConfig debugHookConfig) {
        this.debugHookConfig = debugHookConfig;
    }

    public DebugHookConfig getDebugHookConfig() {
        return this.debugHookConfig;
    }

    public TrainingJob withDebugHookConfig(DebugHookConfig debugHookConfig) {
        this.setDebugHookConfig(debugHookConfig);
        return this;
    }

    public void setExperimentConfig(ExperimentConfig experimentConfig) {
        this.experimentConfig = experimentConfig;
    }

    public ExperimentConfig getExperimentConfig() {
        return this.experimentConfig;
    }

    public TrainingJob withExperimentConfig(ExperimentConfig experimentConfig) {
        this.setExperimentConfig(experimentConfig);
        return this;
    }

    public List<DebugRuleConfiguration> getDebugRuleConfigurations() {
        return this.debugRuleConfigurations;
    }

    public void setDebugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations) {
        if (debugRuleConfigurations == null) {
            this.debugRuleConfigurations = null;
            return;
        }
        this.debugRuleConfigurations = new ArrayList<DebugRuleConfiguration>(debugRuleConfigurations);
    }

    public TrainingJob withDebugRuleConfigurations(DebugRuleConfiguration ... debugRuleConfigurations) {
        if (this.debugRuleConfigurations == null) {
            this.setDebugRuleConfigurations(new ArrayList<DebugRuleConfiguration>(debugRuleConfigurations.length));
        }
        for (DebugRuleConfiguration ele : debugRuleConfigurations) {
            this.debugRuleConfigurations.add(ele);
        }
        return this;
    }

    public TrainingJob withDebugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations) {
        this.setDebugRuleConfigurations(debugRuleConfigurations);
        return this;
    }

    public void setTensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig) {
        this.tensorBoardOutputConfig = tensorBoardOutputConfig;
    }

    public TensorBoardOutputConfig getTensorBoardOutputConfig() {
        return this.tensorBoardOutputConfig;
    }

    public TrainingJob withTensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig) {
        this.setTensorBoardOutputConfig(tensorBoardOutputConfig);
        return this;
    }

    public List<DebugRuleEvaluationStatus> getDebugRuleEvaluationStatuses() {
        return this.debugRuleEvaluationStatuses;
    }

    public void setDebugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses) {
        if (debugRuleEvaluationStatuses == null) {
            this.debugRuleEvaluationStatuses = null;
            return;
        }
        this.debugRuleEvaluationStatuses = new ArrayList<DebugRuleEvaluationStatus>(debugRuleEvaluationStatuses);
    }

    public TrainingJob withDebugRuleEvaluationStatuses(DebugRuleEvaluationStatus ... debugRuleEvaluationStatuses) {
        if (this.debugRuleEvaluationStatuses == null) {
            this.setDebugRuleEvaluationStatuses(new ArrayList<DebugRuleEvaluationStatus>(debugRuleEvaluationStatuses.length));
        }
        for (DebugRuleEvaluationStatus ele : debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses.add(ele);
        }
        return this;
    }

    public TrainingJob withDebugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses) {
        this.setDebugRuleEvaluationStatuses(debugRuleEvaluationStatuses);
        return this;
    }

    public void setProfilerConfig(ProfilerConfig profilerConfig) {
        this.profilerConfig = profilerConfig;
    }

    public ProfilerConfig getProfilerConfig() {
        return this.profilerConfig;
    }

    public TrainingJob withProfilerConfig(ProfilerConfig profilerConfig) {
        this.setProfilerConfig(profilerConfig);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public TrainingJob withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public TrainingJob addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public TrainingJob clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public TrainingJob withRetryStrategy(RetryStrategy retryStrategy) {
        this.setRetryStrategy(retryStrategy);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public TrainingJob withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TrainingJob withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrainingJobName() != null) {
            sb.append("TrainingJobName: ").append(this.getTrainingJobName()).append(",");
        }
        if (this.getTrainingJobArn() != null) {
            sb.append("TrainingJobArn: ").append(this.getTrainingJobArn()).append(",");
        }
        if (this.getTuningJobArn() != null) {
            sb.append("TuningJobArn: ").append(this.getTuningJobArn()).append(",");
        }
        if (this.getLabelingJobArn() != null) {
            sb.append("LabelingJobArn: ").append(this.getLabelingJobArn()).append(",");
        }
        if (this.getAutoMLJobArn() != null) {
            sb.append("AutoMLJobArn: ").append(this.getAutoMLJobArn()).append(",");
        }
        if (this.getModelArtifacts() != null) {
            sb.append("ModelArtifacts: ").append(this.getModelArtifacts()).append(",");
        }
        if (this.getTrainingJobStatus() != null) {
            sb.append("TrainingJobStatus: ").append(this.getTrainingJobStatus()).append(",");
        }
        if (this.getSecondaryStatus() != null) {
            sb.append("SecondaryStatus: ").append(this.getSecondaryStatus()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getHyperParameters() != null) {
            sb.append("HyperParameters: ").append(this.getHyperParameters()).append(",");
        }
        if (this.getAlgorithmSpecification() != null) {
            sb.append("AlgorithmSpecification: ").append(this.getAlgorithmSpecification()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getResourceConfig() != null) {
            sb.append("ResourceConfig: ").append(this.getResourceConfig()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getTrainingStartTime() != null) {
            sb.append("TrainingStartTime: ").append(this.getTrainingStartTime()).append(",");
        }
        if (this.getTrainingEndTime() != null) {
            sb.append("TrainingEndTime: ").append(this.getTrainingEndTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getSecondaryStatusTransitions() != null) {
            sb.append("SecondaryStatusTransitions: ").append(this.getSecondaryStatusTransitions()).append(",");
        }
        if (this.getFinalMetricDataList() != null) {
            sb.append("FinalMetricDataList: ").append(this.getFinalMetricDataList()).append(",");
        }
        if (this.getEnableNetworkIsolation() != null) {
            sb.append("EnableNetworkIsolation: ").append(this.getEnableNetworkIsolation()).append(",");
        }
        if (this.getEnableInterContainerTrafficEncryption() != null) {
            sb.append("EnableInterContainerTrafficEncryption: ").append(this.getEnableInterContainerTrafficEncryption()).append(",");
        }
        if (this.getEnableManagedSpotTraining() != null) {
            sb.append("EnableManagedSpotTraining: ").append(this.getEnableManagedSpotTraining()).append(",");
        }
        if (this.getCheckpointConfig() != null) {
            sb.append("CheckpointConfig: ").append(this.getCheckpointConfig()).append(",");
        }
        if (this.getTrainingTimeInSeconds() != null) {
            sb.append("TrainingTimeInSeconds: ").append(this.getTrainingTimeInSeconds()).append(",");
        }
        if (this.getBillableTimeInSeconds() != null) {
            sb.append("BillableTimeInSeconds: ").append(this.getBillableTimeInSeconds()).append(",");
        }
        if (this.getDebugHookConfig() != null) {
            sb.append("DebugHookConfig: ").append(this.getDebugHookConfig()).append(",");
        }
        if (this.getExperimentConfig() != null) {
            sb.append("ExperimentConfig: ").append(this.getExperimentConfig()).append(",");
        }
        if (this.getDebugRuleConfigurations() != null) {
            sb.append("DebugRuleConfigurations: ").append(this.getDebugRuleConfigurations()).append(",");
        }
        if (this.getTensorBoardOutputConfig() != null) {
            sb.append("TensorBoardOutputConfig: ").append(this.getTensorBoardOutputConfig()).append(",");
        }
        if (this.getDebugRuleEvaluationStatuses() != null) {
            sb.append("DebugRuleEvaluationStatuses: ").append(this.getDebugRuleEvaluationStatuses()).append(",");
        }
        if (this.getProfilerConfig() != null) {
            sb.append("ProfilerConfig: ").append(this.getProfilerConfig()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getRetryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.getRetryStrategy()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJob)) {
            return false;
        }
        TrainingJob other = (TrainingJob)obj;
        if (other.getTrainingJobName() == null ^ this.getTrainingJobName() == null) {
            return false;
        }
        if (other.getTrainingJobName() != null && !other.getTrainingJobName().equals(this.getTrainingJobName())) {
            return false;
        }
        if (other.getTrainingJobArn() == null ^ this.getTrainingJobArn() == null) {
            return false;
        }
        if (other.getTrainingJobArn() != null && !other.getTrainingJobArn().equals(this.getTrainingJobArn())) {
            return false;
        }
        if (other.getTuningJobArn() == null ^ this.getTuningJobArn() == null) {
            return false;
        }
        if (other.getTuningJobArn() != null && !other.getTuningJobArn().equals(this.getTuningJobArn())) {
            return false;
        }
        if (other.getLabelingJobArn() == null ^ this.getLabelingJobArn() == null) {
            return false;
        }
        if (other.getLabelingJobArn() != null && !other.getLabelingJobArn().equals(this.getLabelingJobArn())) {
            return false;
        }
        if (other.getAutoMLJobArn() == null ^ this.getAutoMLJobArn() == null) {
            return false;
        }
        if (other.getAutoMLJobArn() != null && !other.getAutoMLJobArn().equals(this.getAutoMLJobArn())) {
            return false;
        }
        if (other.getModelArtifacts() == null ^ this.getModelArtifacts() == null) {
            return false;
        }
        if (other.getModelArtifacts() != null && !other.getModelArtifacts().equals(this.getModelArtifacts())) {
            return false;
        }
        if (other.getTrainingJobStatus() == null ^ this.getTrainingJobStatus() == null) {
            return false;
        }
        if (other.getTrainingJobStatus() != null && !other.getTrainingJobStatus().equals(this.getTrainingJobStatus())) {
            return false;
        }
        if (other.getSecondaryStatus() == null ^ this.getSecondaryStatus() == null) {
            return false;
        }
        if (other.getSecondaryStatus() != null && !other.getSecondaryStatus().equals(this.getSecondaryStatus())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getHyperParameters() == null ^ this.getHyperParameters() == null) {
            return false;
        }
        if (other.getHyperParameters() != null && !other.getHyperParameters().equals(this.getHyperParameters())) {
            return false;
        }
        if (other.getAlgorithmSpecification() == null ^ this.getAlgorithmSpecification() == null) {
            return false;
        }
        if (other.getAlgorithmSpecification() != null && !other.getAlgorithmSpecification().equals(this.getAlgorithmSpecification())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getResourceConfig() == null ^ this.getResourceConfig() == null) {
            return false;
        }
        if (other.getResourceConfig() != null && !other.getResourceConfig().equals(this.getResourceConfig())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        if (other.getStoppingCondition() != null && !other.getStoppingCondition().equals(this.getStoppingCondition())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getTrainingStartTime() == null ^ this.getTrainingStartTime() == null) {
            return false;
        }
        if (other.getTrainingStartTime() != null && !other.getTrainingStartTime().equals(this.getTrainingStartTime())) {
            return false;
        }
        if (other.getTrainingEndTime() == null ^ this.getTrainingEndTime() == null) {
            return false;
        }
        if (other.getTrainingEndTime() != null && !other.getTrainingEndTime().equals(this.getTrainingEndTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getSecondaryStatusTransitions() == null ^ this.getSecondaryStatusTransitions() == null) {
            return false;
        }
        if (other.getSecondaryStatusTransitions() != null && !other.getSecondaryStatusTransitions().equals(this.getSecondaryStatusTransitions())) {
            return false;
        }
        if (other.getFinalMetricDataList() == null ^ this.getFinalMetricDataList() == null) {
            return false;
        }
        if (other.getFinalMetricDataList() != null && !other.getFinalMetricDataList().equals(this.getFinalMetricDataList())) {
            return false;
        }
        if (other.getEnableNetworkIsolation() == null ^ this.getEnableNetworkIsolation() == null) {
            return false;
        }
        if (other.getEnableNetworkIsolation() != null && !other.getEnableNetworkIsolation().equals(this.getEnableNetworkIsolation())) {
            return false;
        }
        if (other.getEnableInterContainerTrafficEncryption() == null ^ this.getEnableInterContainerTrafficEncryption() == null) {
            return false;
        }
        if (other.getEnableInterContainerTrafficEncryption() != null && !other.getEnableInterContainerTrafficEncryption().equals(this.getEnableInterContainerTrafficEncryption())) {
            return false;
        }
        if (other.getEnableManagedSpotTraining() == null ^ this.getEnableManagedSpotTraining() == null) {
            return false;
        }
        if (other.getEnableManagedSpotTraining() != null && !other.getEnableManagedSpotTraining().equals(this.getEnableManagedSpotTraining())) {
            return false;
        }
        if (other.getCheckpointConfig() == null ^ this.getCheckpointConfig() == null) {
            return false;
        }
        if (other.getCheckpointConfig() != null && !other.getCheckpointConfig().equals(this.getCheckpointConfig())) {
            return false;
        }
        if (other.getTrainingTimeInSeconds() == null ^ this.getTrainingTimeInSeconds() == null) {
            return false;
        }
        if (other.getTrainingTimeInSeconds() != null && !other.getTrainingTimeInSeconds().equals(this.getTrainingTimeInSeconds())) {
            return false;
        }
        if (other.getBillableTimeInSeconds() == null ^ this.getBillableTimeInSeconds() == null) {
            return false;
        }
        if (other.getBillableTimeInSeconds() != null && !other.getBillableTimeInSeconds().equals(this.getBillableTimeInSeconds())) {
            return false;
        }
        if (other.getDebugHookConfig() == null ^ this.getDebugHookConfig() == null) {
            return false;
        }
        if (other.getDebugHookConfig() != null && !other.getDebugHookConfig().equals(this.getDebugHookConfig())) {
            return false;
        }
        if (other.getExperimentConfig() == null ^ this.getExperimentConfig() == null) {
            return false;
        }
        if (other.getExperimentConfig() != null && !other.getExperimentConfig().equals(this.getExperimentConfig())) {
            return false;
        }
        if (other.getDebugRuleConfigurations() == null ^ this.getDebugRuleConfigurations() == null) {
            return false;
        }
        if (other.getDebugRuleConfigurations() != null && !other.getDebugRuleConfigurations().equals(this.getDebugRuleConfigurations())) {
            return false;
        }
        if (other.getTensorBoardOutputConfig() == null ^ this.getTensorBoardOutputConfig() == null) {
            return false;
        }
        if (other.getTensorBoardOutputConfig() != null && !other.getTensorBoardOutputConfig().equals(this.getTensorBoardOutputConfig())) {
            return false;
        }
        if (other.getDebugRuleEvaluationStatuses() == null ^ this.getDebugRuleEvaluationStatuses() == null) {
            return false;
        }
        if (other.getDebugRuleEvaluationStatuses() != null && !other.getDebugRuleEvaluationStatuses().equals(this.getDebugRuleEvaluationStatuses())) {
            return false;
        }
        if (other.getProfilerConfig() == null ^ this.getProfilerConfig() == null) {
            return false;
        }
        if (other.getProfilerConfig() != null && !other.getProfilerConfig().equals(this.getProfilerConfig())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null) {
            return false;
        }
        if (other.getRetryStrategy() != null && !other.getRetryStrategy().equals(this.getRetryStrategy())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrainingJobName() == null ? 0 : this.getTrainingJobName().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingJobArn() == null ? 0 : this.getTrainingJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getTuningJobArn() == null ? 0 : this.getTuningJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getLabelingJobArn() == null ? 0 : this.getLabelingJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMLJobArn() == null ? 0 : this.getAutoMLJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getModelArtifacts() == null ? 0 : this.getModelArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingJobStatus() == null ? 0 : this.getTrainingJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryStatus() == null ? 0 : this.getSecondaryStatus().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getHyperParameters() == null ? 0 : this.getHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmSpecification() == null ? 0 : this.getAlgorithmSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getResourceConfig() == null ? 0 : this.getResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingStartTime() == null ? 0 : this.getTrainingStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingEndTime() == null ? 0 : this.getTrainingEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryStatusTransitions() == null ? 0 : this.getSecondaryStatusTransitions().hashCode());
        hashCode = 31 * hashCode + (this.getFinalMetricDataList() == null ? 0 : this.getFinalMetricDataList().hashCode());
        hashCode = 31 * hashCode + (this.getEnableNetworkIsolation() == null ? 0 : this.getEnableNetworkIsolation().hashCode());
        hashCode = 31 * hashCode + (this.getEnableInterContainerTrafficEncryption() == null ? 0 : this.getEnableInterContainerTrafficEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getEnableManagedSpotTraining() == null ? 0 : this.getEnableManagedSpotTraining().hashCode());
        hashCode = 31 * hashCode + (this.getCheckpointConfig() == null ? 0 : this.getCheckpointConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingTimeInSeconds() == null ? 0 : this.getTrainingTimeInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getBillableTimeInSeconds() == null ? 0 : this.getBillableTimeInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getDebugHookConfig() == null ? 0 : this.getDebugHookConfig().hashCode());
        hashCode = 31 * hashCode + (this.getExperimentConfig() == null ? 0 : this.getExperimentConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDebugRuleConfigurations() == null ? 0 : this.getDebugRuleConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTensorBoardOutputConfig() == null ? 0 : this.getTensorBoardOutputConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDebugRuleEvaluationStatuses() == null ? 0 : this.getDebugRuleEvaluationStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getProfilerConfig() == null ? 0 : this.getProfilerConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getRetryStrategy() == null ? 0 : this.getRetryStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TrainingJob clone() {
        try {
            return (TrainingJob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

