/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.TimeSeriesConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TimeSeriesConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String targetAttributeName;
    private String timestampAttributeName;
    private String itemIdentifierAttributeName;
    private List<String> groupingAttributeNames;

    public void setTargetAttributeName(String targetAttributeName) {
        this.targetAttributeName = targetAttributeName;
    }

    public String getTargetAttributeName() {
        return this.targetAttributeName;
    }

    public TimeSeriesConfig withTargetAttributeName(String targetAttributeName) {
        this.setTargetAttributeName(targetAttributeName);
        return this;
    }

    public void setTimestampAttributeName(String timestampAttributeName) {
        this.timestampAttributeName = timestampAttributeName;
    }

    public String getTimestampAttributeName() {
        return this.timestampAttributeName;
    }

    public TimeSeriesConfig withTimestampAttributeName(String timestampAttributeName) {
        this.setTimestampAttributeName(timestampAttributeName);
        return this;
    }

    public void setItemIdentifierAttributeName(String itemIdentifierAttributeName) {
        this.itemIdentifierAttributeName = itemIdentifierAttributeName;
    }

    public String getItemIdentifierAttributeName() {
        return this.itemIdentifierAttributeName;
    }

    public TimeSeriesConfig withItemIdentifierAttributeName(String itemIdentifierAttributeName) {
        this.setItemIdentifierAttributeName(itemIdentifierAttributeName);
        return this;
    }

    public List<String> getGroupingAttributeNames() {
        return this.groupingAttributeNames;
    }

    public void setGroupingAttributeNames(Collection<String> groupingAttributeNames) {
        if (groupingAttributeNames == null) {
            this.groupingAttributeNames = null;
            return;
        }
        this.groupingAttributeNames = new ArrayList<String>(groupingAttributeNames);
    }

    public TimeSeriesConfig withGroupingAttributeNames(String ... groupingAttributeNames) {
        if (this.groupingAttributeNames == null) {
            this.setGroupingAttributeNames(new ArrayList<String>(groupingAttributeNames.length));
        }
        for (String ele : groupingAttributeNames) {
            this.groupingAttributeNames.add(ele);
        }
        return this;
    }

    public TimeSeriesConfig withGroupingAttributeNames(Collection<String> groupingAttributeNames) {
        this.setGroupingAttributeNames(groupingAttributeNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetAttributeName() != null) {
            sb.append("TargetAttributeName: ").append(this.getTargetAttributeName()).append(",");
        }
        if (this.getTimestampAttributeName() != null) {
            sb.append("TimestampAttributeName: ").append(this.getTimestampAttributeName()).append(",");
        }
        if (this.getItemIdentifierAttributeName() != null) {
            sb.append("ItemIdentifierAttributeName: ").append(this.getItemIdentifierAttributeName()).append(",");
        }
        if (this.getGroupingAttributeNames() != null) {
            sb.append("GroupingAttributeNames: ").append(this.getGroupingAttributeNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesConfig)) {
            return false;
        }
        TimeSeriesConfig other = (TimeSeriesConfig)obj;
        if (other.getTargetAttributeName() == null ^ this.getTargetAttributeName() == null) {
            return false;
        }
        if (other.getTargetAttributeName() != null && !other.getTargetAttributeName().equals(this.getTargetAttributeName())) {
            return false;
        }
        if (other.getTimestampAttributeName() == null ^ this.getTimestampAttributeName() == null) {
            return false;
        }
        if (other.getTimestampAttributeName() != null && !other.getTimestampAttributeName().equals(this.getTimestampAttributeName())) {
            return false;
        }
        if (other.getItemIdentifierAttributeName() == null ^ this.getItemIdentifierAttributeName() == null) {
            return false;
        }
        if (other.getItemIdentifierAttributeName() != null && !other.getItemIdentifierAttributeName().equals(this.getItemIdentifierAttributeName())) {
            return false;
        }
        if (other.getGroupingAttributeNames() == null ^ this.getGroupingAttributeNames() == null) {
            return false;
        }
        return other.getGroupingAttributeNames() == null || other.getGroupingAttributeNames().equals(this.getGroupingAttributeNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetAttributeName() == null ? 0 : this.getTargetAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getTimestampAttributeName() == null ? 0 : this.getTimestampAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getItemIdentifierAttributeName() == null ? 0 : this.getItemIdentifierAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupingAttributeNames() == null ? 0 : this.getGroupingAttributeNames().hashCode());
        return hashCode;
    }

    public TimeSeriesConfig clone() {
        try {
            return (TimeSeriesConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeSeriesConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

