/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.PathComponent;

@SdkInternalApi
public class PathComponentMarshaller {
    private static final MarshallingInfo<Integer> SEQUENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sequence").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resource").build();
    private static final MarshallingInfo<String> DESTINATIONCIDRBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationCidrBlock").build();
    private static final PathComponentMarshaller instance = new PathComponentMarshaller();

    public static PathComponentMarshaller getInstance() {
        return instance;
    }

    public void marshall(PathComponent pathComponent, ProtocolMarshaller protocolMarshaller) {
        if (pathComponent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)pathComponent.getSequence(), SEQUENCE_BINDING);
            protocolMarshaller.marshall((Object)pathComponent.getResource(), RESOURCE_BINDING);
            protocolMarshaller.marshall((Object)pathComponent.getDestinationCidrBlock(), DESTINATIONCIDRBLOCK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

