/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.ConnectPeerBgpConfiguration;
import com.amazonaws.services.networkmanager.model.TunnelProtocol;
import com.amazonaws.services.networkmanager.model.transform.ConnectPeerConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectPeerConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String coreNetworkAddress;
    private String peerAddress;
    private List<String> insideCidrBlocks;
    private String protocol;
    private List<ConnectPeerBgpConfiguration> bgpConfigurations;

    public void setCoreNetworkAddress(String coreNetworkAddress) {
        this.coreNetworkAddress = coreNetworkAddress;
    }

    public String getCoreNetworkAddress() {
        return this.coreNetworkAddress;
    }

    public ConnectPeerConfiguration withCoreNetworkAddress(String coreNetworkAddress) {
        this.setCoreNetworkAddress(coreNetworkAddress);
        return this;
    }

    public void setPeerAddress(String peerAddress) {
        this.peerAddress = peerAddress;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public ConnectPeerConfiguration withPeerAddress(String peerAddress) {
        this.setPeerAddress(peerAddress);
        return this;
    }

    public List<String> getInsideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    public void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
        if (insideCidrBlocks == null) {
            this.insideCidrBlocks = null;
            return;
        }
        this.insideCidrBlocks = new ArrayList<String>(insideCidrBlocks);
    }

    public ConnectPeerConfiguration withInsideCidrBlocks(String ... insideCidrBlocks) {
        if (this.insideCidrBlocks == null) {
            this.setInsideCidrBlocks(new ArrayList<String>(insideCidrBlocks.length));
        }
        for (String ele : insideCidrBlocks) {
            this.insideCidrBlocks.add(ele);
        }
        return this;
    }

    public ConnectPeerConfiguration withInsideCidrBlocks(Collection<String> insideCidrBlocks) {
        this.setInsideCidrBlocks(insideCidrBlocks);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ConnectPeerConfiguration withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public ConnectPeerConfiguration withProtocol(TunnelProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public List<ConnectPeerBgpConfiguration> getBgpConfigurations() {
        return this.bgpConfigurations;
    }

    public void setBgpConfigurations(Collection<ConnectPeerBgpConfiguration> bgpConfigurations) {
        if (bgpConfigurations == null) {
            this.bgpConfigurations = null;
            return;
        }
        this.bgpConfigurations = new ArrayList<ConnectPeerBgpConfiguration>(bgpConfigurations);
    }

    public ConnectPeerConfiguration withBgpConfigurations(ConnectPeerBgpConfiguration ... bgpConfigurations) {
        if (this.bgpConfigurations == null) {
            this.setBgpConfigurations(new ArrayList<ConnectPeerBgpConfiguration>(bgpConfigurations.length));
        }
        for (ConnectPeerBgpConfiguration ele : bgpConfigurations) {
            this.bgpConfigurations.add(ele);
        }
        return this;
    }

    public ConnectPeerConfiguration withBgpConfigurations(Collection<ConnectPeerBgpConfiguration> bgpConfigurations) {
        this.setBgpConfigurations(bgpConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCoreNetworkAddress() != null) {
            sb.append("CoreNetworkAddress: ").append(this.getCoreNetworkAddress()).append(",");
        }
        if (this.getPeerAddress() != null) {
            sb.append("PeerAddress: ").append(this.getPeerAddress()).append(",");
        }
        if (this.getInsideCidrBlocks() != null) {
            sb.append("InsideCidrBlocks: ").append(this.getInsideCidrBlocks()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getBgpConfigurations() != null) {
            sb.append("BgpConfigurations: ").append(this.getBgpConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectPeerConfiguration)) {
            return false;
        }
        ConnectPeerConfiguration other = (ConnectPeerConfiguration)obj;
        if (other.getCoreNetworkAddress() == null ^ this.getCoreNetworkAddress() == null) {
            return false;
        }
        if (other.getCoreNetworkAddress() != null && !other.getCoreNetworkAddress().equals(this.getCoreNetworkAddress())) {
            return false;
        }
        if (other.getPeerAddress() == null ^ this.getPeerAddress() == null) {
            return false;
        }
        if (other.getPeerAddress() != null && !other.getPeerAddress().equals(this.getPeerAddress())) {
            return false;
        }
        if (other.getInsideCidrBlocks() == null ^ this.getInsideCidrBlocks() == null) {
            return false;
        }
        if (other.getInsideCidrBlocks() != null && !other.getInsideCidrBlocks().equals(this.getInsideCidrBlocks())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getBgpConfigurations() == null ^ this.getBgpConfigurations() == null) {
            return false;
        }
        return other.getBgpConfigurations() == null || other.getBgpConfigurations().equals(this.getBgpConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCoreNetworkAddress() == null ? 0 : this.getCoreNetworkAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPeerAddress() == null ? 0 : this.getPeerAddress().hashCode());
        hashCode = 31 * hashCode + (this.getInsideCidrBlocks() == null ? 0 : this.getInsideCidrBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getBgpConfigurations() == null ? 0 : this.getBgpConfigurations().hashCode());
        return hashCode;
    }

    public ConnectPeerConfiguration clone() {
        try {
            return (ConnectPeerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectPeerConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

