/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mailmanager.model.S3Action;

@SdkInternalApi
public class S3ActionMarshaller {
    private static final MarshallingInfo<String> ACTIONFAILUREPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionFailurePolicy").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").build();
    private static final MarshallingInfo<String> S3PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Prefix").build();
    private static final MarshallingInfo<String> S3SSEKMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3SseKmsKeyId").build();
    private static final S3ActionMarshaller instance = new S3ActionMarshaller();

    public static S3ActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Action s3Action, ProtocolMarshaller protocolMarshaller) {
        if (s3Action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Action.getActionFailurePolicy(), ACTIONFAILUREPOLICY_BINDING);
            protocolMarshaller.marshall((Object)s3Action.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)s3Action.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3Action.getS3Prefix(), S3PREFIX_BINDING);
            protocolMarshaller.marshall((Object)s3Action.getS3SseKmsKeyId(), S3SSEKMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

