/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kafka.AWSKafkaAsync;
import com.amazonaws.services.kafka.AWSKafkaAsyncClientBuilder;
import com.amazonaws.services.kafka.AWSKafkaClient;
import com.amazonaws.services.kafka.model.BatchAssociateScramSecretRequest;
import com.amazonaws.services.kafka.model.BatchAssociateScramSecretResult;
import com.amazonaws.services.kafka.model.BatchDisassociateScramSecretRequest;
import com.amazonaws.services.kafka.model.BatchDisassociateScramSecretResult;
import com.amazonaws.services.kafka.model.CreateClusterRequest;
import com.amazonaws.services.kafka.model.CreateClusterResult;
import com.amazonaws.services.kafka.model.CreateClusterV2Request;
import com.amazonaws.services.kafka.model.CreateClusterV2Result;
import com.amazonaws.services.kafka.model.CreateConfigurationRequest;
import com.amazonaws.services.kafka.model.CreateConfigurationResult;
import com.amazonaws.services.kafka.model.CreateReplicatorRequest;
import com.amazonaws.services.kafka.model.CreateReplicatorResult;
import com.amazonaws.services.kafka.model.CreateVpcConnectionRequest;
import com.amazonaws.services.kafka.model.CreateVpcConnectionResult;
import com.amazonaws.services.kafka.model.DeleteClusterPolicyRequest;
import com.amazonaws.services.kafka.model.DeleteClusterPolicyResult;
import com.amazonaws.services.kafka.model.DeleteClusterRequest;
import com.amazonaws.services.kafka.model.DeleteClusterResult;
import com.amazonaws.services.kafka.model.DeleteConfigurationRequest;
import com.amazonaws.services.kafka.model.DeleteConfigurationResult;
import com.amazonaws.services.kafka.model.DeleteReplicatorRequest;
import com.amazonaws.services.kafka.model.DeleteReplicatorResult;
import com.amazonaws.services.kafka.model.DeleteVpcConnectionRequest;
import com.amazonaws.services.kafka.model.DeleteVpcConnectionResult;
import com.amazonaws.services.kafka.model.DescribeClusterOperationRequest;
import com.amazonaws.services.kafka.model.DescribeClusterOperationResult;
import com.amazonaws.services.kafka.model.DescribeClusterOperationV2Request;
import com.amazonaws.services.kafka.model.DescribeClusterOperationV2Result;
import com.amazonaws.services.kafka.model.DescribeClusterRequest;
import com.amazonaws.services.kafka.model.DescribeClusterResult;
import com.amazonaws.services.kafka.model.DescribeClusterV2Request;
import com.amazonaws.services.kafka.model.DescribeClusterV2Result;
import com.amazonaws.services.kafka.model.DescribeConfigurationRequest;
import com.amazonaws.services.kafka.model.DescribeConfigurationResult;
import com.amazonaws.services.kafka.model.DescribeConfigurationRevisionRequest;
import com.amazonaws.services.kafka.model.DescribeConfigurationRevisionResult;
import com.amazonaws.services.kafka.model.DescribeReplicatorRequest;
import com.amazonaws.services.kafka.model.DescribeReplicatorResult;
import com.amazonaws.services.kafka.model.DescribeVpcConnectionRequest;
import com.amazonaws.services.kafka.model.DescribeVpcConnectionResult;
import com.amazonaws.services.kafka.model.GetBootstrapBrokersRequest;
import com.amazonaws.services.kafka.model.GetBootstrapBrokersResult;
import com.amazonaws.services.kafka.model.GetClusterPolicyRequest;
import com.amazonaws.services.kafka.model.GetClusterPolicyResult;
import com.amazonaws.services.kafka.model.GetCompatibleKafkaVersionsRequest;
import com.amazonaws.services.kafka.model.GetCompatibleKafkaVersionsResult;
import com.amazonaws.services.kafka.model.ListClientVpcConnectionsRequest;
import com.amazonaws.services.kafka.model.ListClientVpcConnectionsResult;
import com.amazonaws.services.kafka.model.ListClusterOperationsRequest;
import com.amazonaws.services.kafka.model.ListClusterOperationsResult;
import com.amazonaws.services.kafka.model.ListClusterOperationsV2Request;
import com.amazonaws.services.kafka.model.ListClusterOperationsV2Result;
import com.amazonaws.services.kafka.model.ListClustersRequest;
import com.amazonaws.services.kafka.model.ListClustersResult;
import com.amazonaws.services.kafka.model.ListClustersV2Request;
import com.amazonaws.services.kafka.model.ListClustersV2Result;
import com.amazonaws.services.kafka.model.ListConfigurationRevisionsRequest;
import com.amazonaws.services.kafka.model.ListConfigurationRevisionsResult;
import com.amazonaws.services.kafka.model.ListConfigurationsRequest;
import com.amazonaws.services.kafka.model.ListConfigurationsResult;
import com.amazonaws.services.kafka.model.ListKafkaVersionsRequest;
import com.amazonaws.services.kafka.model.ListKafkaVersionsResult;
import com.amazonaws.services.kafka.model.ListNodesRequest;
import com.amazonaws.services.kafka.model.ListNodesResult;
import com.amazonaws.services.kafka.model.ListReplicatorsRequest;
import com.amazonaws.services.kafka.model.ListReplicatorsResult;
import com.amazonaws.services.kafka.model.ListScramSecretsRequest;
import com.amazonaws.services.kafka.model.ListScramSecretsResult;
import com.amazonaws.services.kafka.model.ListTagsForResourceRequest;
import com.amazonaws.services.kafka.model.ListTagsForResourceResult;
import com.amazonaws.services.kafka.model.ListVpcConnectionsRequest;
import com.amazonaws.services.kafka.model.ListVpcConnectionsResult;
import com.amazonaws.services.kafka.model.PutClusterPolicyRequest;
import com.amazonaws.services.kafka.model.PutClusterPolicyResult;
import com.amazonaws.services.kafka.model.RebootBrokerRequest;
import com.amazonaws.services.kafka.model.RebootBrokerResult;
import com.amazonaws.services.kafka.model.RejectClientVpcConnectionRequest;
import com.amazonaws.services.kafka.model.RejectClientVpcConnectionResult;
import com.amazonaws.services.kafka.model.TagResourceRequest;
import com.amazonaws.services.kafka.model.TagResourceResult;
import com.amazonaws.services.kafka.model.UntagResourceRequest;
import com.amazonaws.services.kafka.model.UntagResourceResult;
import com.amazonaws.services.kafka.model.UpdateBrokerCountRequest;
import com.amazonaws.services.kafka.model.UpdateBrokerCountResult;
import com.amazonaws.services.kafka.model.UpdateBrokerStorageRequest;
import com.amazonaws.services.kafka.model.UpdateBrokerStorageResult;
import com.amazonaws.services.kafka.model.UpdateBrokerTypeRequest;
import com.amazonaws.services.kafka.model.UpdateBrokerTypeResult;
import com.amazonaws.services.kafka.model.UpdateClusterConfigurationRequest;
import com.amazonaws.services.kafka.model.UpdateClusterConfigurationResult;
import com.amazonaws.services.kafka.model.UpdateClusterKafkaVersionRequest;
import com.amazonaws.services.kafka.model.UpdateClusterKafkaVersionResult;
import com.amazonaws.services.kafka.model.UpdateConfigurationRequest;
import com.amazonaws.services.kafka.model.UpdateConfigurationResult;
import com.amazonaws.services.kafka.model.UpdateConnectivityRequest;
import com.amazonaws.services.kafka.model.UpdateConnectivityResult;
import com.amazonaws.services.kafka.model.UpdateMonitoringRequest;
import com.amazonaws.services.kafka.model.UpdateMonitoringResult;
import com.amazonaws.services.kafka.model.UpdateReplicationInfoRequest;
import com.amazonaws.services.kafka.model.UpdateReplicationInfoResult;
import com.amazonaws.services.kafka.model.UpdateSecurityRequest;
import com.amazonaws.services.kafka.model.UpdateSecurityResult;
import com.amazonaws.services.kafka.model.UpdateStorageRequest;
import com.amazonaws.services.kafka.model.UpdateStorageResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSKafkaAsyncClient
extends AWSKafkaClient
implements AWSKafkaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSKafkaAsyncClientBuilder asyncBuilder() {
        return AWSKafkaAsyncClientBuilder.standard();
    }

    AWSKafkaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSKafkaAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchAssociateScramSecretResult> batchAssociateScramSecretAsync(BatchAssociateScramSecretRequest request) {
        return this.batchAssociateScramSecretAsync(request, null);
    }

    @Override
    public Future<BatchAssociateScramSecretResult> batchAssociateScramSecretAsync(BatchAssociateScramSecretRequest request, final AsyncHandler<BatchAssociateScramSecretRequest, BatchAssociateScramSecretResult> asyncHandler) {
        final BatchAssociateScramSecretRequest finalRequest = (BatchAssociateScramSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchAssociateScramSecretResult>(){

            @Override
            public BatchAssociateScramSecretResult call() throws Exception {
                BatchAssociateScramSecretResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeBatchAssociateScramSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDisassociateScramSecretResult> batchDisassociateScramSecretAsync(BatchDisassociateScramSecretRequest request) {
        return this.batchDisassociateScramSecretAsync(request, null);
    }

    @Override
    public Future<BatchDisassociateScramSecretResult> batchDisassociateScramSecretAsync(BatchDisassociateScramSecretRequest request, final AsyncHandler<BatchDisassociateScramSecretRequest, BatchDisassociateScramSecretResult> asyncHandler) {
        final BatchDisassociateScramSecretRequest finalRequest = (BatchDisassociateScramSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDisassociateScramSecretResult>(){

            @Override
            public BatchDisassociateScramSecretResult call() throws Exception {
                BatchDisassociateScramSecretResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeBatchDisassociateScramSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterV2Result> createClusterV2Async(CreateClusterV2Request request) {
        return this.createClusterV2Async(request, null);
    }

    @Override
    public Future<CreateClusterV2Result> createClusterV2Async(CreateClusterV2Request request, final AsyncHandler<CreateClusterV2Request, CreateClusterV2Result> asyncHandler) {
        final CreateClusterV2Request finalRequest = (CreateClusterV2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterV2Result>(){

            @Override
            public CreateClusterV2Result call() throws Exception {
                CreateClusterV2Result result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeCreateClusterV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConfigurationResult> createConfigurationAsync(CreateConfigurationRequest request) {
        return this.createConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateConfigurationResult> createConfigurationAsync(CreateConfigurationRequest request, final AsyncHandler<CreateConfigurationRequest, CreateConfigurationResult> asyncHandler) {
        final CreateConfigurationRequest finalRequest = (CreateConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConfigurationResult>(){

            @Override
            public CreateConfigurationResult call() throws Exception {
                CreateConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeCreateConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateReplicatorResult> createReplicatorAsync(CreateReplicatorRequest request) {
        return this.createReplicatorAsync(request, null);
    }

    @Override
    public Future<CreateReplicatorResult> createReplicatorAsync(CreateReplicatorRequest request, final AsyncHandler<CreateReplicatorRequest, CreateReplicatorResult> asyncHandler) {
        final CreateReplicatorRequest finalRequest = (CreateReplicatorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateReplicatorResult>(){

            @Override
            public CreateReplicatorResult call() throws Exception {
                CreateReplicatorResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeCreateReplicator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVpcConnectionResult> createVpcConnectionAsync(CreateVpcConnectionRequest request) {
        return this.createVpcConnectionAsync(request, null);
    }

    @Override
    public Future<CreateVpcConnectionResult> createVpcConnectionAsync(CreateVpcConnectionRequest request, final AsyncHandler<CreateVpcConnectionRequest, CreateVpcConnectionResult> asyncHandler) {
        final CreateVpcConnectionRequest finalRequest = (CreateVpcConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVpcConnectionResult>(){

            @Override
            public CreateVpcConnectionResult call() throws Exception {
                CreateVpcConnectionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeCreateVpcConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterPolicyResult> deleteClusterPolicyAsync(DeleteClusterPolicyRequest request) {
        return this.deleteClusterPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteClusterPolicyResult> deleteClusterPolicyAsync(DeleteClusterPolicyRequest request, final AsyncHandler<DeleteClusterPolicyRequest, DeleteClusterPolicyResult> asyncHandler) {
        final DeleteClusterPolicyRequest finalRequest = (DeleteClusterPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterPolicyResult>(){

            @Override
            public DeleteClusterPolicyResult call() throws Exception {
                DeleteClusterPolicyResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDeleteClusterPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConfigurationResult> deleteConfigurationAsync(DeleteConfigurationRequest request) {
        return this.deleteConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteConfigurationResult> deleteConfigurationAsync(DeleteConfigurationRequest request, final AsyncHandler<DeleteConfigurationRequest, DeleteConfigurationResult> asyncHandler) {
        final DeleteConfigurationRequest finalRequest = (DeleteConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConfigurationResult>(){

            @Override
            public DeleteConfigurationResult call() throws Exception {
                DeleteConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDeleteConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteReplicatorResult> deleteReplicatorAsync(DeleteReplicatorRequest request) {
        return this.deleteReplicatorAsync(request, null);
    }

    @Override
    public Future<DeleteReplicatorResult> deleteReplicatorAsync(DeleteReplicatorRequest request, final AsyncHandler<DeleteReplicatorRequest, DeleteReplicatorResult> asyncHandler) {
        final DeleteReplicatorRequest finalRequest = (DeleteReplicatorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteReplicatorResult>(){

            @Override
            public DeleteReplicatorResult call() throws Exception {
                DeleteReplicatorResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDeleteReplicator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVpcConnectionResult> deleteVpcConnectionAsync(DeleteVpcConnectionRequest request) {
        return this.deleteVpcConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteVpcConnectionResult> deleteVpcConnectionAsync(DeleteVpcConnectionRequest request, final AsyncHandler<DeleteVpcConnectionRequest, DeleteVpcConnectionResult> asyncHandler) {
        final DeleteVpcConnectionRequest finalRequest = (DeleteVpcConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVpcConnectionResult>(){

            @Override
            public DeleteVpcConnectionResult call() throws Exception {
                DeleteVpcConnectionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDeleteVpcConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request) {
        return this.describeClusterAsync(request, null);
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request, final AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) {
        final DescribeClusterRequest finalRequest = (DescribeClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                DescribeClusterResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterOperationResult> describeClusterOperationAsync(DescribeClusterOperationRequest request) {
        return this.describeClusterOperationAsync(request, null);
    }

    @Override
    public Future<DescribeClusterOperationResult> describeClusterOperationAsync(DescribeClusterOperationRequest request, final AsyncHandler<DescribeClusterOperationRequest, DescribeClusterOperationResult> asyncHandler) {
        final DescribeClusterOperationRequest finalRequest = (DescribeClusterOperationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterOperationResult>(){

            @Override
            public DescribeClusterOperationResult call() throws Exception {
                DescribeClusterOperationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeClusterOperation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterOperationV2Result> describeClusterOperationV2Async(DescribeClusterOperationV2Request request) {
        return this.describeClusterOperationV2Async(request, null);
    }

    @Override
    public Future<DescribeClusterOperationV2Result> describeClusterOperationV2Async(DescribeClusterOperationV2Request request, final AsyncHandler<DescribeClusterOperationV2Request, DescribeClusterOperationV2Result> asyncHandler) {
        final DescribeClusterOperationV2Request finalRequest = (DescribeClusterOperationV2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterOperationV2Result>(){

            @Override
            public DescribeClusterOperationV2Result call() throws Exception {
                DescribeClusterOperationV2Result result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeClusterOperationV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterV2Result> describeClusterV2Async(DescribeClusterV2Request request) {
        return this.describeClusterV2Async(request, null);
    }

    @Override
    public Future<DescribeClusterV2Result> describeClusterV2Async(DescribeClusterV2Request request, final AsyncHandler<DescribeClusterV2Request, DescribeClusterV2Result> asyncHandler) {
        final DescribeClusterV2Request finalRequest = (DescribeClusterV2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterV2Result>(){

            @Override
            public DescribeClusterV2Result call() throws Exception {
                DescribeClusterV2Result result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeClusterV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationResult> describeConfigurationAsync(DescribeConfigurationRequest request) {
        return this.describeConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationResult> describeConfigurationAsync(DescribeConfigurationRequest request, final AsyncHandler<DescribeConfigurationRequest, DescribeConfigurationResult> asyncHandler) {
        final DescribeConfigurationRequest finalRequest = (DescribeConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationResult>(){

            @Override
            public DescribeConfigurationResult call() throws Exception {
                DescribeConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRevisionResult> describeConfigurationRevisionAsync(DescribeConfigurationRevisionRequest request) {
        return this.describeConfigurationRevisionAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationRevisionResult> describeConfigurationRevisionAsync(DescribeConfigurationRevisionRequest request, final AsyncHandler<DescribeConfigurationRevisionRequest, DescribeConfigurationRevisionResult> asyncHandler) {
        final DescribeConfigurationRevisionRequest finalRequest = (DescribeConfigurationRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationRevisionResult>(){

            @Override
            public DescribeConfigurationRevisionResult call() throws Exception {
                DescribeConfigurationRevisionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeConfigurationRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReplicatorResult> describeReplicatorAsync(DescribeReplicatorRequest request) {
        return this.describeReplicatorAsync(request, null);
    }

    @Override
    public Future<DescribeReplicatorResult> describeReplicatorAsync(DescribeReplicatorRequest request, final AsyncHandler<DescribeReplicatorRequest, DescribeReplicatorResult> asyncHandler) {
        final DescribeReplicatorRequest finalRequest = (DescribeReplicatorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReplicatorResult>(){

            @Override
            public DescribeReplicatorResult call() throws Exception {
                DescribeReplicatorResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeReplicator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVpcConnectionResult> describeVpcConnectionAsync(DescribeVpcConnectionRequest request) {
        return this.describeVpcConnectionAsync(request, null);
    }

    @Override
    public Future<DescribeVpcConnectionResult> describeVpcConnectionAsync(DescribeVpcConnectionRequest request, final AsyncHandler<DescribeVpcConnectionRequest, DescribeVpcConnectionResult> asyncHandler) {
        final DescribeVpcConnectionRequest finalRequest = (DescribeVpcConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVpcConnectionResult>(){

            @Override
            public DescribeVpcConnectionResult call() throws Exception {
                DescribeVpcConnectionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeDescribeVpcConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBootstrapBrokersResult> getBootstrapBrokersAsync(GetBootstrapBrokersRequest request) {
        return this.getBootstrapBrokersAsync(request, null);
    }

    @Override
    public Future<GetBootstrapBrokersResult> getBootstrapBrokersAsync(GetBootstrapBrokersRequest request, final AsyncHandler<GetBootstrapBrokersRequest, GetBootstrapBrokersResult> asyncHandler) {
        final GetBootstrapBrokersRequest finalRequest = (GetBootstrapBrokersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBootstrapBrokersResult>(){

            @Override
            public GetBootstrapBrokersResult call() throws Exception {
                GetBootstrapBrokersResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeGetBootstrapBrokers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetClusterPolicyResult> getClusterPolicyAsync(GetClusterPolicyRequest request) {
        return this.getClusterPolicyAsync(request, null);
    }

    @Override
    public Future<GetClusterPolicyResult> getClusterPolicyAsync(GetClusterPolicyRequest request, final AsyncHandler<GetClusterPolicyRequest, GetClusterPolicyResult> asyncHandler) {
        final GetClusterPolicyRequest finalRequest = (GetClusterPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetClusterPolicyResult>(){

            @Override
            public GetClusterPolicyResult call() throws Exception {
                GetClusterPolicyResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeGetClusterPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCompatibleKafkaVersionsResult> getCompatibleKafkaVersionsAsync(GetCompatibleKafkaVersionsRequest request) {
        return this.getCompatibleKafkaVersionsAsync(request, null);
    }

    @Override
    public Future<GetCompatibleKafkaVersionsResult> getCompatibleKafkaVersionsAsync(GetCompatibleKafkaVersionsRequest request, final AsyncHandler<GetCompatibleKafkaVersionsRequest, GetCompatibleKafkaVersionsResult> asyncHandler) {
        final GetCompatibleKafkaVersionsRequest finalRequest = (GetCompatibleKafkaVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCompatibleKafkaVersionsResult>(){

            @Override
            public GetCompatibleKafkaVersionsResult call() throws Exception {
                GetCompatibleKafkaVersionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeGetCompatibleKafkaVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClientVpcConnectionsResult> listClientVpcConnectionsAsync(ListClientVpcConnectionsRequest request) {
        return this.listClientVpcConnectionsAsync(request, null);
    }

    @Override
    public Future<ListClientVpcConnectionsResult> listClientVpcConnectionsAsync(ListClientVpcConnectionsRequest request, final AsyncHandler<ListClientVpcConnectionsRequest, ListClientVpcConnectionsResult> asyncHandler) {
        final ListClientVpcConnectionsRequest finalRequest = (ListClientVpcConnectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClientVpcConnectionsResult>(){

            @Override
            public ListClientVpcConnectionsResult call() throws Exception {
                ListClientVpcConnectionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListClientVpcConnections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClusterOperationsResult> listClusterOperationsAsync(ListClusterOperationsRequest request) {
        return this.listClusterOperationsAsync(request, null);
    }

    @Override
    public Future<ListClusterOperationsResult> listClusterOperationsAsync(ListClusterOperationsRequest request, final AsyncHandler<ListClusterOperationsRequest, ListClusterOperationsResult> asyncHandler) {
        final ListClusterOperationsRequest finalRequest = (ListClusterOperationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClusterOperationsResult>(){

            @Override
            public ListClusterOperationsResult call() throws Exception {
                ListClusterOperationsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListClusterOperations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClusterOperationsV2Result> listClusterOperationsV2Async(ListClusterOperationsV2Request request) {
        return this.listClusterOperationsV2Async(request, null);
    }

    @Override
    public Future<ListClusterOperationsV2Result> listClusterOperationsV2Async(ListClusterOperationsV2Request request, final AsyncHandler<ListClusterOperationsV2Request, ListClusterOperationsV2Result> asyncHandler) {
        final ListClusterOperationsV2Request finalRequest = (ListClusterOperationsV2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClusterOperationsV2Result>(){

            @Override
            public ListClusterOperationsV2Result call() throws Exception {
                ListClusterOperationsV2Result result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListClusterOperationsV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        final ListClustersRequest finalRequest = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersV2Result> listClustersV2Async(ListClustersV2Request request) {
        return this.listClustersV2Async(request, null);
    }

    @Override
    public Future<ListClustersV2Result> listClustersV2Async(ListClustersV2Request request, final AsyncHandler<ListClustersV2Request, ListClustersV2Result> asyncHandler) {
        final ListClustersV2Request finalRequest = (ListClustersV2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersV2Result>(){

            @Override
            public ListClustersV2Result call() throws Exception {
                ListClustersV2Result result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListClustersV2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationRevisionsResult> listConfigurationRevisionsAsync(ListConfigurationRevisionsRequest request) {
        return this.listConfigurationRevisionsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationRevisionsResult> listConfigurationRevisionsAsync(ListConfigurationRevisionsRequest request, final AsyncHandler<ListConfigurationRevisionsRequest, ListConfigurationRevisionsResult> asyncHandler) {
        final ListConfigurationRevisionsRequest finalRequest = (ListConfigurationRevisionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigurationRevisionsResult>(){

            @Override
            public ListConfigurationRevisionsResult call() throws Exception {
                ListConfigurationRevisionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListConfigurationRevisions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request) {
        return this.listConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request, final AsyncHandler<ListConfigurationsRequest, ListConfigurationsResult> asyncHandler) {
        final ListConfigurationsRequest finalRequest = (ListConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigurationsResult>(){

            @Override
            public ListConfigurationsResult call() throws Exception {
                ListConfigurationsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListKafkaVersionsResult> listKafkaVersionsAsync(ListKafkaVersionsRequest request) {
        return this.listKafkaVersionsAsync(request, null);
    }

    @Override
    public Future<ListKafkaVersionsResult> listKafkaVersionsAsync(ListKafkaVersionsRequest request, final AsyncHandler<ListKafkaVersionsRequest, ListKafkaVersionsResult> asyncHandler) {
        final ListKafkaVersionsRequest finalRequest = (ListKafkaVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListKafkaVersionsResult>(){

            @Override
            public ListKafkaVersionsResult call() throws Exception {
                ListKafkaVersionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListKafkaVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request) {
        return this.listNodesAsync(request, null);
    }

    @Override
    public Future<ListNodesResult> listNodesAsync(ListNodesRequest request, final AsyncHandler<ListNodesRequest, ListNodesResult> asyncHandler) {
        final ListNodesRequest finalRequest = (ListNodesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNodesResult>(){

            @Override
            public ListNodesResult call() throws Exception {
                ListNodesResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReplicatorsResult> listReplicatorsAsync(ListReplicatorsRequest request) {
        return this.listReplicatorsAsync(request, null);
    }

    @Override
    public Future<ListReplicatorsResult> listReplicatorsAsync(ListReplicatorsRequest request, final AsyncHandler<ListReplicatorsRequest, ListReplicatorsResult> asyncHandler) {
        final ListReplicatorsRequest finalRequest = (ListReplicatorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReplicatorsResult>(){

            @Override
            public ListReplicatorsResult call() throws Exception {
                ListReplicatorsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListReplicators(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListScramSecretsResult> listScramSecretsAsync(ListScramSecretsRequest request) {
        return this.listScramSecretsAsync(request, null);
    }

    @Override
    public Future<ListScramSecretsResult> listScramSecretsAsync(ListScramSecretsRequest request, final AsyncHandler<ListScramSecretsRequest, ListScramSecretsResult> asyncHandler) {
        final ListScramSecretsRequest finalRequest = (ListScramSecretsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListScramSecretsResult>(){

            @Override
            public ListScramSecretsResult call() throws Exception {
                ListScramSecretsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListScramSecrets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVpcConnectionsResult> listVpcConnectionsAsync(ListVpcConnectionsRequest request) {
        return this.listVpcConnectionsAsync(request, null);
    }

    @Override
    public Future<ListVpcConnectionsResult> listVpcConnectionsAsync(ListVpcConnectionsRequest request, final AsyncHandler<ListVpcConnectionsRequest, ListVpcConnectionsResult> asyncHandler) {
        final ListVpcConnectionsRequest finalRequest = (ListVpcConnectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVpcConnectionsResult>(){

            @Override
            public ListVpcConnectionsResult call() throws Exception {
                ListVpcConnectionsResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeListVpcConnections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutClusterPolicyResult> putClusterPolicyAsync(PutClusterPolicyRequest request) {
        return this.putClusterPolicyAsync(request, null);
    }

    @Override
    public Future<PutClusterPolicyResult> putClusterPolicyAsync(PutClusterPolicyRequest request, final AsyncHandler<PutClusterPolicyRequest, PutClusterPolicyResult> asyncHandler) {
        final PutClusterPolicyRequest finalRequest = (PutClusterPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutClusterPolicyResult>(){

            @Override
            public PutClusterPolicyResult call() throws Exception {
                PutClusterPolicyResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executePutClusterPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebootBrokerResult> rebootBrokerAsync(RebootBrokerRequest request) {
        return this.rebootBrokerAsync(request, null);
    }

    @Override
    public Future<RebootBrokerResult> rebootBrokerAsync(RebootBrokerRequest request, final AsyncHandler<RebootBrokerRequest, RebootBrokerResult> asyncHandler) {
        final RebootBrokerRequest finalRequest = (RebootBrokerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebootBrokerResult>(){

            @Override
            public RebootBrokerResult call() throws Exception {
                RebootBrokerResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeRebootBroker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectClientVpcConnectionResult> rejectClientVpcConnectionAsync(RejectClientVpcConnectionRequest request) {
        return this.rejectClientVpcConnectionAsync(request, null);
    }

    @Override
    public Future<RejectClientVpcConnectionResult> rejectClientVpcConnectionAsync(RejectClientVpcConnectionRequest request, final AsyncHandler<RejectClientVpcConnectionRequest, RejectClientVpcConnectionResult> asyncHandler) {
        final RejectClientVpcConnectionRequest finalRequest = (RejectClientVpcConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectClientVpcConnectionResult>(){

            @Override
            public RejectClientVpcConnectionResult call() throws Exception {
                RejectClientVpcConnectionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeRejectClientVpcConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBrokerCountResult> updateBrokerCountAsync(UpdateBrokerCountRequest request) {
        return this.updateBrokerCountAsync(request, null);
    }

    @Override
    public Future<UpdateBrokerCountResult> updateBrokerCountAsync(UpdateBrokerCountRequest request, final AsyncHandler<UpdateBrokerCountRequest, UpdateBrokerCountResult> asyncHandler) {
        final UpdateBrokerCountRequest finalRequest = (UpdateBrokerCountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBrokerCountResult>(){

            @Override
            public UpdateBrokerCountResult call() throws Exception {
                UpdateBrokerCountResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateBrokerCount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBrokerStorageResult> updateBrokerStorageAsync(UpdateBrokerStorageRequest request) {
        return this.updateBrokerStorageAsync(request, null);
    }

    @Override
    public Future<UpdateBrokerStorageResult> updateBrokerStorageAsync(UpdateBrokerStorageRequest request, final AsyncHandler<UpdateBrokerStorageRequest, UpdateBrokerStorageResult> asyncHandler) {
        final UpdateBrokerStorageRequest finalRequest = (UpdateBrokerStorageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBrokerStorageResult>(){

            @Override
            public UpdateBrokerStorageResult call() throws Exception {
                UpdateBrokerStorageResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateBrokerStorage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBrokerTypeResult> updateBrokerTypeAsync(UpdateBrokerTypeRequest request) {
        return this.updateBrokerTypeAsync(request, null);
    }

    @Override
    public Future<UpdateBrokerTypeResult> updateBrokerTypeAsync(UpdateBrokerTypeRequest request, final AsyncHandler<UpdateBrokerTypeRequest, UpdateBrokerTypeResult> asyncHandler) {
        final UpdateBrokerTypeRequest finalRequest = (UpdateBrokerTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBrokerTypeResult>(){

            @Override
            public UpdateBrokerTypeResult call() throws Exception {
                UpdateBrokerTypeResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateBrokerType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterConfigurationResult> updateClusterConfigurationAsync(UpdateClusterConfigurationRequest request) {
        return this.updateClusterConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateClusterConfigurationResult> updateClusterConfigurationAsync(UpdateClusterConfigurationRequest request, final AsyncHandler<UpdateClusterConfigurationRequest, UpdateClusterConfigurationResult> asyncHandler) {
        final UpdateClusterConfigurationRequest finalRequest = (UpdateClusterConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterConfigurationResult>(){

            @Override
            public UpdateClusterConfigurationResult call() throws Exception {
                UpdateClusterConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateClusterConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterKafkaVersionResult> updateClusterKafkaVersionAsync(UpdateClusterKafkaVersionRequest request) {
        return this.updateClusterKafkaVersionAsync(request, null);
    }

    @Override
    public Future<UpdateClusterKafkaVersionResult> updateClusterKafkaVersionAsync(UpdateClusterKafkaVersionRequest request, final AsyncHandler<UpdateClusterKafkaVersionRequest, UpdateClusterKafkaVersionResult> asyncHandler) {
        final UpdateClusterKafkaVersionRequest finalRequest = (UpdateClusterKafkaVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterKafkaVersionResult>(){

            @Override
            public UpdateClusterKafkaVersionResult call() throws Exception {
                UpdateClusterKafkaVersionResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateClusterKafkaVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request) {
        return this.updateConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request, final AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResult> asyncHandler) {
        final UpdateConfigurationRequest finalRequest = (UpdateConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConfigurationResult>(){

            @Override
            public UpdateConfigurationResult call() throws Exception {
                UpdateConfigurationResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConnectivityResult> updateConnectivityAsync(UpdateConnectivityRequest request) {
        return this.updateConnectivityAsync(request, null);
    }

    @Override
    public Future<UpdateConnectivityResult> updateConnectivityAsync(UpdateConnectivityRequest request, final AsyncHandler<UpdateConnectivityRequest, UpdateConnectivityResult> asyncHandler) {
        final UpdateConnectivityRequest finalRequest = (UpdateConnectivityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConnectivityResult>(){

            @Override
            public UpdateConnectivityResult call() throws Exception {
                UpdateConnectivityResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateConnectivity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMonitoringResult> updateMonitoringAsync(UpdateMonitoringRequest request) {
        return this.updateMonitoringAsync(request, null);
    }

    @Override
    public Future<UpdateMonitoringResult> updateMonitoringAsync(UpdateMonitoringRequest request, final AsyncHandler<UpdateMonitoringRequest, UpdateMonitoringResult> asyncHandler) {
        final UpdateMonitoringRequest finalRequest = (UpdateMonitoringRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMonitoringResult>(){

            @Override
            public UpdateMonitoringResult call() throws Exception {
                UpdateMonitoringResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateMonitoring(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateReplicationInfoResult> updateReplicationInfoAsync(UpdateReplicationInfoRequest request) {
        return this.updateReplicationInfoAsync(request, null);
    }

    @Override
    public Future<UpdateReplicationInfoResult> updateReplicationInfoAsync(UpdateReplicationInfoRequest request, final AsyncHandler<UpdateReplicationInfoRequest, UpdateReplicationInfoResult> asyncHandler) {
        final UpdateReplicationInfoRequest finalRequest = (UpdateReplicationInfoRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateReplicationInfoResult>(){

            @Override
            public UpdateReplicationInfoResult call() throws Exception {
                UpdateReplicationInfoResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateReplicationInfo(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSecurityResult> updateSecurityAsync(UpdateSecurityRequest request) {
        return this.updateSecurityAsync(request, null);
    }

    @Override
    public Future<UpdateSecurityResult> updateSecurityAsync(UpdateSecurityRequest request, final AsyncHandler<UpdateSecurityRequest, UpdateSecurityResult> asyncHandler) {
        final UpdateSecurityRequest finalRequest = (UpdateSecurityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSecurityResult>(){

            @Override
            public UpdateSecurityResult call() throws Exception {
                UpdateSecurityResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateSecurity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStorageResult> updateStorageAsync(UpdateStorageRequest request) {
        return this.updateStorageAsync(request, null);
    }

    @Override
    public Future<UpdateStorageResult> updateStorageAsync(UpdateStorageRequest request, final AsyncHandler<UpdateStorageRequest, UpdateStorageResult> asyncHandler) {
        final UpdateStorageRequest finalRequest = (UpdateStorageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStorageResult>(){

            @Override
            public UpdateStorageResult call() throws Exception {
                UpdateStorageResult result = null;
                try {
                    result = AWSKafkaAsyncClient.this.executeUpdateStorage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

