/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model.transform;

import com.amazonaws.services.ivsrealtime.model.Composition;
import com.amazonaws.services.ivsrealtime.model.transform.DestinationJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.LayoutConfigurationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class CompositionJsonUnmarshaller
implements Unmarshaller<Composition, JsonUnmarshallerContext> {
    private static CompositionJsonUnmarshaller instance;

    public Composition unmarshall(JsonUnmarshallerContext context) throws Exception {
        Composition composition = new Composition();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    composition.setArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("stageArn", targetDepth)) {
                    context.nextToken();
                    composition.setStageArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    composition.setState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("layout", targetDepth)) {
                    context.nextToken();
                    composition.setLayout(LayoutConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("destinations", targetDepth)) {
                    context.nextToken();
                    composition.setDestinations(new ListUnmarshaller((Unmarshaller)DestinationJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    composition.setTags(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    composition.setStartTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                }
                if (context.testExpression("endTime", targetDepth)) {
                    context.nextToken();
                    composition.setEndTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return composition;
    }

    public static CompositionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CompositionJsonUnmarshaller();
        }
        return instance;
    }
}

