/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.LteObj;
import java.util.List;

@SdkInternalApi
public class LteObjMarshaller {
    private static final MarshallingInfo<Integer> MCC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mcc").build();
    private static final MarshallingInfo<Integer> MNC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mnc").build();
    private static final MarshallingInfo<Integer> EUTRANCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EutranCid").build();
    private static final MarshallingInfo<Integer> TAC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tac").build();
    private static final MarshallingInfo<StructuredPojo> LTELOCALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LteLocalId").build();
    private static final MarshallingInfo<Integer> LTETIMINGADVANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LteTimingAdvance").build();
    private static final MarshallingInfo<Integer> RSRP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rsrp").build();
    private static final MarshallingInfo<Float> RSRQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rsrq").build();
    private static final MarshallingInfo<Boolean> NRCAPABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NrCapable").build();
    private static final MarshallingInfo<List> LTENMR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LteNmr").build();
    private static final LteObjMarshaller instance = new LteObjMarshaller();

    public static LteObjMarshaller getInstance() {
        return instance;
    }

    public void marshall(LteObj lteObj, ProtocolMarshaller protocolMarshaller) {
        if (lteObj == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lteObj.getMcc(), MCC_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getMnc(), MNC_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getEutranCid(), EUTRANCID_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getTac(), TAC_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getLteLocalId(), LTELOCALID_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getLteTimingAdvance(), LTETIMINGADVANCE_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getRsrp(), RSRP_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getRsrq(), RSRQ_BINDING);
            protocolMarshaller.marshall((Object)lteObj.getNrCapable(), NRCAPABLE_BINDING);
            protocolMarshaller.marshall(lteObj.getLteNmr(), LTENMR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

