/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.GsmObj;
import java.util.List;

@SdkInternalApi
public class GsmObjMarshaller {
    private static final MarshallingInfo<Integer> MCC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mcc").build();
    private static final MarshallingInfo<Integer> MNC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mnc").build();
    private static final MarshallingInfo<Integer> LAC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lac").build();
    private static final MarshallingInfo<Integer> GERANCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GeranCid").build();
    private static final MarshallingInfo<StructuredPojo> GSMLOCALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GsmLocalId").build();
    private static final MarshallingInfo<Integer> GSMTIMINGADVANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GsmTimingAdvance").build();
    private static final MarshallingInfo<Integer> RXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RxLevel").build();
    private static final MarshallingInfo<List> GSMNMR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GsmNmr").build();
    private static final GsmObjMarshaller instance = new GsmObjMarshaller();

    public static GsmObjMarshaller getInstance() {
        return instance;
    }

    public void marshall(GsmObj gsmObj, ProtocolMarshaller protocolMarshaller) {
        if (gsmObj == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)gsmObj.getMcc(), MCC_BINDING);
            protocolMarshaller.marshall((Object)gsmObj.getMnc(), MNC_BINDING);
            protocolMarshaller.marshall((Object)gsmObj.getLac(), LAC_BINDING);
            protocolMarshaller.marshall((Object)gsmObj.getGeranCid(), GERANCID_BINDING);
            protocolMarshaller.marshall((Object)gsmObj.getGsmLocalId(), GSMLOCALID_BINDING);
            protocolMarshaller.marshall((Object)gsmObj.getGsmTimingAdvance(), GSMTIMINGADVANCE_BINDING);
            protocolMarshaller.marshall((Object)gsmObj.getRxLevel(), RXLEVEL_BINDING);
            protocolMarshaller.marshall(gsmObj.getGsmNmr(), GSMNMR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

