/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.CdmaObj;
import java.util.List;

@SdkInternalApi
public class CdmaObjMarshaller {
    private static final MarshallingInfo<Integer> SYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SystemId").build();
    private static final MarshallingInfo<Integer> NETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkId").build();
    private static final MarshallingInfo<Integer> BASESTATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaseStationId").build();
    private static final MarshallingInfo<Integer> REGISTRATIONZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationZone").build();
    private static final MarshallingInfo<StructuredPojo> CDMALOCALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdmaLocalId").build();
    private static final MarshallingInfo<Integer> PILOTPOWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PilotPower").build();
    private static final MarshallingInfo<Float> BASELAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaseLat").build();
    private static final MarshallingInfo<Float> BASELNG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaseLng").build();
    private static final MarshallingInfo<List> CDMANMR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CdmaNmr").build();
    private static final CdmaObjMarshaller instance = new CdmaObjMarshaller();

    public static CdmaObjMarshaller getInstance() {
        return instance;
    }

    public void marshall(CdmaObj cdmaObj, ProtocolMarshaller protocolMarshaller) {
        if (cdmaObj == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cdmaObj.getSystemId(), SYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)cdmaObj.getNetworkId(), NETWORKID_BINDING);
            protocolMarshaller.marshall((Object)cdmaObj.getBaseStationId(), BASESTATIONID_BINDING);
            protocolMarshaller.marshall((Object)cdmaObj.getRegistrationZone(), REGISTRATIONZONE_BINDING);
            protocolMarshaller.marshall((Object)cdmaObj.getCdmaLocalId(), CDMALOCALID_BINDING);
            protocolMarshaller.marshall((Object)cdmaObj.getPilotPower(), PILOTPOWER_BINDING);
            protocolMarshaller.marshall((Object)cdmaObj.getBaseLat(), BASELAT_BINDING);
            protocolMarshaller.marshall((Object)cdmaObj.getBaseLng(), BASELNG_BINDING);
            protocolMarshaller.marshall(cdmaObj.getCdmaNmr(), CDMANMR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

