/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.Resource;

@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> PORTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("portal").build();
    private static final MarshallingInfo<StructuredPojo> PROJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("project").build();
    private static final ResourceMarshaller instance = new ResourceMarshaller();

    public static ResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        if (resource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resource.getPortal(), PORTAL_BINDING);
            protocolMarshaller.marshall((Object)resource.getProject(), PROJECT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

