/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.AggregatedValue;
import java.util.Date;

@SdkInternalApi
public class AggregatedValueMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> QUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("quality").build();
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").build();
    private static final AggregatedValueMarshaller instance = new AggregatedValueMarshaller();

    public static AggregatedValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(AggregatedValue aggregatedValue, ProtocolMarshaller protocolMarshaller) {
        if (aggregatedValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aggregatedValue.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)aggregatedValue.getQuality(), QUALITY_BINDING);
            protocolMarshaller.marshall((Object)aggregatedValue.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

