/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotanalytics.model.Datastore;
import java.util.Date;

@SdkInternalApi
public class DatastoreMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> STORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storage").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<StructuredPojo> RETENTIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retentionPeriod").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMESSAGEARRIVALTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastMessageArrivalTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> FILEFORMATCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileFormatConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> DATASTOREPARTITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datastorePartitions").build();
    private static final DatastoreMarshaller instance = new DatastoreMarshaller();

    public static DatastoreMarshaller getInstance() {
        return instance;
    }

    public void marshall(Datastore datastore, ProtocolMarshaller protocolMarshaller) {
        if (datastore == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)datastore.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)datastore.getStorage(), STORAGE_BINDING);
            protocolMarshaller.marshall((Object)datastore.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)datastore.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)datastore.getRetentionPeriod(), RETENTIONPERIOD_BINDING);
            protocolMarshaller.marshall((Object)datastore.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)datastore.getLastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)datastore.getLastMessageArrivalTime(), LASTMESSAGEARRIVALTIME_BINDING);
            protocolMarshaller.marshall((Object)datastore.getFileFormatConfiguration(), FILEFORMATCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)datastore.getDatastorePartitions(), DATASTOREPARTITIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

