/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devopsguru.model.CloudFormationCollection;
import com.amazonaws.services.devopsguru.model.TagCollection;
import com.amazonaws.services.devopsguru.model.transform.ResourceCollectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceCollection
implements Serializable,
Cloneable,
StructuredPojo {
    private CloudFormationCollection cloudFormation;
    private List<TagCollection> tags;

    public void setCloudFormation(CloudFormationCollection cloudFormation) {
        this.cloudFormation = cloudFormation;
    }

    public CloudFormationCollection getCloudFormation() {
        return this.cloudFormation;
    }

    public ResourceCollection withCloudFormation(CloudFormationCollection cloudFormation) {
        this.setCloudFormation(cloudFormation);
        return this;
    }

    public List<TagCollection> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagCollection> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagCollection>(tags);
    }

    public ResourceCollection withTags(TagCollection ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagCollection>(tags.length));
        }
        for (TagCollection ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ResourceCollection withTags(Collection<TagCollection> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCloudFormation() != null) {
            sb.append("CloudFormation: ").append(this.getCloudFormation()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCollection)) {
            return false;
        }
        ResourceCollection other = (ResourceCollection)obj;
        if (other.getCloudFormation() == null ^ this.getCloudFormation() == null) {
            return false;
        }
        if (other.getCloudFormation() != null && !other.getCloudFormation().equals(this.getCloudFormation())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCloudFormation() == null ? 0 : this.getCloudFormation().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ResourceCollection clone() {
        try {
            return (ResourceCollection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceCollectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

