/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.StepAmountCapability;
import com.amazonaws.services.deadline.model.StepAttributeCapability;
import com.amazonaws.services.deadline.model.transform.StepRequiredCapabilitiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StepRequiredCapabilities
implements Serializable,
Cloneable,
StructuredPojo {
    private List<StepAmountCapability> amounts;
    private List<StepAttributeCapability> attributes;

    public List<StepAmountCapability> getAmounts() {
        return this.amounts;
    }

    public void setAmounts(Collection<StepAmountCapability> amounts) {
        if (amounts == null) {
            this.amounts = null;
            return;
        }
        this.amounts = new ArrayList<StepAmountCapability>(amounts);
    }

    public StepRequiredCapabilities withAmounts(StepAmountCapability ... amounts) {
        if (this.amounts == null) {
            this.setAmounts(new ArrayList<StepAmountCapability>(amounts.length));
        }
        for (StepAmountCapability ele : amounts) {
            this.amounts.add(ele);
        }
        return this;
    }

    public StepRequiredCapabilities withAmounts(Collection<StepAmountCapability> amounts) {
        this.setAmounts(amounts);
        return this;
    }

    public List<StepAttributeCapability> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<StepAttributeCapability> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<StepAttributeCapability>(attributes);
    }

    public StepRequiredCapabilities withAttributes(StepAttributeCapability ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<StepAttributeCapability>(attributes.length));
        }
        for (StepAttributeCapability ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public StepRequiredCapabilities withAttributes(Collection<StepAttributeCapability> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAmounts() != null) {
            sb.append("Amounts: ").append(this.getAmounts()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepRequiredCapabilities)) {
            return false;
        }
        StepRequiredCapabilities other = (StepRequiredCapabilities)obj;
        if (other.getAmounts() == null ^ this.getAmounts() == null) {
            return false;
        }
        if (other.getAmounts() != null && !other.getAmounts().equals(this.getAmounts())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmounts() == null ? 0 : this.getAmounts().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public StepRequiredCapabilities clone() {
        try {
            return (StepRequiredCapabilities)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepRequiredCapabilitiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

