/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.LFTag;
import java.util.List;

@SdkInternalApi
public class LFTagMarshaller {
    private static final MarshallingInfo<String> TAGKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKey").build();
    private static final MarshallingInfo<List> TAGVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagValues").build();
    private static final LFTagMarshaller instance = new LFTagMarshaller();

    public static LFTagMarshaller getInstance() {
        return instance;
    }

    public void marshall(LFTag lFTag, ProtocolMarshaller protocolMarshaller) {
        if (lFTag == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lFTag.getTagKey(), TAGKEY_BINDING);
            protocolMarshaller.marshall(lFTag.getTagValues(), TAGVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

