/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connect.model.ViewContent;
import java.util.List;

@SdkInternalApi
public class ViewContentMarshaller {
    private static final MarshallingInfo<String> INPUTSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputSchema").build();
    private static final MarshallingInfo<String> TEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Template").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Actions").build();
    private static final ViewContentMarshaller instance = new ViewContentMarshaller();

    public static ViewContentMarshaller getInstance() {
        return instance;
    }

    public void marshall(ViewContent viewContent, ProtocolMarshaller protocolMarshaller) {
        if (viewContent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)viewContent.getInputSchema(), INPUTSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)viewContent.getTemplate(), TEMPLATE_BINDING);
            protocolMarshaller.marshall(viewContent.getActions(), ACTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

