/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.MediaConcurrency;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRoutingProfileConcurrencyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private String routingProfileId;
    private List<MediaConcurrency> mediaConcurrencies;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public UpdateRoutingProfileConcurrencyRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setRoutingProfileId(String routingProfileId) {
        this.routingProfileId = routingProfileId;
    }

    public String getRoutingProfileId() {
        return this.routingProfileId;
    }

    public UpdateRoutingProfileConcurrencyRequest withRoutingProfileId(String routingProfileId) {
        this.setRoutingProfileId(routingProfileId);
        return this;
    }

    public List<MediaConcurrency> getMediaConcurrencies() {
        return this.mediaConcurrencies;
    }

    public void setMediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
        if (mediaConcurrencies == null) {
            this.mediaConcurrencies = null;
            return;
        }
        this.mediaConcurrencies = new ArrayList<MediaConcurrency>(mediaConcurrencies);
    }

    public UpdateRoutingProfileConcurrencyRequest withMediaConcurrencies(MediaConcurrency ... mediaConcurrencies) {
        if (this.mediaConcurrencies == null) {
            this.setMediaConcurrencies(new ArrayList<MediaConcurrency>(mediaConcurrencies.length));
        }
        for (MediaConcurrency ele : mediaConcurrencies) {
            this.mediaConcurrencies.add(ele);
        }
        return this;
    }

    public UpdateRoutingProfileConcurrencyRequest withMediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
        this.setMediaConcurrencies(mediaConcurrencies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getRoutingProfileId() != null) {
            sb.append("RoutingProfileId: ").append(this.getRoutingProfileId()).append(",");
        }
        if (this.getMediaConcurrencies() != null) {
            sb.append("MediaConcurrencies: ").append(this.getMediaConcurrencies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingProfileConcurrencyRequest)) {
            return false;
        }
        UpdateRoutingProfileConcurrencyRequest other = (UpdateRoutingProfileConcurrencyRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getRoutingProfileId() == null ^ this.getRoutingProfileId() == null) {
            return false;
        }
        if (other.getRoutingProfileId() != null && !other.getRoutingProfileId().equals(this.getRoutingProfileId())) {
            return false;
        }
        if (other.getMediaConcurrencies() == null ^ this.getMediaConcurrencies() == null) {
            return false;
        }
        return other.getMediaConcurrencies() == null || other.getMediaConcurrencies().equals(this.getMediaConcurrencies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingProfileId() == null ? 0 : this.getRoutingProfileId().hashCode());
        hashCode = 31 * hashCode + (this.getMediaConcurrencies() == null ? 0 : this.getMediaConcurrencies().hashCode());
        return hashCode;
    }

    public UpdateRoutingProfileConcurrencyRequest clone() {
        return (UpdateRoutingProfileConcurrencyRequest)super.clone();
    }
}

