/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.SignInDistribution;
import com.amazonaws.services.connect.model.transform.SignInConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SignInConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SignInDistribution> distributions;

    public List<SignInDistribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(Collection<SignInDistribution> distributions) {
        if (distributions == null) {
            this.distributions = null;
            return;
        }
        this.distributions = new ArrayList<SignInDistribution>(distributions);
    }

    public SignInConfig withDistributions(SignInDistribution ... distributions) {
        if (this.distributions == null) {
            this.setDistributions(new ArrayList<SignInDistribution>(distributions.length));
        }
        for (SignInDistribution ele : distributions) {
            this.distributions.add(ele);
        }
        return this;
    }

    public SignInConfig withDistributions(Collection<SignInDistribution> distributions) {
        this.setDistributions(distributions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDistributions() != null) {
            sb.append("Distributions: ").append(this.getDistributions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignInConfig)) {
            return false;
        }
        SignInConfig other = (SignInConfig)obj;
        if (other.getDistributions() == null ^ this.getDistributions() == null) {
            return false;
        }
        return other.getDistributions() == null || other.getDistributions().equals(this.getDistributions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDistributions() == null ? 0 : this.getDistributions().hashCode());
        return hashCode;
    }

    public SignInConfig clone() {
        try {
            return (SignInConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SignInConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

