/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.transform.NotificationRecipientTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationRecipientType
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> userTags;
    private List<String> userIds;

    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    public void setUserTags(Map<String, String> userTags) {
        this.userTags = userTags;
    }

    public NotificationRecipientType withUserTags(Map<String, String> userTags) {
        this.setUserTags(userTags);
        return this;
    }

    public NotificationRecipientType addUserTagsEntry(String key, String value) {
        if (null == this.userTags) {
            this.userTags = new HashMap<String, String>();
        }
        if (this.userTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userTags.put(key, value);
        return this;
    }

    public NotificationRecipientType clearUserTagsEntries() {
        this.userTags = null;
        return this;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
            return;
        }
        this.userIds = new ArrayList<String>(userIds);
    }

    public NotificationRecipientType withUserIds(String ... userIds) {
        if (this.userIds == null) {
            this.setUserIds(new ArrayList<String>(userIds.length));
        }
        for (String ele : userIds) {
            this.userIds.add(ele);
        }
        return this;
    }

    public NotificationRecipientType withUserIds(Collection<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserTags() != null) {
            sb.append("UserTags: ").append(this.getUserTags()).append(",");
        }
        if (this.getUserIds() != null) {
            sb.append("UserIds: ").append(this.getUserIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationRecipientType)) {
            return false;
        }
        NotificationRecipientType other = (NotificationRecipientType)obj;
        if (other.getUserTags() == null ^ this.getUserTags() == null) {
            return false;
        }
        if (other.getUserTags() != null && !other.getUserTags().equals(this.getUserTags())) {
            return false;
        }
        if (other.getUserIds() == null ^ this.getUserIds() == null) {
            return false;
        }
        return other.getUserIds() == null || other.getUserIds().equals(this.getUserIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserTags() == null ? 0 : this.getUserTags().hashCode());
        hashCode = 31 * hashCode + (this.getUserIds() == null ? 0 : this.getUserIds().hashCode());
        return hashCode;
    }

    public NotificationRecipientType clone() {
        try {
            return (NotificationRecipientType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationRecipientTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

