/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.EndpointType;
import com.amazonaws.services.connect.model.transform.EndpointMarshaller;
import java.io.Serializable;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String address;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Endpoint withType(String type) {
        this.setType(type);
        return this;
    }

    public Endpoint withType(EndpointType type) {
        this.type = type.toString();
        return this;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public Endpoint withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        return other.getAddress() == null || other.getAddress().equals(this.getAddress());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

