/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bcmdataexports.model.S3OutputConfigurations;
import com.amazonaws.services.bcmdataexports.model.transform.S3DestinationMarshaller;
import java.io.Serializable;

public class S3Destination
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Bucket;
    private S3OutputConfigurations s3OutputConfigurations;
    private String s3Prefix;
    private String s3Region;

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public S3Destination withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public void setS3OutputConfigurations(S3OutputConfigurations s3OutputConfigurations) {
        this.s3OutputConfigurations = s3OutputConfigurations;
    }

    public S3OutputConfigurations getS3OutputConfigurations() {
        return this.s3OutputConfigurations;
    }

    public S3Destination withS3OutputConfigurations(S3OutputConfigurations s3OutputConfigurations) {
        this.setS3OutputConfigurations(s3OutputConfigurations);
        return this;
    }

    public void setS3Prefix(String s3Prefix) {
        this.s3Prefix = s3Prefix;
    }

    public String getS3Prefix() {
        return this.s3Prefix;
    }

    public S3Destination withS3Prefix(String s3Prefix) {
        this.setS3Prefix(s3Prefix);
        return this;
    }

    public void setS3Region(String s3Region) {
        this.s3Region = s3Region;
    }

    public String getS3Region() {
        return this.s3Region;
    }

    public S3Destination withS3Region(String s3Region) {
        this.setS3Region(s3Region);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3OutputConfigurations() != null) {
            sb.append("S3OutputConfigurations: ").append(this.getS3OutputConfigurations()).append(",");
        }
        if (this.getS3Prefix() != null) {
            sb.append("S3Prefix: ").append(this.getS3Prefix()).append(",");
        }
        if (this.getS3Region() != null) {
            sb.append("S3Region: ").append(this.getS3Region());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination)obj;
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3OutputConfigurations() == null ^ this.getS3OutputConfigurations() == null) {
            return false;
        }
        if (other.getS3OutputConfigurations() != null && !other.getS3OutputConfigurations().equals(this.getS3OutputConfigurations())) {
            return false;
        }
        if (other.getS3Prefix() == null ^ this.getS3Prefix() == null) {
            return false;
        }
        if (other.getS3Prefix() != null && !other.getS3Prefix().equals(this.getS3Prefix())) {
            return false;
        }
        if (other.getS3Region() == null ^ this.getS3Region() == null) {
            return false;
        }
        return other.getS3Region() == null || other.getS3Region().equals(this.getS3Region());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3OutputConfigurations() == null ? 0 : this.getS3OutputConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getS3Prefix() == null ? 0 : this.getS3Prefix().hashCode());
        hashCode = 31 * hashCode + (this.getS3Region() == null ? 0 : this.getS3Region().hashCode());
        return hashCode;
    }

    public S3Destination clone() {
        try {
            return (S3Destination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

