/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.EksContainerEnvironmentVariable;
import com.amazonaws.services.batch.model.EksContainerResourceRequirements;
import com.amazonaws.services.batch.model.EksContainerSecurityContext;
import com.amazonaws.services.batch.model.EksContainerVolumeMount;
import com.amazonaws.services.batch.model.transform.EksContainerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EksContainer
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String image;
    private String imagePullPolicy;
    private List<String> command;
    private List<String> args;
    private List<EksContainerEnvironmentVariable> env;
    private EksContainerResourceRequirements resources;
    private List<EksContainerVolumeMount> volumeMounts;
    private EksContainerSecurityContext securityContext;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EksContainer withName(String name) {
        this.setName(name);
        return this;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public EksContainer withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public EksContainer withImagePullPolicy(String imagePullPolicy) {
        this.setImagePullPolicy(imagePullPolicy);
        return this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new ArrayList<String>(command);
    }

    public EksContainer withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public EksContainer withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        this.args = new ArrayList<String>(args);
    }

    public EksContainer withArgs(String ... args) {
        if (this.args == null) {
            this.setArgs(new ArrayList<String>(args.length));
        }
        for (String ele : args) {
            this.args.add(ele);
        }
        return this;
    }

    public EksContainer withArgs(Collection<String> args) {
        this.setArgs(args);
        return this;
    }

    public List<EksContainerEnvironmentVariable> getEnv() {
        return this.env;
    }

    public void setEnv(Collection<EksContainerEnvironmentVariable> env) {
        if (env == null) {
            this.env = null;
            return;
        }
        this.env = new ArrayList<EksContainerEnvironmentVariable>(env);
    }

    public EksContainer withEnv(EksContainerEnvironmentVariable ... env) {
        if (this.env == null) {
            this.setEnv(new ArrayList<EksContainerEnvironmentVariable>(env.length));
        }
        for (EksContainerEnvironmentVariable ele : env) {
            this.env.add(ele);
        }
        return this;
    }

    public EksContainer withEnv(Collection<EksContainerEnvironmentVariable> env) {
        this.setEnv(env);
        return this;
    }

    public void setResources(EksContainerResourceRequirements resources) {
        this.resources = resources;
    }

    public EksContainerResourceRequirements getResources() {
        return this.resources;
    }

    public EksContainer withResources(EksContainerResourceRequirements resources) {
        this.setResources(resources);
        return this;
    }

    public List<EksContainerVolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(Collection<EksContainerVolumeMount> volumeMounts) {
        if (volumeMounts == null) {
            this.volumeMounts = null;
            return;
        }
        this.volumeMounts = new ArrayList<EksContainerVolumeMount>(volumeMounts);
    }

    public EksContainer withVolumeMounts(EksContainerVolumeMount ... volumeMounts) {
        if (this.volumeMounts == null) {
            this.setVolumeMounts(new ArrayList<EksContainerVolumeMount>(volumeMounts.length));
        }
        for (EksContainerVolumeMount ele : volumeMounts) {
            this.volumeMounts.add(ele);
        }
        return this;
    }

    public EksContainer withVolumeMounts(Collection<EksContainerVolumeMount> volumeMounts) {
        this.setVolumeMounts(volumeMounts);
        return this;
    }

    public void setSecurityContext(EksContainerSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public EksContainerSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public EksContainer withSecurityContext(EksContainerSecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getImagePullPolicy() != null) {
            sb.append("ImagePullPolicy: ").append(this.getImagePullPolicy()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: ").append(this.getArgs()).append(",");
        }
        if (this.getEnv() != null) {
            sb.append("Env: ").append(this.getEnv()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getVolumeMounts() != null) {
            sb.append("VolumeMounts: ").append(this.getVolumeMounts()).append(",");
        }
        if (this.getSecurityContext() != null) {
            sb.append("SecurityContext: ").append(this.getSecurityContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainer)) {
            return false;
        }
        EksContainer other = (EksContainer)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getImagePullPolicy() == null ^ this.getImagePullPolicy() == null) {
            return false;
        }
        if (other.getImagePullPolicy() != null && !other.getImagePullPolicy().equals(this.getImagePullPolicy())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        if (other.getArgs() != null && !other.getArgs().equals(this.getArgs())) {
            return false;
        }
        if (other.getEnv() == null ^ this.getEnv() == null) {
            return false;
        }
        if (other.getEnv() != null && !other.getEnv().equals(this.getEnv())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getVolumeMounts() == null ^ this.getVolumeMounts() == null) {
            return false;
        }
        if (other.getVolumeMounts() != null && !other.getVolumeMounts().equals(this.getVolumeMounts())) {
            return false;
        }
        if (other.getSecurityContext() == null ^ this.getSecurityContext() == null) {
            return false;
        }
        return other.getSecurityContext() == null || other.getSecurityContext().equals(this.getSecurityContext());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getImagePullPolicy() == null ? 0 : this.getImagePullPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        hashCode = 31 * hashCode + (this.getEnv() == null ? 0 : this.getEnv().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeMounts() == null ? 0 : this.getVolumeMounts().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityContext() == null ? 0 : this.getSecurityContext().hashCode());
        return hashCode;
    }

    public EksContainer clone() {
        try {
            return (EksContainer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EksContainerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

