/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.b2bi.model.TransformerSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTransformersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<TransformerSummary> transformers;
    private String nextToken;

    public List<TransformerSummary> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(Collection<TransformerSummary> transformers) {
        if (transformers == null) {
            this.transformers = null;
            return;
        }
        this.transformers = new ArrayList<TransformerSummary>(transformers);
    }

    public ListTransformersResult withTransformers(TransformerSummary ... transformers) {
        if (this.transformers == null) {
            this.setTransformers(new ArrayList<TransformerSummary>(transformers.length));
        }
        for (TransformerSummary ele : transformers) {
            this.transformers.add(ele);
        }
        return this;
    }

    public ListTransformersResult withTransformers(Collection<TransformerSummary> transformers) {
        this.setTransformers(transformers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTransformersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransformers() != null) {
            sb.append("Transformers: ").append(this.getTransformers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransformersResult)) {
            return false;
        }
        ListTransformersResult other = (ListTransformersResult)obj;
        if (other.getTransformers() == null ^ this.getTransformers() == null) {
            return false;
        }
        if (other.getTransformers() != null && !other.getTransformers().equals(this.getTransformers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransformers() == null ? 0 : this.getTransformers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTransformersResult clone() {
        try {
            return (ListTransformersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

