/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appmesh.model.PortMapping;

@SdkInternalApi
public class PortMappingMarshaller {
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("port").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final PortMappingMarshaller instance = new PortMappingMarshaller();

    public static PortMappingMarshaller getInstance() {
        return instance;
    }

    public void marshall(PortMapping portMapping, ProtocolMarshaller protocolMarshaller) {
        if (portMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)portMapping.getPort(), PORT_BINDING);
            protocolMarshaller.marshall((Object)portMapping.getProtocol(), PROTOCOL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

