/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.WebServiceRequest;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectsRequest
extends WebServiceRequest {
    public static final int DELETE_OBJECTS_ONETIME_LIMIT = 1000;
    private String bucketName;
    private final List<String> keys = new ArrayList<String>();
    private boolean quiet;

    public DeleteObjectsRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        if (keys == null || keys.size() == 0) {
            throw new IllegalArgumentException("Keys to delete must be specified");
        }
        if (keys.size() > 1000) {
            throw new IllegalArgumentException("The count of keys to delete exceed max limit 1000");
        }
        for (String key : keys) {
            if (key != null && !key.equals("") && OSSUtils.validateObjectKey(key)) continue;
            throw new IllegalArgumentException("Illegal object key " + key);
        }
        this.keys.clear();
        this.keys.addAll(keys);
    }
}

