/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mimetypes {
    private static final Log log = LogFactory.getLog(Mimetypes.class);
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static Mimetypes mimetypes = null;
    private HashMap<String, String> extensionToMimetypeMap = new HashMap();

    private Mimetypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream is = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (is != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loading mime types from file in the classpath: mime.types");
            }
            try {
                mimetypes.loadMimetypes(is);
                return mimetypes;
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) return mimetypes;
                log.error((Object)"Failed to load mime types from file in the classpath: mime.types", (Throwable)e);
                return mimetypes;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!log.isWarnEnabled()) return mimetypes;
        log.warn((Object)"Unable to find 'mime.types' file in classpath");
        return mimetypes;
    }

    public void loadMimetypes(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st;
            if ((line = line.trim()).startsWith("#") || line.length() == 0 || (st = new StringTokenizer(line, " \t")).countTokens() <= 1) continue;
            String extension = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String mimetype = st.nextToken();
            this.extensionToMimetypeMap.put(extension.toLowerCase(), mimetype);
        }
    }

    public String getMimetype(String fileName) {
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1).toLowerCase();
            if (this.extensionToMimetypeMap.keySet().contains(ext)) {
                String mimetype = this.extensionToMimetypeMap.get(ext);
                return mimetype;
            }
        }
        return DEFAULT_MIMETYPE;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }
}

