/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.opentelemetry.sdk;

import com.aliyun.openservices.shade.io.opentelemetry.api.GlobalOpenTelemetry;
import com.aliyun.openservices.shade.io.opentelemetry.context.propagation.ContextPropagators;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.OpenTelemetrySdk;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.logs.SdkLogEmitterProvider;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.Nullable;

public final class OpenTelemetrySdkBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;
    @Nullable
    private SdkMeterProvider meterProvider;
    @Nullable
    private SdkLogEmitterProvider logEmitterProvider;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setMeterProvider(SdkMeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setLogEmitterProvider(SdkLogEmitterProvider logEmitterProvider) {
        this.logEmitterProvider = logEmitterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        this.propagators = propagators;
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk sdk = this.build();
        GlobalOpenTelemetry.set(sdk);
        return sdk;
    }

    public OpenTelemetrySdk build() {
        SdkLogEmitterProvider logEmitterProvider;
        SdkMeterProvider meterProvider;
        SdkTracerProvider tracerProvider = this.tracerProvider;
        if (tracerProvider == null) {
            tracerProvider = SdkTracerProvider.builder().build();
        }
        if ((meterProvider = this.meterProvider) == null) {
            meterProvider = SdkMeterProvider.builder().build();
        }
        if ((logEmitterProvider = this.logEmitterProvider) == null) {
            logEmitterProvider = SdkLogEmitterProvider.builder().build();
        }
        return new OpenTelemetrySdk(tracerProvider, meterProvider, logEmitterProvider, this.propagators);
    }
}

