/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.opentelemetry.exporter.otlp.metrics;

import com.aliyun.openservices.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import com.aliyun.openservices.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.aliyun.openservices.shade.io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import com.aliyun.openservices.shade.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.metrics.InstrumentType;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.metrics.data.MetricData;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import com.aliyun.openservices.shade.io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private final GrpcExporter<MetricsRequestMarshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    OtlpGrpcMetricExporter(GrpcExporter<MetricsRequestMarshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector) {
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.delegate.export((Marshaler)request, metrics.size());
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

