/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.stream;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.google.common.base.Stopwatch;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class BufferChainOutputStream
extends OutputStream {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private final LinkedList<ByteBuf> bufferChain;
    private final ByteBufAllocator allocator;

    public BufferChainOutputStream(LinkedList<ByteBuf> bufferChain, ByteBufAllocator allocator) {
        this.bufferChain = bufferChain;
        this.allocator = allocator;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bufferChain.isEmpty()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            ByteBuf slice = this.allocator.directBuffer(65536, 0x100000);
            long allocationOverhead = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            if (allocationOverhead > 0L) {
                LOGGER.debug("Allocator spent {}ms allocating a buffer", (Object)allocationOverhead);
            }
            slice.writeBytes(b, off, len);
            this.bufferChain.addLast(slice);
        } else {
            ByteBuf slice = this.bufferChain.getLast();
            if (slice.writerIndex() + len < 0x100000) {
                slice.writeBytes(b, off, len);
            } else {
                Stopwatch stopwatch = Stopwatch.createStarted();
                slice = this.allocator.directBuffer(65536, 0x100000);
                long allocationOverhead = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                if (allocationOverhead > 0L) {
                    LOGGER.debug("Allocator spent {}ms allocating a buffer", (Object)allocationOverhead);
                }
                slice.writeBytes(b, off, len);
                this.bufferChain.addLast(slice);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Unsupported");
    }
}

