/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceThread;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;

public class RebalanceService
extends ServiceThread {
    private static long waitInterval = Long.parseLong(System.getProperty("rocketmq.client.rebalance.waitInterval", "20000"));
    private static long minInterval = Long.parseLong(System.getProperty("rocketmq.client.rebalance.minInterval", "1000"));
    private final InternalLogger log = ClientLogger.getLog();
    private final MQClientInstance mqClientFactory;
    private long lastRebalanceTimestamp = System.currentTimeMillis();

    public RebalanceService(MQClientInstance mqClientFactory) {
        this.mqClientFactory = mqClientFactory;
    }

    @Override
    public void run() {
        this.log.info(this.getServiceName() + " service started");
        boolean balanced = false;
        long realWaitInterval = minInterval;
        while (!this.isStopped()) {
            this.waitForRunning(realWaitInterval);
            long interval = System.currentTimeMillis() - this.lastRebalanceTimestamp;
            if (interval < minInterval) {
                realWaitInterval = minInterval - interval;
                continue;
            }
            balanced = this.mqClientFactory.doRebalance();
            this.lastRebalanceTimestamp = System.currentTimeMillis();
            realWaitInterval = balanced ? waitInterval : minInterval;
        }
        this.log.info(this.getServiceName() + " service end");
    }

    @Override
    public String getServiceName() {
        return RebalanceService.class.getSimpleName();
    }
}

