/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ons.open.trace.core.dispatch.impl;

import com.alibaba.ons.open.trace.core.common.OnsTraceContext;
import com.alibaba.ons.open.trace.core.common.OnsTraceDataEncoder;
import com.alibaba.ons.open.trace.core.common.OnsTraceTransferBean;
import com.alibaba.ons.open.trace.core.dispatch.NameServerAddressSetter;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentialsProvider;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.common.ThreadLocalIndex;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.MessageQueueSelector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ThreadFactoryImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class InnerTraceProducer {
    private static final InternalLogger CLIENT_LOG = ClientLogger.getLog();
    private static final AtomicInteger instanceNum = new AtomicInteger(0);
    private final int instanceId = instanceNum.getAndIncrement();
    private final int queueSize;
    private final int batchSize;
    private final int threadNum = Math.max(8, Runtime.getRuntime().availableProcessors());
    private final DefaultMQProducer traceProducer;
    private final ThreadPoolExecutor traceExecuter;
    private final ScheduledExecutorService scheduledExecutorService;
    private AtomicLong discardCount;
    private Thread worker;
    private ArrayBlockingQueue<OnsTraceContext> traceContextQueue;
    private ArrayBlockingQueue<Runnable> appenderQueue;
    private volatile Thread shutDownHook;
    private volatile boolean stopped = false;
    private volatile ThreadLocalIndex sendWhichQueue = new ThreadLocalIndex();
    private NameServerAddressSetter nameserverAddressSetter;
    private String traceNamesrvAddr;
    private static Map<String, InnerTraceProducer> dispatcherTable = new ConcurrentHashMap<String, InnerTraceProducer>();
    private static AtomicBoolean isStarted = new AtomicBoolean(false);
    private static InnerTraceProducer innerTraceProducer;
    private final Boolean selectQueueEnable;

    public static InnerTraceProducer getTraceDispatcherProducer(Properties properties, SessionCredentialsProvider provider, NameServerAddressSetter nameserverAddressSetter) throws MQClientException {
        return InnerTraceProducer.getTraceDispatcherProducer(properties, nameserverAddressSetter, new ClientRPCHook(provider));
    }

    public static InnerTraceProducer getTraceDispatcherProducer(Properties properties, NameServerAddressSetter nameserverAddressSetter, RPCHook rpcHook) throws MQClientException {
        boolean innerProducerSingleton = Boolean.parseBoolean(properties.getProperty("TraceProducerSingleton", "false"));
        if (!innerProducerSingleton) {
            return new InnerTraceProducer(properties, nameserverAddressSetter, rpcHook);
        }
        if (innerTraceProducer == null) {
            innerTraceProducer = new InnerTraceProducer(properties, nameserverAddressSetter, rpcHook);
        }
        return innerTraceProducer;
    }

    public static void registerTraceDispatcher(String dispatcherId, InnerTraceProducer producer, boolean isSingleton) throws MQClientException {
        dispatcherTable.put(dispatcherId, producer);
        if (isSingleton) {
            if (producer != null && isStarted.compareAndSet(false, true)) {
                producer.start();
            }
        } else if (producer != null) {
            producer.start();
        }
    }

    public static void unregisterTraceDispatcher(String dispatcherId, InnerTraceProducer producer, boolean isSingleton) {
        dispatcherTable.remove(dispatcherId);
        if (isSingleton) {
            if (dispatcherTable.isEmpty() && producer != null && isStarted.get()) {
                producer.shutdown();
            }
        } else {
            producer.shutdown();
        }
    }

    public boolean append(OnsTraceContext ctx) {
        boolean result = this.traceContextQueue.offer(ctx);
        if (!result) {
            CLIENT_LOG.info("buffer full" + this.discardCount.incrementAndGet() + " ,context is " + ctx);
        }
        return result;
    }

    public InnerTraceProducer(Properties properties, NameServerAddressSetter nameserverAddressSetter, RPCHook rpcHook) throws MQClientException {
        int queueSize = Integer.parseInt(properties.getProperty("AsyncBufferSize", "2048"));
        this.queueSize = queueSize = 1 << 32 - Integer.numberOfLeadingZeros(queueSize - 1);
        this.batchSize = Integer.parseInt(properties.getProperty("MaxBatchNum", "1"));
        this.discardCount = new AtomicLong(0L);
        this.traceContextQueue = new ArrayBlockingQueue(1024);
        this.appenderQueue = new ArrayBlockingQueue(this.queueSize);
        this.traceExecuter = new ThreadPoolExecutor(this.threadNum, this.threadNum, 60000L, TimeUnit.MILLISECONDS, this.appenderQueue, new ThreadFactoryImpl("MQTraceSendThread_" + this.instanceId + "_"));
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "OnsTrace-UpdateNameServerThread" + InnerTraceProducer.this.instanceId);
            }
        });
        this.nameserverAddressSetter = nameserverAddressSetter;
        this.selectQueueEnable = Boolean.parseBoolean(properties.getProperty("MsgTraceSelectQueueEnable", "true"));
        this.traceProducer = this.createProducer(properties, nameserverAddressSetter, rpcHook);
    }

    private DefaultMQProducer createProducer(Properties properties, NameServerAddressSetter nameserverAddressSetter, RPCHook rpcHook) {
        DefaultMQProducer producer = new DefaultMQProducer(rpcHook);
        String accessKey = properties.getProperty("AccessKey");
        String type = properties.getProperty("DispatcherType");
        producer.setProducerGroup(accessKey + "-" + "_INNER_TRACE_PRODUCER" + "-" + type + "-" + this.instanceId);
        producer.setSendMsgTimeout(5000);
        producer.setInstanceName(this.instanceId + "-" + System.currentTimeMillis());
        producer.setNamesrvAddr(nameserverAddressSetter.getNewNameServerAddress());
        producer.setVipChannelEnabled(false);
        producer.setRetryTimesWhenSendAsyncFailed(0);
        if (properties.getProperty("namespace") != null) {
            producer.setNamespaceV2(properties.getProperty("namespace"));
        }
        int maxSize = Integer.parseInt(properties.getProperty("MaxMsgSize", "128000"));
        producer.setMaxMessageSize(maxSize - 10000);
        return producer;
    }

    private void start() throws MQClientException {
        this.worker = new ThreadFactoryImpl("MQ-AsyncArrayDispatcher-Thread" + this.instanceId, true).newThread(new AsyncRunnable());
        this.worker.start();
        this.traceProducer.start();
        this.registerShutDownHook();
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    String newAddrs = InnerTraceProducer.this.nameserverAddressSetter.getNewNameServerAddress();
                    if (newAddrs != null && !newAddrs.equals(InnerTraceProducer.this.traceNamesrvAddr)) {
                        CLIENT_LOG.info("trace producer update name server address , old is {}, new is {}", (Object)InnerTraceProducer.this.traceNamesrvAddr, (Object)newAddrs);
                        InnerTraceProducer.this.traceNamesrvAddr = newAddrs;
                        InnerTraceProducer.this.traceProducer.setNamesrvAddr(newAddrs);
                        InnerTraceProducer.this.traceProducer.getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(newAddrs);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    private void shutdown() {
        this.flush();
        this.stopped = true;
        this.traceExecuter.shutdown();
        this.removeShutdownHook();
        this.scheduledExecutorService.shutdown();
        this.traceProducer.shutdown();
    }

    private void flush() {
        long end = System.currentTimeMillis() + 500L;
        while (this.traceContextQueue.size() > 0 || this.appenderQueue.size() > 0 && System.currentTimeMillis() <= end) {
            try {
                this.flushTraceContext();
            }
            catch (Throwable throwable) {}
        }
        CLIENT_LOG.info("------end trace send " + this.traceContextQueue.size() + "   " + this.appenderQueue.size());
    }

    private void registerShutDownHook() {
        if (this.shutDownHook == null) {
            this.shutDownHook = new ThreadFactoryImpl("ShutdownHookMQTrace").newThread(new Runnable(){
                private volatile boolean hasShutdown = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.hasShutdown) {
                            try {
                                InnerTraceProducer.this.flush();
                            }
                            catch (Throwable e) {
                                CLIENT_LOG.error("system mqtrace hook shutdown failed ,maybe loss some trace data");
                            }
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
    }

    private void removeShutdownHook() {
        if (this.shutDownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
                this.shutDownHook = null;
            }
            catch (Throwable e) {
                CLIENT_LOG.warn("the shutdown hook already clean");
            }
        }
    }

    private void flushTraceContext() {
        ArrayList<OnsTraceContext> contexts = new ArrayList<OnsTraceContext>(this.batchSize);
        for (int i = 0; i < this.batchSize; ++i) {
            OnsTraceContext context = null;
            try {
                context = this.traceContextQueue.poll(5L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (context == null) break;
            contexts.add(context);
        }
        if (contexts.size() > 0) {
            AsyncAppenderRequest request = new AsyncAppenderRequest(contexts);
            this.traceExecuter.submit(request);
        }
    }

    public static Set<String> tryGetMessageQueueBrokerSet(DefaultMQProducerImpl producer, String topic) {
        HashSet<String> brokerSet = new HashSet<String>();
        String realTopic = NamespaceUtil.wrapNamespace(producer.getDefaultMQProducer().getNamespace(), topic);
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(realTopic);
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            producer.getTopicPublishInfoTable().putIfAbsent(realTopic, new TopicPublishInfo());
            producer.getmQClientFactory().updateTopicRouteInfoFromNameServer(realTopic);
            topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(realTopic);
        }
        if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok()) {
            for (MessageQueue queue : topicPublishInfo.getMessageQueueList()) {
                brokerSet.add(queue.getBrokerName());
            }
        }
        return brokerSet;
    }

    public static Set<String> tryGetMessageQueueBrokerSet(DefaultMQPushConsumerImpl consumer, String topic) {
        HashSet<String> brokerSet = new HashSet<String>();
        try {
            String realTopic = NamespaceUtil.wrapNamespace(consumer.getDefaultMQPushConsumer().getNamespace(), topic);
            Set<MessageQueue> messageQueues = consumer.fetchSubscribeMessageQueues(realTopic);
            for (MessageQueue queue : messageQueues) {
                brokerSet.add(queue.getBrokerName());
            }
        }
        catch (MQClientException e) {
            CLIENT_LOG.info("fetch message queue failed, the topic is {}", (Object)topic);
        }
        return brokerSet;
    }

    class AsyncAppenderRequest
    implements Runnable {
        List<OnsTraceContext> contextList;

        public AsyncAppenderRequest(List<OnsTraceContext> contextList) {
            this.contextList = contextList != null ? contextList : new ArrayList<OnsTraceContext>(1);
        }

        @Override
        public void run() {
            this.sendTraceData(this.contextList);
        }

        public void sendTraceData(List<OnsTraceContext> contextList) {
            HashMap transBeanMap = new HashMap(16);
            String currentRegionId = null;
            for (OnsTraceContext onsTraceContext : contextList) {
                currentRegionId = onsTraceContext.getRegionId();
                if (currentRegionId == null || onsTraceContext.getTraceBeans().isEmpty()) continue;
                String topic = onsTraceContext.getTraceBeans().get(0).getTopic();
                String key = topic + '\u0001' + currentRegionId;
                ArrayList<OnsTraceTransferBean> transBeanList = (ArrayList<OnsTraceTransferBean>)transBeanMap.get(key);
                if (transBeanList == null) {
                    transBeanList = new ArrayList<OnsTraceTransferBean>();
                    transBeanMap.put(key, transBeanList);
                }
                OnsTraceTransferBean traceData = OnsTraceDataEncoder.encoderFromContextBean(onsTraceContext);
                traceData.setBrokerSet(onsTraceContext.getBrokerSet());
                transBeanList.add(traceData);
            }
            for (Map.Entry entry : transBeanMap.entrySet()) {
                String[] key = ((String)entry.getKey()).split(String.valueOf('\u0001'));
                this.flushData((List)entry.getValue(), key[0], key[1]);
            }
        }

        private void flushData(List<OnsTraceTransferBean> transBeanList, String topic, String currentRegionId) {
            if (transBeanList.size() == 0) {
                return;
            }
            StringBuilder buffer = new StringBuilder(1024);
            int count = 0;
            HashSet<String> keySet = new HashSet<String>();
            HashSet<String> brokerSet = new HashSet();
            for (OnsTraceTransferBean bean : transBeanList) {
                brokerSet = bean.getBrokerSet();
                keySet.addAll(bean.getTransKey());
                buffer.append(bean.getTransData());
                ++count;
                if (buffer.length() < InnerTraceProducer.this.traceProducer.getMaxMessageSize()) continue;
                this.sendTraceDataByMQ(keySet, buffer.toString(), topic, currentRegionId, brokerSet);
                buffer.delete(0, buffer.length());
                keySet.clear();
                count = 0;
            }
            if (count > 0) {
                this.sendTraceDataByMQ(keySet, buffer.toString(), topic, currentRegionId, brokerSet);
            }
            transBeanList.clear();
        }

        private void sendTraceDataByMQ(Set<String> keySet, final String data, String dataTopic, String currentRegionId, Set<String> dataBrokerSet) {
            String topic = "rmq_sys_TRACE_DATA_" + currentRegionId;
            Message message = new Message(topic, data.getBytes());
            message.setKeys(keySet);
            SendCallback callback = new SendCallback(){

                @Override
                public void onSuccess(SendResult sendResult) {
                }

                @Override
                public void onException(Throwable e) {
                    CLIENT_LOG.info("send trace data ,the traceData is " + data);
                }
            };
            try {
                if (!InnerTraceProducer.this.selectQueueEnable.booleanValue()) {
                    InnerTraceProducer.this.traceProducer.send(message, callback, 5000L);
                    return;
                }
                Set<String> traceBrokerSet = InnerTraceProducer.tryGetMessageQueueBrokerSet(InnerTraceProducer.this.traceProducer.getDefaultMQProducerImpl(), topic);
                dataBrokerSet.retainAll(traceBrokerSet);
                if (dataBrokerSet.isEmpty()) {
                    InnerTraceProducer.this.traceProducer.send(message, callback, 5000L);
                } else {
                    InnerTraceProducer.this.traceProducer.send(message, new MessageQueueSelector(){

                        @Override
                        public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
                            Set brokerSet = (Set)arg;
                            ArrayList<MessageQueue> filterMqs = new ArrayList<MessageQueue>();
                            for (MessageQueue queue : mqs) {
                                if (!brokerSet.contains(queue.getBrokerName())) continue;
                                filterMqs.add(queue);
                            }
                            int index = InnerTraceProducer.this.sendWhichQueue.getAndIncrement();
                            int pos = Math.abs(index) % filterMqs.size();
                            if (pos < 0) {
                                pos = 0;
                            }
                            return (MessageQueue)filterMqs.get(pos);
                        }
                    }, dataBrokerSet, callback);
                }
            }
            catch (Exception e) {
                CLIENT_LOG.info("send trace data,the traceData is" + data);
            }
        }
    }

    class AsyncRunnable
    implements Runnable {
        private boolean stopped;

        AsyncRunnable() {
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    InnerTraceProducer.this.flushTraceContext();
                    if (!InnerTraceProducer.this.stopped) continue;
                    this.stopped = true;
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

