/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.commons.proto.XstreamPack;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.datahub.DatahubRecordPack;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.StreamUploadWriter$AjcClosure1;
import com.aliyun.odps.tunnel.StreamUploadWriter$AjcClosure3;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class StreamUploadWriter {
    private RestClient tunnelServiceClient;
    private String path;
    private MessageDigest messageDigest;
    private HashMap<String, String> params;
    private HashMap<String, String> headers;
    private TunnelTableSchema schema;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public StreamUploadWriter(RestClient tunnelServiceClient, String path) throws TunnelException {
        this.path = path;
        this.tunnelServiceClient = tunnelServiceClient;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.headers = new HashMap();
        this.headers.put("Content-Length", "0");
        this.headers.put("x-odps-tunnel-stream-version", "1");
        this.params = new HashMap();
        this.initiate();
        this.headers.put("Content-Type", "application/octet-stream");
        this.headers.put("x-odps-tunnel-version", String.valueOf(4));
    }

    public StreamUploadWriter(RestClient tunnelServiceClient, String path, HashMap<String, String> params, HashMap<String, String> headers, TunnelTableSchema schema) {
        this.tunnelServiceClient = tunnelServiceClient;
        this.path = path;
        this.params = params;
        this.headers = headers;
        this.schema = schema;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void initiate() throws TunnelException {
        block13: {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("query", "meta");
            Connection conn = null;
            try {
                Connection connection = conn = this.tunnelServiceClient.connect(this.path, "GET", param, this.headers);
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
                Object[] objectArray = new Object[]{this, connection, joinPoint};
                Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new StreamUploadWriter$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block13;
                }
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (null != conn) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        try {
            ObjectMapper mapper = JacksonParser.getObjectMapper();
            JsonNode tree = mapper.readTree(is);
            JsonNode node = tree.get("Schema");
            if (null == node || node.isNull()) {
                throw new TunnelException("Get table type failed");
            }
            this.schema = new TunnelTableSchema(node);
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    public void write(DatahubRecordPack recordPack) throws TunnelException, IOException {
        this.write(null, recordPack);
    }

    public void write(PartitionSpec partitionSpec, DatahubRecordPack recordPack) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Encoding", "deflate");
        try {
            byte[] bytes = recordPack.getByteArray();
            XstreamPack.XStreamPack.Builder pack = XstreamPack.XStreamPack.newBuilder();
            pack.setPackData(ByteString.copyFrom((byte[])bytes));
            bytes = pack.build().toByteArray();
            if (null != partitionSpec && partitionSpec.toString().length() > 0) {
                params.put("partition", partitionSpec.toString().replace("'", ""));
            }
            params.put("recordcount", String.valueOf(recordPack.getRecordCount()));
            params.put("mode", "streamupload");
            headers.put("Content-MD5", this.generateMD5(bytes));
            int n = bytes.length;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            HashMap<String, String> hashMap = headers;
            HashMap<String, String> hashMap2 = params;
            String string = "PUT";
            String string2 = this.path;
            RestClient restClient = this.tunnelServiceClient;
            Object[] objectArray = new Object[]{string2, string, hashMap2, hashMap, byteArrayInputStream, Conversions.intObject((int)n)};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)restClient, (Object[])objectArray);
            Object[] objectArray2 = new Object[]{this, restClient, string2, string, hashMap2, hashMap, byteArrayInputStream, Conversions.intObject((int)n), joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new StreamUploadWriter$AjcClosure3(objectArray2).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                TunnelException ex = new TunnelException(new ByteArrayInputStream(resp.getBody()));
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(e.getMessage(), e);
        }
    }

    public TunnelTableSchema getSchema() {
        return this.schema;
    }

    private String generateMD5(byte[] bytes) {
        byte[] digest = this.messageDigest.digest(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    static {
        StreamUploadWriter.ajc$preClinit();
    }

    static /* synthetic */ Response getResponse_aroundBody0(StreamUploadWriter streamUploadWriter, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response requestForRawResponse_aroundBody2(StreamUploadWriter streamUploadWriter, RestClient restClient, String string, String string2, Map map, Map map2, InputStream inputStream, int n, JoinPoint joinPoint) {
        return restClient.requestForRawResponse(string, string2, map, map2, inputStream, n);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StreamUploadWriter.java", StreamUploadWriter.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 83);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "requestForRawResponse", "com.aliyun.odps.rest.RestClient", "java.lang.String:java.lang.String:java.util.Map:java.util.Map:java.io.InputStream:int", "resource:method:params:headers:body:length", "com.aliyun.odps.OdpsException:java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 167);
    }
}

