/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.util.JacksonParser;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="LOT")
public class LOTTask
extends Task {
    private Plan plan;
    private String query;

    public Plan getPlan() {
        return this.plan;
    }

    public String getQuery() {
        return this.query;
    }

    @XmlElement(name="Query")
    public void setQuery(String query) {
        this.query = query;
    }

    @XmlElement(name="Plan")
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public static Instance run(Odps odps, String input, boolean runSQL) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return LOTTask.run(odps, project, input, runSQL, "AnonymousLOTTask", null, null);
    }

    public static Instance run(Odps odps, String project, String input, boolean runSQL, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return LOTTask.run(odps, project, input, runSQL, "AnonymousLOTTask", hints, aliases);
    }

    public static Instance run(Odps odps, String project, String input, boolean runSQL, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        String json;
        LOTTask task = new LOTTask();
        if (runSQL) {
            task.setQuery(input);
        } else {
            Plan plan = new Plan();
            plan.setResourceName(input);
            plan.setProject(project);
            task.setPlan(plan);
        }
        task.setName(taskName);
        if (hints != null) {
            try {
                json = JacksonParser.getObjectMapper().writeValueAsString(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = JacksonParser.getObjectMapper().writeValueAsString(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return odps.instances().create(project, task);
    }

    @XmlType(name="plan", propOrder={"resourceName", "project"})
    public static class Plan {
        private String resourceName;
        private String project;

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @XmlElement(name="ResourceName")
        public String getResourceName() {
            return this.resourceName;
        }

        public void setProject(String project) {
            this.project = project;
        }

        @XmlElement(name="Project")
        public String getProject() {
            return this.project;
        }
    }
}

