/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.security;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.RestClient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class User
extends LazyLoad {
    private UserModel model;
    private String project;
    private RestClient client;

    User(UserModel model, String project, RestClient client) {
        this.model = model;
        this.project = project;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/users/").append(this.model.id);
        this.model = this.client.request(UserModel.class, resource.toString(), "GET");
        this.setLoaded(true);
    }

    public String getID() {
        return this.model.id;
    }

    public String getDisplayname() {
        return this.model.displayName;
    }

    public String getComment() {
        this.lazyLoad();
        return this.model.comment;
    }

    @XmlRootElement(name="User")
    static class UserModel {
        @XmlElement(name="ID")
        String id;
        @XmlElement(name="DisplayName")
        String displayName;
        @XmlElement(name="Comment")
        String comment;

        UserModel() {
        }
    }
}

