/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.security;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.security.CheckPermissionConstants;
import com.aliyun.odps.security.Role;
import com.aliyun.odps.security.SecurityConfiguration;
import com.aliyun.odps.security.User;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class SecurityManager {
    private String project;
    private RestClient client;
    private SecurityConfiguration securityConfigration;

    public SecurityManager(String project, RestClient client) {
        this.project = project;
        this.client = client;
        this.securityConfigration = null;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        if (this.securityConfigration == null) {
            this.securityConfigration = new SecurityConfiguration(this.project, this.client);
        }
        return this.securityConfigration;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfigration) throws OdpsException {
        securityConfigration.update(null);
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfigration, String supervisionToken) throws OdpsException {
        securityConfigration.update(supervisionToken);
    }

    public String getProjectPolicy() throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        Response response = this.client.request(resource.toString(), "GET", params, null, null);
        try {
            return new String(response.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException("Can't parse response!", e);
        }
    }

    public void putProjectPolicy(String policy) throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        this.client.stringRequest(resource.toString(), "PUT", params, null, policy);
    }

    public String getRolePolicy(String roleName) throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/roles/").append(roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        Response response = this.client.request(resource.toString(), "GET", params, null, null);
        try {
            return new String(response.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OdpsException("Can't parse response!", e);
        }
    }

    public void putRolePolicy(String roleName, String policy) throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/roles/").append(roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        this.client.stringRequest(resource.toString(), "PUT", params, null, policy);
    }

    public List<User> listUsers() throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/users");
        ListUsersResponse resp = this.client.request(ListUsersResponse.class, resource.toString(), "GET");
        ArrayList<User> users = new ArrayList<User>();
        for (User.UserModel model : resp.users) {
            User t = new User(model, this.project, this.client);
            users.add(t);
        }
        return users;
    }

    public List<Role> listRoles() throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/roles");
        ListRolesResponse resp = this.client.request(ListRolesResponse.class, resource.toString(), "GET");
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Role.RoleModel model : resp.roles) {
            Role t = new Role(model, this.project, this.client);
            roles.add(t);
        }
        return roles;
    }

    public List<Role> listRolesForUser(String uid) throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/users/").append(uid);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roles", null);
        ListRolesResponse resp = this.client.request(ListRolesResponse.class, resource.toString(), "GET", params, null, null);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Role.RoleModel model : resp.roles) {
            Role t = new Role(model, this.project, this.client);
            roles.add(t);
        }
        return roles;
    }

    public List<User> listUsersForRole(String roleName) throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/roles/").append(roleName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("users", null);
        ListUsersResponse resp = this.client.request(ListUsersResponse.class, resource.toString(), "GET", params, null, null);
        ArrayList<User> users = new ArrayList<User>();
        for (User.UserModel model : resp.users) {
            User t = new User(model, this.project, this.client);
            users.add(t);
        }
        return users;
    }

    public CheckPermissionConstants.CheckPermissionResult checkPermission(CheckPermissionConstants.ObjectType type, String objectName, CheckPermissionConstants.ActionType action) throws OdpsException {
        return this.checkPermission(type, objectName, action, this.project);
    }

    public CheckPermissionConstants.CheckPermissionResult checkPermission(CheckPermissionConstants.ObjectType type, String objectName, CheckPermissionConstants.ActionType action, String projectName) throws OdpsException {
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(projectName).append("/auth/");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type.toString());
        params.put("name", objectName);
        params.put("grantee", action.toString());
        CheckPermissionResponse response = this.client.request(CheckPermissionResponse.class, resource.toString(), "GET", params, null, null);
        System.out.println(response.getResult());
        return response.getResult().toUpperCase().equals("ALLOW") ? CheckPermissionConstants.CheckPermissionResult.Allow : CheckPermissionConstants.CheckPermissionResult.Deny;
    }

    public String runQuery(String query, Boolean jsonOutput) throws OdpsException {
        return this.runQuery(query, jsonOutput, null);
    }

    public String runQuery(String query, Boolean jsonOutput, String supervisionToken) throws OdpsException {
        String xmlRequest;
        StringBuilder resource = new StringBuilder();
        resource.append("/projects/").append(this.project).append("/authorization");
        AuthorizationQueryRequest request = new AuthorizationQueryRequest(query, jsonOutput);
        try {
            xmlRequest = JAXBUtils.marshal(request, AuthorizationQueryRequest.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (supervisionToken != null) {
            headers.put("odps-x-supervision-token", supervisionToken);
        }
        headers.put("Content-Type", "application/xml");
        AuthorizationQueryResponse response = this.client.stringRequest(AuthorizationQueryResponse.class, resource.toString(), "POST", null, headers, xmlRequest);
        return response.getResult();
    }

    public String generateAuthorizationToken(String policy, String type) throws OdpsException {
        if (type.equalsIgnoreCase("Bearer")) {
            StringBuilder resource = new StringBuilder();
            resource.append("/projects/").append(this.project).append("/authorization");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sign_bearer_token", null);
            AuthorizationQueryResponse response = this.client.stringRequest(AuthorizationQueryResponse.class, resource.toString(), "POST", params, headers, policy);
            return response.getResult();
        }
        throw new OdpsException("Unsupport token type" + type);
    }

    @XmlRootElement(name="Auth")
    private static class CheckPermissionResponse {
        @XmlElement(name="Result")
        private String result;

        private CheckPermissionResponse() {
        }

        public String getResult() {
            return this.result;
        }
    }

    @XmlRootElement(name="Roles")
    private static class ListRolesResponse {
        @XmlElement(name="Role")
        private List<Role.RoleModel> roles = new ArrayList<Role.RoleModel>();

        private ListRolesResponse() {
        }
    }

    @XmlRootElement(name="Users")
    private static class ListUsersResponse {
        @XmlElement(name="User")
        private List<User.UserModel> users = new ArrayList<User.UserModel>();

        private ListUsersResponse() {
        }
    }

    @XmlRootElement(name="Authorization")
    private static class AuthorizationQueryResponse {
        @XmlElement(name="Result")
        private String result;

        private AuthorizationQueryResponse() {
        }

        public String getResult() {
            return this.result;
        }
    }

    @XmlRootElement(name="Authorization")
    private static class AuthorizationQueryRequest {
        @XmlElement(name="Query")
        private String query;
        @XmlElement(name="ResponseInJsonFormat")
        private boolean responseInJsonFormat;

        public AuthorizationQueryRequest() {
            this.query = "";
            this.responseInJsonFormat = true;
        }

        public AuthorizationQueryRequest(String query, boolean jsonFormat) {
            this.query = query;
            this.responseInJsonFormat = jsonFormat;
        }
    }
}

