/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.datahub;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.commons.util.JacksonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonNode;

public class DatahubException
extends OdpsException {
    private String requestId;
    private String errorCode;
    private String errorMsg;

    public DatahubException() {
    }

    public DatahubException(String message) {
        super(message);
        this.errorCode = "Local Error";
        this.errorMsg = message;
    }

    public DatahubException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = "Local Error";
        this.errorMsg = message;
    }

    public DatahubException(InputStream is) {
        String message = "";
        try {
            byte[] bytes = IOUtils.readFully(is);
            message = new String(bytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            this.loadFromJson(bis);
        }
        catch (Exception e) {
            throw new RuntimeException("Parse responsed failed: '" + message + "'", e);
        }
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.requestId != null) {
            sb.append("RequestId=").append(this.requestId);
        }
        if (this.errorCode != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("ErrorCode=").append(this.errorCode);
        }
        if (this.errorMsg != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (this.requestId != null || this.errorCode != null) {
                sb.append("ErrorMessage=");
            }
            sb.append(this.errorMsg);
        }
        return sb.toString();
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    private void loadFromJson(InputStream is) throws DatahubException, IOException {
        try {
            JsonNode tree = JacksonParser.getObjectMapper().readTree(is);
            JsonNode node = tree.get("Code");
            if (node != null && !node.isNull()) {
                this.errorCode = node.asText();
            }
            if ((node = tree.get("Message")) != null && !node.isNull()) {
                this.errorMsg = node.asText();
            }
        }
        catch (Exception e) {
            throw new DatahubException("Parse response failed", e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

