/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.datahub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.datahub.DatahubClient$AjcClosure1;
import com.aliyun.odps.datahub.DatahubClient$AjcClosure3;
import com.aliyun.odps.datahub.DatahubClient$AjcClosure5;
import com.aliyun.odps.datahub.DatahubClient$AjcClosure7;
import com.aliyun.odps.datahub.DatahubConfiguration;
import com.aliyun.odps.datahub.DatahubException;
import com.aliyun.odps.datahub.DatahubReader;
import com.aliyun.odps.datahub.DatahubTableSchema;
import com.aliyun.odps.datahub.DatahubWriter;
import com.aliyun.odps.datahub.PackReader;
import com.aliyun.odps.datahub.ReplicatorStatus;
import com.aliyun.odps.rest.RestClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class DatahubClient {
    private String projectName;
    private String tableName;
    private DatahubConfiguration conf;
    private RestClient datahubServiceClient;
    private HashMap<String, String> headers;
    private TableSchema schema = new TableSchema();
    private List<Long> shards = new ArrayList<Long>();
    private final Long MAX_WAITING_MILLISECOND = 120000L;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public DatahubClient(Odps odps, String projectName, String tableName, String datahubEndpoint) throws OdpsException {
        this.conf = new DatahubConfiguration(odps);
        this.projectName = projectName;
        this.tableName = tableName;
        this.headers = new HashMap();
        this.headers.put("Content-Length", String.valueOf(0));
        this.headers.put("x-odps-tunnel-stream-version", "1");
        this.setEndpoint(datahubEndpoint);
        this.initiate();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void loadShard(long shardNumber) throws OdpsException {
        if (shardNumber < 0L) {
            throw new DatahubException("invalid shard number");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        String path = this.getResource() + "/shards";
        Connection conn = null;
        try {
            params.put("shardnumber", Long.toString(shardNumber));
            Connection connection = conn = this.datahubServiceClient.connect(path, "POST", params, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new DatahubClient$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                DatahubException ex = new DatahubException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
        }
        catch (IOException e) {
            throw new DatahubException(e.getMessage(), e);
        }
        catch (DatahubException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new DatahubException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void waitForShardLoad() throws OdpsException {
        this.waitForShardLoad(this.MAX_WAITING_MILLISECOND);
    }

    public void waitForShardLoad(long timeout) throws OdpsException {
        if (timeout <= 0L) {
            throw new DatahubException("invalid waiting time");
        }
        long waitTime = timeout > this.MAX_WAITING_MILLISECOND ? this.MAX_WAITING_MILLISECOND : timeout;
        long now = System.currentTimeMillis();
        long end = now + waitTime;
        while (now < end) {
            try {
                if (this.isShardLoadCompleted()) {
                    return;
                }
                Thread.sleep(10000L);
                now = System.currentTimeMillis();
            }
            catch (Exception e) {
                throw new DatahubException(e.getMessage(), e);
            }
        }
        if (!this.isShardLoadCompleted()) {
            throw new DatahubException("load shard timeout");
        }
    }

    private boolean isShardLoadCompleted() {
        try {
            HashMap<Long, ShardState> shardStatusMap = this.getShardStatus();
            for (Map.Entry<Long, ShardState> entry : shardStatusMap.entrySet()) {
                ShardState status = entry.getValue();
                if (status == ShardState.LOADED) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public HashMap<Long, ShardState> getShardStatus() throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> hdrs = new HashMap<String, String>(this.headers);
        try {
            Connection conn;
            String path = this.getResource() + "/shards";
            hdrs.put("x-odps-tunnel-version", String.valueOf(4));
            params.put("shardstatus", null);
            Connection connection = conn = this.datahubServiceClient.connect(path, "GET", params, hdrs);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new DatahubClient$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                DatahubException ex = new DatahubException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            return this.loadShardStatusFromJson(conn.getInputStream());
        }
        catch (Exception e) {
            throw new DatahubException(e.getMessage(), e);
        }
    }

    public ReplicatorStatus QueryReplicatorStatus(long shardId, PartitionSpec partitionSpec) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        params.put("query", "replicator");
        if (partitionSpec != null && partitionSpec.toString().length() > 0) {
            params.put("partition", partitionSpec.toString().replaceAll("'", ""));
        }
        String path = this.getStreamResource(shardId);
        Connection conn = null;
        try {
            Connection connection = conn = this.datahubServiceClient.connect(path, "GET", params, headers);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new DatahubClient$AjcClosure5(objectArray).linkClosureAndJoinPoint(4112));
            if (!resp.isOK()) {
                DatahubException ex = new DatahubException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            ReplicatorStatus replicatorStatus = new ReplicatorStatus(conn.getInputStream());
            return replicatorStatus;
        }
        catch (IOException e) {
            throw new DatahubException(e.getMessage(), e);
        }
        catch (DatahubException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new DatahubException(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setEndpoint(String endpoint) throws OdpsException {
        try {
            URI u = new URI(endpoint);
            this.conf.setEndpoint(u);
            this.datahubServiceClient = this.conf.newRestClient(this.projectName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint.");
        }
        catch (DatahubException e) {
            throw e;
        }
        catch (OdpsException e) {
            throw new DatahubException(e.getMessage(), e);
        }
    }

    public ReplicatorStatus QueryReplicatorStatus(long shardId) throws OdpsException {
        return this.QueryReplicatorStatus(shardId, null);
    }

    private void initiate() throws OdpsException {
        block13: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("query", "meta");
            params.put("type", "stream");
            Connection conn = null;
            try {
                this.datahubServiceClient = this.conf.newRestClient(this.projectName);
                Connection connection = conn = this.datahubServiceClient.connect(this.getResource(), "GET", params, this.headers);
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)connection);
                Object[] objectArray = new Object[]{this, connection, joinPoint};
                Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new DatahubClient$AjcClosure7(objectArray).linkClosureAndJoinPoint(4112));
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block13;
                }
                DatahubException e = new DatahubException(conn.getInputStream());
                e.setRequestId(resp.getHeader("x-odps-request-id"));
                throw e;
            }
            catch (IOException e) {
                throw new DatahubException(e.getMessage(), e);
            }
            catch (DatahubException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new DatahubException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public TableSchema getStreamSchema() {
        return this.schema;
    }

    public List<Long> getShardList() {
        return this.shards;
    }

    public DatahubWriter openDatahubWriter(long shardId) throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new DatahubWriter(this.datahubServiceClient, this.getStreamResource(shardId), params, headers);
    }

    public DatahubWriter openDatahubWriter() throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new DatahubWriter(this.datahubServiceClient, this.getStreamResource(), params, headers);
    }

    public DatahubReader openDatahubReader(long shardId) throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new DatahubReader(this.datahubServiceClient, this.schema, this.getStreamResource(shardId), params, headers);
    }

    public DatahubReader openDatahubReader(long shardId, String packId) throws OdpsException, IOException {
        if (packId == null) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new DatahubReader(this.datahubServiceClient, this.schema, this.getStreamResource(shardId), params, headers, packId);
    }

    public PackReader openPackReader(long shardId) throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new PackReader(this.datahubServiceClient, this.schema, this.getStreamResource(shardId), params, headers);
    }

    public PackReader openPackReader(long shardId, String packId) throws OdpsException, IOException {
        if (packId == null) {
            throw new IllegalArgumentException("Invalid pack id.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new PackReader(this.datahubServiceClient, this.schema, this.getStreamResource(shardId), params, headers, packId);
    }

    private String getResource() {
        return this.conf.getResource(this.projectName, this.tableName);
    }

    private String getStreamResource(long shardId) {
        return this.conf.getStreamUploadResource(this.projectName, this.tableName, shardId);
    }

    private String getStreamResource() {
        return this.conf.getStreamUploadResource(this.projectName, this.tableName);
    }

    private void loadFromJson(InputStream is) throws OdpsException {
        block6: {
            try {
                ObjectMapper mapper = JacksonParser.getObjectMapper();
                JsonNode tree = mapper.readTree(is);
                JsonNode node = tree.get("Schema");
                if (node == null || node.isNull()) {
                    throw new DatahubException("get table schema fail");
                }
                this.schema = new DatahubTableSchema(node);
                node = tree.get("Shards");
                if (node != null && !node.isNull()) {
                    if (node.isArray()) {
                        Iterator it = node.getElements();
                        while (it.hasNext()) {
                            JsonNode shardId = (JsonNode)it.next();
                            this.shards.add(shardId.asLong());
                        }
                    }
                    break block6;
                }
                throw new DatahubException("get shard fail");
            }
            catch (Exception e) {
                throw new DatahubException("Invalid json content.", e);
            }
        }
    }

    private HashMap<Long, ShardState> loadShardStatusFromJson(InputStream is) throws OdpsException {
        try {
            HashMap<Long, ShardState> shardStatus = new HashMap<Long, ShardState>();
            ObjectMapper mapper = JacksonParser.getObjectMapper();
            JsonNode tree = mapper.readTree(is);
            JsonNode node = tree.get("ShardStatus");
            if (node != null && !node.isNull() && node.isArray()) {
                Iterator it = node.getElements();
                while (it.hasNext()) {
                    JsonNode status = (JsonNode)it.next();
                    ShardState state = ShardState.valueOf(status.get("State").asText().toUpperCase());
                    shardStatus.put(Long.parseLong(status.get("ShardId").asText()), state);
                }
            }
            return shardStatus;
        }
        catch (Exception e) {
            throw new DatahubException("Invalid json content.", e);
        }
    }

    static {
        DatahubClient.ajc$preClinit();
    }

    static /* synthetic */ Response getResponse_aroundBody0(DatahubClient datahubClient, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody2(DatahubClient datahubClient, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody4(DatahubClient datahubClient, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody6(DatahubClient datahubClient, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DatahubClient.java", DatahubClient.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 117);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 240);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 279);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 349);
    }

    public static enum ShardState {
        UNLOADED,
        LOADED,
        LOADING;

    }
}

