/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.proto;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.xerial.snappy.SnappyFramedInputStream;

public class ProtobufRecordStreamReader
implements RecordReader {
    private BufferedInputStream bin;
    private CodedInputStream in;
    private Column[] columns;
    private long count;
    private long bytesReaded = 0L;
    private Checksum crc = new Checksum();
    private Checksum crccrc = new Checksum();

    public ProtobufRecordStreamReader(TableSchema schema, InputStream in) throws IOException {
        this(schema, null, in, new CompressOption());
    }

    public ProtobufRecordStreamReader(TableSchema schema, InputStream in, CompressOption option) throws IOException {
        this(schema, null, in, option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamReader(TableSchema schema, List<Column> columns, InputStream in, CompressOption option) throws IOException {
        if (columns == null) {
            this.columns = schema.getColumns().toArray(new Column[0]);
        } else {
            Column[] tmpColumns = new Column[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                tmpColumns[i] = schema.getColumn(columns.get(i).getName());
            }
            this.columns = tmpColumns;
        }
        this.bin = new BufferedInputStream(in);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.in = CodedInputStream.newInstance((InputStream)new InflaterInputStream(this.bin));
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                this.in = CodedInputStream.newInstance((InputStream)new SnappyFramedInputStream((InputStream)this.bin));
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                this.in = CodedInputStream.newInstance((InputStream)this.bin);
            }
        } else {
            this.in = CodedInputStream.newInstance((InputStream)this.bin);
        }
        this.in.setSizeLimit(Integer.MAX_VALUE);
    }

    public Record read(Record reuseRecord) throws IOException {
        int checkSum;
        block27: {
            int i;
            if (reuseRecord == null) {
                reuseRecord = new ArrayRecord(this.columns);
            } else {
                for (int i2 = 0; i2 < reuseRecord.getColumnCount(); ++i2) {
                    reuseRecord.set(i2, null);
                }
            }
            block11: while (true) {
                checkSum = 0;
                if (this.in.isAtEnd()) {
                    throw new IOException("No more record");
                }
                i = ProtobufRecordStreamReader.getTagFieldNumber(this.in);
                if (i == 33553408) {
                    checkSum = (int)this.crc.getValue();
                    if (this.in.readUInt32() != checkSum) {
                        throw new IOException("Checksum invalid.");
                    }
                    break block27;
                }
                if (i == 0x1FFFFFE) {
                    if (this.count != this.in.readSInt64()) {
                        throw new IOException("count does not match.");
                    }
                    if (0x1FFFFFF != ProtobufRecordStreamReader.getTagFieldNumber(this.in)) {
                        throw new IOException("Invalid stream.");
                    }
                    if ((int)this.crccrc.getValue() != this.in.readUInt32()) {
                        throw new IOException("Checksum invalid.");
                    }
                    if (!this.in.isAtEnd()) {
                        throw new IOException("Expect at the end of stream, but not.");
                    }
                    return null;
                }
                if (i > this.columns.length) {
                    throw new IOException("Invalid protobuf tag. Perhaps the datastream from server is crushed.");
                }
                this.crc.update(i);
                switch (this.columns[i - 1].getType()) {
                    case DOUBLE: {
                        double v = this.in.readDouble();
                        this.crc.update(v);
                        reuseRecord.setDouble(i - 1, Double.valueOf(v));
                        continue block11;
                    }
                    case BOOLEAN: {
                        boolean v = this.in.readBool();
                        this.crc.update(v);
                        reuseRecord.setBoolean(i - 1, Boolean.valueOf(v));
                        continue block11;
                    }
                    case BIGINT: {
                        long v = this.in.readSInt64();
                        this.crc.update(v);
                        reuseRecord.setBigint(i - 1, Long.valueOf(v));
                        continue block11;
                    }
                    case STRING: {
                        int size = this.in.readRawVarint32();
                        byte[] bytes = this.in.readRawBytes(size);
                        this.crc.update(bytes, 0, bytes.length);
                        reuseRecord.setString(i - 1, bytes);
                        this.bytesReaded += (long)this.in.getTotalBytesRead();
                        this.in.resetSizeCounter();
                        continue block11;
                    }
                    case DATETIME: {
                        long v = this.in.readSInt64();
                        this.crc.update(v);
                        reuseRecord.setDatetime(i - 1, DateUtils.ms2date(v));
                        continue block11;
                    }
                    case DECIMAL: {
                        int size = this.in.readRawVarint32();
                        byte[] bytes = this.in.readRawBytes(size);
                        this.crc.update(bytes, 0, bytes.length);
                        BigDecimal decimal = new BigDecimal(new String(bytes, "UTF-8"));
                        reuseRecord.setDecimal(i - 1, decimal);
                        continue block11;
                    }
                    case ARRAY: {
                        List genericTypeList = this.columns[i - 1].getGenericTypeList();
                        if (genericTypeList == null || genericTypeList.isEmpty()) {
                            throw new IOException("Failed to get OdpsType inside Array of column index: " + (i - 1));
                        }
                        if (reuseRecord instanceof ArrayRecord) {
                            ((ArrayRecord)reuseRecord).setArray(i - 1, this.readArray((OdpsType)genericTypeList.get(0)));
                            continue block11;
                        }
                        throw new IOException("Only ArrayRecord support Array type: " + reuseRecord.getClass().getName());
                    }
                    case MAP: {
                        List genericTypeList = this.columns[i - 1].getGenericTypeList();
                        if (genericTypeList == null || genericTypeList.isEmpty() || genericTypeList.size() < 2) {
                            throw new IOException("Failed to get OdpsType inside Map of column index: " + (i - 1));
                        }
                        if (reuseRecord instanceof ArrayRecord) {
                            ((ArrayRecord)reuseRecord).setMap(i - 1, this.readMap((OdpsType)genericTypeList.get(0), (OdpsType)genericTypeList.get(1)));
                            continue block11;
                        }
                        throw new IOException("Only ArrayRecord support Map type: " + reuseRecord.getClass().getName());
                    }
                }
                break;
            }
            throw new IOException("Unsupported type " + this.columns[i - 1].getType());
        }
        this.crc.reset();
        this.crccrc.update(checkSum);
        this.bytesReaded += (long)this.in.getTotalBytesRead();
        this.in.resetSizeCounter();
        ++this.count;
        return reuseRecord;
    }

    static int getTagFieldNumber(CodedInputStream in) throws IOException {
        return WireFormat.getTagFieldNumber((int)in.readTag());
    }

    @Override
    public Record read() throws IOException {
        return this.read(null);
    }

    public Record createEmptyRecord() throws IOException {
        return new ArrayRecord(this.columns);
    }

    @Override
    public void close() throws IOException {
        if (this.bin != null) {
            this.bin.close();
        }
    }

    public long getTotalBytes() {
        return this.bytesReaded;
    }

    public List readArray(OdpsType type) throws IOException {
        int arraySize = this.in.readUInt32();
        ArrayList<Object> list = null;
        switch (type) {
            case STRING: {
                list = new ArrayList<Object>();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    int size = this.in.readRawVarint32();
                    byte[] bytes = this.in.readRawBytes(size);
                    this.crc.update(bytes, 0, bytes.length);
                    list.add(bytes);
                }
                break;
            }
            case BIGINT: {
                list = new ArrayList();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    Long value = this.in.readSInt64();
                    this.crc.update(value);
                    list.add(value);
                }
                break;
            }
            case DOUBLE: {
                list = new ArrayList();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    Double value = this.in.readDouble();
                    this.crc.update(value);
                    list.add(value);
                }
                break;
            }
            case BOOLEAN: {
                list = new ArrayList();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    Boolean value = this.in.readBool();
                    this.crc.update(value);
                    list.add(value);
                }
                break;
            }
            default: {
                throw new IOException("Unsupport array type. type :" + type);
            }
        }
        return list;
    }

    public Map readMap(OdpsType keyType, OdpsType valueType) throws IOException {
        List keyArray = this.readArray(keyType);
        List valueArray = this.readArray(valueType);
        if (keyArray.size() != valueArray.size()) {
            throw new IOException("Read Map error: key value does not match.");
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keyArray.size(); ++i) {
            map.put(keyArray.get(i), valueArray.get(i));
        }
        return map;
    }
}

