/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Topology
extends LazyLoad {
    private String project;
    private TopologyModel model;
    private RestClient client;

    public Topology(TopologyModel model, String projectName, RestClient client) {
        this.project = projectName;
        this.model = model;
        this.client = client;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildTopologyResource(this.project, this.model.name);
        Response resp = this.client.request(resource, "GET", null, null, null);
        try {
            this.model = JAXBUtils.unmarshal(resp, TopologyModel.class);
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + TopologyModel.class, e);
        }
        try {
            this.model.lastModifiedTime = DateUtils.parseRfc822Date(resp.getHeader("Last_Modified"));
            this.model.createdTime = DateUtils.parseRfc822Date(resp.getHeader("x-odps-creation-time"));
            this.model.owner = resp.getHeader("x-odps-owner");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLoaded(true);
    }

    public String getName() {
        return this.model.name;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public String getDescription() {
        if (this.model.definition == null) {
            this.lazyLoad();
        }
        return this.model.definition;
    }

    @XmlRootElement(name="Topology")
    static class TopologyModel {
        @XmlElement(name="Name")
        String name;
        @XmlElement(name="Owner")
        String owner;
        @XmlElement(name="Comment")
        String comment;
        @XmlElement(name="CreationTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date createdTime;
        @XmlElement(name="LastModifiedTime")
        @XmlJavaTypeAdapter(value=JAXBUtils.DateBinding.class)
        Date lastModifiedTime;
        @XmlElement(name="Definition")
        String definition;

        TopologyModel() {
        }
    }
}

