/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Job;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHook;
import java.util.ArrayList;
import java.util.List;

public class OdpsHooks {
    private static boolean enabled = true;
    private static List<Class<? extends OdpsHook>> registeredHooks = new ArrayList<Class<? extends OdpsHook>>();
    private List<OdpsHook> runningHooks = new ArrayList<OdpsHook>();

    public OdpsHooks() {
        try {
            for (Class<? extends OdpsHook> hookClass : registeredHooks) {
                this.runningHooks.add(hookClass.newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void before(Job job, Odps odps) throws OdpsException {
        for (OdpsHook hook : this.runningHooks) {
            hook.before(job, odps);
        }
    }

    public void onInstanceCreated(Instance instance, Odps odps) throws OdpsException {
        for (OdpsHook hook : this.runningHooks) {
            hook.onInstanceCreated(instance, odps);
        }
    }

    public void after(Instance instance, Odps odps) throws OdpsException {
        for (OdpsHook hook : this.runningHooks) {
            hook.after(instance, odps);
        }
    }

    public static void registerHook(Class<? extends OdpsHook> hook) {
        registeredHooks.add(hook);
    }

    public static List<Class<? extends OdpsHook>> getRegisteredHooks() {
        return registeredHooks;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        OdpsHooks.enabled = enabled;
    }
}

